/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.classfile;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import software.coley.cafedude.classfile.ClassMember;
import software.coley.cafedude.classfile.ConstPool;
import software.coley.cafedude.classfile.Field;
import software.coley.cafedude.classfile.Method;
import software.coley.cafedude.classfile.attribute.Attribute;
import software.coley.cafedude.classfile.behavior.AttributeHolder;
import software.coley.cafedude.classfile.behavior.CpAccessor;
import software.coley.cafedude.classfile.constant.CpClass;
import software.coley.cafedude.classfile.constant.CpEntry;
import software.coley.cafedude.io.AttributeContext;

public class ClassFile
implements AttributeHolder,
CpAccessor {
    private final ConstPool pool;
    private List<CpClass> interfaceClasses;
    private List<Field> fields;
    private List<Method> methods;
    private List<Attribute> attributes;
    private int access;
    private int versionMinor;
    private int versionMajor;
    private CpClass thisClass;
    private CpClass superClass;

    public ClassFile(int versionMinor, int versionMajor, ConstPool pool, int access, CpClass thisClass, CpClass superClass, List<CpClass> interfaceClasses, List<Field> fields, List<Method> methods, List<Attribute> attributes) {
        this.versionMinor = versionMinor;
        this.versionMajor = versionMajor;
        this.pool = pool;
        this.access = access;
        this.thisClass = thisClass;
        this.superClass = superClass;
        this.interfaceClasses = interfaceClasses;
        this.fields = fields;
        this.methods = methods;
        this.attributes = attributes;
    }

    @Nonnull
    public String getName() {
        return this.thisClass.getName().getText();
    }

    @Nullable
    public String getSuperName() {
        if (this.superClass == null) {
            return null;
        }
        return this.superClass.getName().getText();
    }

    @Nullable
    public CpEntry getCp(int index) {
        return this.pool.get(index);
    }

    public void setCp(int index, @Nonnull CpEntry entry) {
        this.pool.set(index, entry);
    }

    @Nonnull
    public ConstPool getPool() {
        return this.pool;
    }

    @Nonnull
    public List<CpClass> getInterfaceClasses() {
        return this.interfaceClasses;
    }

    public void setInterfaceClasses(@Nonnull List<CpClass> interfaceClasses) {
        this.interfaceClasses = interfaceClasses;
    }

    @Nonnull
    public List<Field> getFields() {
        return this.fields;
    }

    public void setFields(@Nonnull List<Field> fields) {
        this.fields = fields;
    }

    @Nonnull
    public List<Method> getMethods() {
        return this.methods;
    }

    public void setMethods(@Nonnull List<Method> methods) {
        this.methods = methods;
    }

    public int getAccess() {
        return this.access;
    }

    public void setAccess(int access) {
        this.access = access;
    }

    public int getVersionMinor() {
        return this.versionMinor;
    }

    public void setVersionMinor(int versionMinor) {
        this.versionMinor = versionMinor;
    }

    public int getVersionMajor() {
        return this.versionMajor;
    }

    public void setVersionMajor(int versionMajor) {
        this.versionMajor = versionMajor;
    }

    @Nonnull
    public CpClass getThisClass() {
        return this.thisClass;
    }

    public void setThisClass(@Nonnull CpClass thisClass) {
        this.thisClass = thisClass;
    }

    @Nullable
    public CpClass getSuperClass() {
        return this.superClass;
    }

    public void setSuperClass(@Nonnull CpClass superClass) {
        this.superClass = superClass;
    }

    @Override
    @Nonnull
    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(@Nonnull List<Attribute> attributes) {
        this.attributes = attributes;
    }

    @Override
    @Nonnull
    public AttributeContext getHolderType() {
        return AttributeContext.CLASS;
    }

    @Override
    @Nullable
    public <T extends Attribute> T getAttribute(Class<T> type) {
        for (Attribute attribute : this.attributes) {
            if (!type.isInstance(attribute)) continue;
            return (T)((Attribute)type.cast(attribute));
        }
        return null;
    }

    @Override
    @Nonnull
    public Set<CpEntry> cpAccesses() {
        HashSet<CpEntry> set = new HashSet<CpEntry>();
        set.add(this.getThisClass());
        CpClass superClass = this.getSuperClass();
        if (superClass != null) {
            set.add(superClass);
        }
        set.addAll(this.getInterfaceClasses());
        for (Attribute attribute : this.getAttributes()) {
            set.addAll(attribute.cpAccesses());
        }
        for (ClassMember classMember : this.getFields()) {
            set.addAll(classMember.cpAccesses());
        }
        for (ClassMember classMember : this.getMethods()) {
            set.addAll(classMember.cpAccesses());
        }
        return set;
    }
}

