/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.classfile.annotation;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import software.coley.cafedude.classfile.annotation.ElementValue;
import software.coley.cafedude.classfile.behavior.CpAccessor;
import software.coley.cafedude.classfile.constant.CpEntry;
import software.coley.cafedude.classfile.constant.CpUtf8;

public class Annotation
implements CpAccessor {
    private final Map<CpUtf8, ElementValue> values;
    private final CpUtf8 type;

    public Annotation(@Nonnull CpUtf8 type, @Nonnull Map<CpUtf8, ElementValue> values) {
        this.type = type;
        this.values = values;
    }

    @Nonnull
    public CpUtf8 getType() {
        return this.type;
    }

    @Nonnull
    public Map<CpUtf8, ElementValue> getValues() {
        return this.values;
    }

    @Override
    @Nonnull
    public Set<CpEntry> cpAccesses() {
        HashSet<CpEntry> set = new HashSet<CpEntry>();
        set.add(this.getType());
        for (ElementValue value : this.values.values()) {
            set.addAll(value.cpAccesses());
        }
        return set;
    }

    public int computeLength() {
        int length = 4;
        for (Map.Entry<CpUtf8, ElementValue> entry : this.values.entrySet()) {
            length += 2;
            length += entry.getValue().computeLength();
        }
        return length;
    }
}

