/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.classfile.annotation;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import software.coley.cafedude.classfile.annotation.ElementValue;
import software.coley.cafedude.classfile.constant.CpEntry;

public class ArrayElementValue
extends ElementValue {
    private List<ElementValue> array;

    public ArrayElementValue(char tag, @Nonnull List<ElementValue> array) {
        super(tag);
        if (tag != '[') {
            throw new IllegalArgumentException("Array element value must have '[' tag");
        }
        this.array = array;
    }

    @Nonnull
    public List<ElementValue> getArray() {
        return this.array;
    }

    public void setArray(@Nonnull List<ElementValue> array) {
        this.array = array;
    }

    @Override
    public char getTag() {
        return super.getTag();
    }

    @Override
    @Nonnull
    public Set<CpEntry> cpAccesses() {
        HashSet<CpEntry> set = new HashSet<CpEntry>();
        for (ElementValue value : this.getArray()) {
            set.addAll(value.cpAccesses());
        }
        return set;
    }

    @Override
    public int computeLength() {
        return 3 + this.array.stream().mapToInt(ElementValue::computeLength).sum();
    }
}

