/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.classfile.attribute;

import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import software.coley.cafedude.classfile.attribute.Attribute;
import software.coley.cafedude.classfile.constant.CpClass;
import software.coley.cafedude.classfile.constant.CpEntry;
import software.coley.cafedude.classfile.constant.CpUtf8;

public class NestMembersAttribute
extends Attribute {
    private List<CpClass> memberClasses;

    public NestMembersAttribute(@Nonnull CpUtf8 name, @Nonnull List<CpClass> memberClasses) {
        super(name);
        this.memberClasses = memberClasses;
    }

    @Nonnull
    public List<CpClass> getMemberClasses() {
        return this.memberClasses;
    }

    public void setMemberClasses(@Nonnull List<CpClass> memberClasses) {
        this.memberClasses = memberClasses;
    }

    @Override
    @Nonnull
    public Set<CpEntry> cpAccesses() {
        Set<CpEntry> set = super.cpAccesses();
        set.addAll(this.getMemberClasses());
        return set;
    }

    @Override
    public int computeInternalLength() {
        return 2 + this.memberClasses.size() * 2;
    }
}

