/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.classfile.attribute;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import software.coley.cafedude.classfile.StackMapTableConstants;
import software.coley.cafedude.classfile.attribute.Attribute;
import software.coley.cafedude.classfile.behavior.CpAccessor;
import software.coley.cafedude.classfile.constant.CpClass;
import software.coley.cafedude.classfile.constant.CpEntry;
import software.coley.cafedude.classfile.constant.CpUtf8;

public class StackMapTableAttribute
extends Attribute
implements StackMapTableConstants {
    private List<StackMapFrame> frames;

    public StackMapTableAttribute(@Nonnull CpUtf8 name, @Nonnull List<StackMapFrame> frames) {
        super(name);
        this.frames = frames;
    }

    @Nonnull
    public List<StackMapFrame> getFrames() {
        return this.frames;
    }

    public void setFrames(@Nonnull List<StackMapFrame> frames) {
        this.frames = frames;
    }

    @Override
    @Nonnull
    public Set<CpEntry> cpAccesses() {
        Set<CpEntry> set = super.cpAccesses();
        for (StackMapFrame frame : this.frames) {
            set.addAll(frame.cpAccesses());
        }
        return set;
    }

    @Override
    public int computeInternalLength() {
        int length = 2;
        for (StackMapFrame frame : this.frames) {
            length += frame.getLength();
        }
        return length;
    }

    public static class FullFrame
    extends StackMapFrame {
        private List<TypeInfo> locals;
        private List<TypeInfo> stack;

        public FullFrame(int offsetDelta, @Nonnull List<TypeInfo> locals, @Nonnull List<TypeInfo> stack) {
            super(offsetDelta);
            this.locals = locals;
            this.stack = stack;
        }

        @Override
        @Nonnull
        public Set<CpEntry> cpAccesses() {
            HashSet<CpEntry> set = new HashSet<CpEntry>();
            for (TypeInfo info : this.getLocals()) {
                set.addAll(info.cpAccesses());
            }
            for (TypeInfo info : this.getStack()) {
                set.addAll(info.cpAccesses());
            }
            return set;
        }

        @Override
        public int getLength() {
            int length = 3;
            length += 2;
            for (TypeInfo local : this.getLocals()) {
                length += local.getLength();
            }
            length += 2;
            for (TypeInfo stackType : this.getStack()) {
                length += stackType.getLength();
            }
            return length;
        }

        @Override
        public int getFrameType() {
            return 255;
        }

        @Nonnull
        public List<TypeInfo> getLocals() {
            return this.locals;
        }

        public void setLocals(@Nonnull List<TypeInfo> locals) {
            this.locals = locals;
        }

        @Nonnull
        public List<TypeInfo> getStack() {
            return this.stack;
        }

        public void setStack(@Nonnull List<TypeInfo> stack) {
            this.stack = stack;
        }
    }

    public static class AppendFrame
    extends StackMapFrame {
        private List<TypeInfo> additionalLocals;

        public AppendFrame(int offsetDelta, @Nonnull List<TypeInfo> additionalLocals) {
            super(offsetDelta);
            this.additionalLocals = additionalLocals;
        }

        @Override
        @Nonnull
        public Set<CpEntry> cpAccesses() {
            HashSet<CpEntry> set = new HashSet<CpEntry>();
            for (TypeInfo info : this.getAdditionalLocals()) {
                set.addAll(info.cpAccesses());
            }
            return set;
        }

        @Override
        public int getLength() {
            int length = 3;
            for (TypeInfo local : this.getAdditionalLocals()) {
                length += local.getLength();
            }
            return length;
        }

        @Override
        public int getFrameType() {
            return this.getAdditionalLocals().size() + 252 - 1;
        }

        @Nonnull
        public List<TypeInfo> getAdditionalLocals() {
            return this.additionalLocals;
        }

        public void setAdditionalLocals(@Nonnull List<TypeInfo> additionalLocals) {
            this.additionalLocals = additionalLocals;
        }
    }

    public static class SameFrameExtended
    extends StackMapFrame {
        public SameFrameExtended(int offsetDelta) {
            super(offsetDelta);
        }

        @Override
        public int getLength() {
            return 3;
        }

        @Override
        public int getFrameType() {
            return 251;
        }
    }

    public static class ChopFrame
    extends StackMapFrame {
        private int absentVariables;

        public ChopFrame(int offsetDelta, int absentVariables) {
            super(offsetDelta);
            this.absentVariables = absentVariables;
        }

        @Override
        public int getLength() {
            return 3;
        }

        @Override
        public int getFrameType() {
            return 250 - this.getAbsentVariables() + 1;
        }

        public int getAbsentVariables() {
            return this.absentVariables;
        }

        public void setAbsentVariables(int absentVariables) {
            this.absentVariables = absentVariables;
        }
    }

    public static class SameLocalsOneStackItemExtended
    extends StackMapFrame {
        private TypeInfo stack;

        public SameLocalsOneStackItemExtended(int offsetDelta, @Nonnull TypeInfo stack) {
            super(offsetDelta);
            this.stack = stack;
        }

        @Override
        @Nonnull
        public Set<CpEntry> cpAccesses() {
            return this.getStack().cpAccesses();
        }

        @Override
        public int getLength() {
            return 3 + this.getStack().getLength();
        }

        @Override
        public int getFrameType() {
            return 247;
        }

        @Nonnull
        public TypeInfo getStack() {
            return this.stack;
        }

        public void setStack(@Nonnull TypeInfo stack) {
            this.stack = stack;
        }
    }

    public static class SameLocalsOneStackItem
    extends StackMapFrame {
        private TypeInfo stack;

        public SameLocalsOneStackItem(int offsetDelta, @Nonnull TypeInfo stack) {
            super(offsetDelta);
            this.stack = stack;
        }

        @Override
        @Nonnull
        public Set<CpEntry> cpAccesses() {
            return this.getStack().cpAccesses();
        }

        @Override
        public int getLength() {
            return 1 + this.getStack().getLength();
        }

        @Override
        public int getFrameType() {
            return 64 + this.getOffsetDelta();
        }

        @Nonnull
        public TypeInfo getStack() {
            return this.stack;
        }

        public void setStack(@Nonnull TypeInfo stack) {
            this.stack = stack;
        }
    }

    public static class SameFrame
    extends StackMapFrame {
        public SameFrame(int offsetDelta) {
            super(offsetDelta);
        }

        @Override
        public int getFrameType() {
            return 0 + this.getOffsetDelta();
        }
    }

    public static abstract class StackMapFrame
    implements CpAccessor {
        private int offsetDelta;

        public StackMapFrame(int offsetDelta) {
            this.offsetDelta = offsetDelta;
        }

        public abstract int getFrameType();

        public int getLength() {
            return 1;
        }

        @Override
        @Nonnull
        public Set<CpEntry> cpAccesses() {
            return Collections.emptySet();
        }

        public int getOffsetDelta() {
            return this.offsetDelta;
        }

        public void setOffsetDelta(int offsetDelta) {
            this.offsetDelta = offsetDelta;
        }
    }

    public static class DoubleVariableInfo
    extends TypeInfo {
        @Override
        public int getTag() {
            return 3;
        }
    }

    public static class LongVariableInfo
    extends TypeInfo {
        @Override
        public int getTag() {
            return 4;
        }
    }

    public static class UninitializedVariableInfo
    extends TypeInfo {
        private int offset;

        @Override
        public int getTag() {
            return 8;
        }

        public UninitializedVariableInfo(int offset) {
            this.offset = offset;
        }

        @Override
        public int getLength() {
            return 3;
        }

        public int getOffset() {
            return this.offset;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }
    }

    public static class ObjectVariableInfo
    extends TypeInfo {
        private CpClass classEntry;

        @Override
        public int getTag() {
            return 7;
        }

        public ObjectVariableInfo(@Nonnull CpClass classEntry) {
            this.classEntry = classEntry;
        }

        @Override
        @Nonnull
        public Set<CpEntry> cpAccesses() {
            return Collections.singleton(this.getClassEntry());
        }

        @Override
        public int getLength() {
            return 3;
        }

        @Nonnull
        public CpClass getClassEntry() {
            return this.classEntry;
        }

        public void setClassEntry(@Nonnull CpClass classEntry) {
            this.classEntry = classEntry;
        }
    }

    public static class UninitializedThisVariableInfo
    extends TypeInfo {
        @Override
        public int getTag() {
            return 6;
        }
    }

    public static class NullVariableInfo
    extends TypeInfo {
        @Override
        public int getTag() {
            return 5;
        }
    }

    public static class FloatVariableInfo
    extends TypeInfo {
        @Override
        public int getTag() {
            return 2;
        }
    }

    public static class IntegerVariableInfo
    extends TypeInfo {
        @Override
        public int getTag() {
            return 1;
        }
    }

    public static class TopVariableInfo
    extends TypeInfo {
        @Override
        public int getTag() {
            return 0;
        }
    }

    public static abstract class TypeInfo
    implements CpAccessor {
        public abstract int getTag();

        public int getLength() {
            return 1;
        }

        @Override
        @Nonnull
        public Set<CpEntry> cpAccesses() {
            return Collections.emptySet();
        }
    }
}

