/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.io;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.coley.cafedude.classfile.ConstPool;
import software.coley.cafedude.classfile.annotation.Annotation;
import software.coley.cafedude.classfile.annotation.AnnotationElementValue;
import software.coley.cafedude.classfile.annotation.ArrayElementValue;
import software.coley.cafedude.classfile.annotation.ClassElementValue;
import software.coley.cafedude.classfile.annotation.ElementValue;
import software.coley.cafedude.classfile.annotation.EnumElementValue;
import software.coley.cafedude.classfile.annotation.PrimitiveElementValue;
import software.coley.cafedude.classfile.annotation.TargetInfo;
import software.coley.cafedude.classfile.annotation.TargetInfoType;
import software.coley.cafedude.classfile.annotation.TypeAnnotation;
import software.coley.cafedude.classfile.annotation.TypePath;
import software.coley.cafedude.classfile.annotation.TypePathElement;
import software.coley.cafedude.classfile.annotation.TypePathKind;
import software.coley.cafedude.classfile.annotation.Utf8ElementValue;
import software.coley.cafedude.classfile.attribute.AnnotationDefaultAttribute;
import software.coley.cafedude.classfile.attribute.AnnotationsAttribute;
import software.coley.cafedude.classfile.attribute.ParameterAnnotationsAttribute;
import software.coley.cafedude.classfile.constant.CpEntry;
import software.coley.cafedude.classfile.constant.CpUtf8;
import software.coley.cafedude.io.AttributeContext;
import software.coley.cafedude.io.ClassFileReader;

public class AnnotationReader {
    private static final Logger logger = LoggerFactory.getLogger(AnnotationReader.class);
    private static final int MAX_NESTING = 50;
    private final ClassFileReader reader;
    private final ConstPool cp;
    private final DataInputStream is;
    private final AttributeContext context;
    private final CpUtf8 name;
    private final int maxCpIndex;
    private final boolean visible;

    public AnnotationReader(ClassFileReader reader, ConstPool cp, DataInputStream is, int length, CpUtf8 name, AttributeContext context, boolean visible) throws IOException {
        this.reader = reader;
        this.cp = cp;
        byte[] data = new byte[length];
        is.readFully(data);
        this.is = new DataInputStream(new ByteArrayInputStream(data));
        this.name = name;
        this.context = context;
        this.maxCpIndex = cp.size();
        this.visible = visible;
    }

    @Nullable
    public AnnotationDefaultAttribute readAnnotationDefault() {
        try {
            return new AnnotationDefaultAttribute(this.name, this.readElementValue(new AnnotationScope()));
        }
        catch (Throwable t) {
            logger.debug("Illegally formatted AnnotationDefault, dropping");
            return null;
        }
    }

    @Nullable
    public AnnotationsAttribute readAnnotations() {
        try {
            int numAnnotations = this.is.readUnsignedShort();
            if (numAnnotations == 0) {
                logger.debug("Annotations attribute has 0 items, skipping");
                return null;
            }
            HashSet<String> usedAnnotationTypes = new HashSet<String>();
            ArrayList<Annotation> annotations = new ArrayList<Annotation>();
            for (int i = 0; i < numAnnotations; ++i) {
                Annotation annotation = this.readAnnotation(new AnnotationScope());
                if (this.reader.doDropDupeAnnotations()) {
                    String type = annotation.getType().getText();
                    if (usedAnnotationTypes.contains(type)) continue;
                    annotations.add(annotation);
                    usedAnnotationTypes.add(type);
                    continue;
                }
                annotations.add(annotation);
            }
            return new AnnotationsAttribute(this.name, annotations, this.visible);
        }
        catch (Throwable t) {
            logger.debug("Illegally formatted Annotations, dropping");
            return null;
        }
    }

    @Nullable
    public ParameterAnnotationsAttribute readParameterAnnotations() {
        try {
            int numParameters = this.is.readUnsignedByte();
            if (numParameters == 0) {
                logger.debug("ParameterAnnotations attribute has 0 items, skipping");
                return null;
            }
            LinkedHashMap<Integer, List<Annotation>> parameterAnnotations = new LinkedHashMap<Integer, List<Annotation>>();
            for (int p = 0; p < numParameters; ++p) {
                ArrayList<Annotation> annotations = new ArrayList<Annotation>();
                int numAnnotations = this.is.readUnsignedShort();
                for (int i = 0; i < numAnnotations; ++i) {
                    annotations.add(this.readAnnotation(new AnnotationScope()));
                }
                parameterAnnotations.put(p, annotations);
            }
            return new ParameterAnnotationsAttribute(this.name, parameterAnnotations, this.visible);
        }
        catch (Throwable t) {
            logger.debug("Illegally formatted ParameterAnnotations, dropping");
            return null;
        }
    }

    @Nullable
    public AnnotationsAttribute readTypeAnnotations() {
        try {
            int numAnnotations = this.is.readUnsignedShort();
            if (numAnnotations == 0) {
                logger.debug("TypeAnnotations attribute has 0 items, skipping");
                return null;
            }
            ArrayList<Annotation> annotations = new ArrayList<Annotation>();
            for (int i = 0; i < numAnnotations; ++i) {
                annotations.add(this.readTypeAnnotation(new AnnotationScope()));
            }
            return new AnnotationsAttribute(this.name, annotations, this.visible);
        }
        catch (Throwable t) {
            logger.debug("Illegally formatted TypeAnnotations, dropping");
            return null;
        }
    }

    @Nonnull
    private Annotation readAnnotation(@Nonnull AnnotationScope scope) throws IOException {
        int typeIndex = this.is.readUnsignedShort();
        if (typeIndex >= this.maxCpIndex) {
            logger.warn("Illegally formatted Annotation item, out of CP bounds, type_index={} >= {}", (Object)typeIndex, (Object)this.maxCpIndex);
            throw new IllegalArgumentException("Annotation type_index out of CP bounds!");
        }
        CpUtf8 type = (CpUtf8)this.cp.get(typeIndex);
        Map<CpUtf8, ElementValue> values = this.readElementPairs(scope.with(type.getText()));
        return new Annotation(type, values);
    }

    @Nonnull
    private TypeAnnotation readTypeAnnotation(@Nonnull AnnotationScope scope) throws IOException {
        TargetInfo info;
        int targetType = this.is.readUnsignedByte();
        AttributeContext expectedLocation = AttributeContext.fromAnnotationTargetType(targetType);
        if (!this.context.equals((Object)expectedLocation)) {
            throw new IllegalArgumentException("Annotation location does not match allowed locations for its type");
        }
        TargetInfoType targetInfoType = TargetInfoType.fromTargetType(targetType);
        switch (targetInfoType) {
            case TYPE_PARAMETER_TARGET: {
                int typeParameterIndex = this.is.readUnsignedByte();
                info = new TargetInfo.TypeParameterTargetInfo(targetType, typeParameterIndex);
                break;
            }
            case SUPERTYPE_TARGET: {
                int superTypeIndex = this.is.readUnsignedShort();
                info = new TargetInfo.SuperTypeTargetInfo(targetType, superTypeIndex);
                break;
            }
            case TYPE_PARAMETER_BOUND_TARGET: {
                int typeParameterIndex = this.is.readUnsignedByte();
                int boundIndex = this.is.readUnsignedByte();
                info = new TargetInfo.TypeParameterBoundTargetInfo(targetType, typeParameterIndex, boundIndex);
                break;
            }
            case EMPTY_TARGET: {
                info = new TargetInfo.EmptyTargetInfo(targetType);
                break;
            }
            case FORMAL_PARAMETER_TARGET: {
                int formalParameterIndex = this.is.readUnsignedByte();
                info = new TargetInfo.FormalParameterTargetInfo(targetType, formalParameterIndex);
                break;
            }
            case THROWS_TARGET: {
                int throwsTypeIndex = this.is.readUnsignedShort();
                info = new TargetInfo.ThrowsTargetInfo(targetType, throwsTypeIndex);
                break;
            }
            case LOCALVAR_TARGET: {
                ArrayList<TargetInfo.LocalVarTargetInfo.Variable> variables = new ArrayList<TargetInfo.LocalVarTargetInfo.Variable>();
                int tableLength = this.is.readUnsignedShort();
                for (int i = 0; i < tableLength; ++i) {
                    int startPc = this.is.readUnsignedShort();
                    int length = this.is.readUnsignedShort();
                    int index = this.is.readUnsignedShort();
                    variables.add(new TargetInfo.LocalVarTargetInfo.Variable(startPc, length, index));
                }
                info = new TargetInfo.LocalVarTargetInfo(targetType, variables);
                break;
            }
            case CATCH_TARGET: {
                int exceptionTableIndex = this.is.readUnsignedShort();
                info = new TargetInfo.CatchTargetInfo(targetType, exceptionTableIndex);
                break;
            }
            case OFFSET_TARGET: {
                int offset = this.is.readUnsignedShort();
                info = new TargetInfo.OffsetTargetInfo(targetType, offset);
                break;
            }
            case TYPE_ARGUMENT_TARGET: {
                int offset = this.is.readUnsignedShort();
                int typeArgumentIndex = this.is.readUnsignedByte();
                info = new TargetInfo.TypeArgumentTargetInfo(targetType, offset, typeArgumentIndex);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type argument target");
            }
        }
        TypePath typePath = this.readTypePath();
        CpUtf8 type = (CpUtf8)this.cp.get(this.is.readUnsignedShort());
        Map<CpUtf8, ElementValue> values = this.readElementPairs(scope);
        return new TypeAnnotation(type, values, info, typePath);
    }

    private TypePath readTypePath() throws IOException {
        int length = this.is.readUnsignedByte();
        ArrayList<TypePathElement> elements = new ArrayList<TypePathElement>();
        for (int i = 0; i < length; ++i) {
            int kind = this.is.readUnsignedByte();
            int index = this.is.readUnsignedByte();
            elements.add(new TypePathElement(TypePathKind.fromValue(kind), index));
        }
        return new TypePath(elements);
    }

    @Nonnull
    private Map<CpUtf8, ElementValue> readElementPairs(@Nonnull AnnotationScope scope) throws IOException {
        if (scope.size() > 50) {
            throw new IllegalArgumentException("Bogus deep annotation packing detected");
        }
        LinkedHashMap<CpUtf8, ElementValue> values = new LinkedHashMap<CpUtf8, ElementValue>();
        for (int numPairs = this.is.readUnsignedShort(); numPairs > 0; --numPairs) {
            CpUtf8 name = (CpUtf8)this.cp.get(this.is.readUnsignedShort());
            ElementValue value = this.readElementValue(scope);
            if (values.containsKey(name)) {
                throw new IllegalArgumentException("Element pairs already has field by name index: " + name);
            }
            values.put(name, value);
        }
        return values;
    }

    @Nonnull
    private ElementValue readElementValue(@Nonnull AnnotationScope scope) throws IOException {
        char tag = (char)this.is.readUnsignedByte();
        switch (tag) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                int index = this.is.readUnsignedShort();
                CpEntry entry = this.cp.get(index);
                return new PrimitiveElementValue(tag, entry);
            }
            case 's': {
                int utfIndex = this.is.readUnsignedShort();
                CpUtf8 utf = (CpUtf8)this.cp.get(utfIndex);
                return new Utf8ElementValue(tag, utf);
            }
            case 'e': {
                int typename = this.is.readUnsignedShort();
                int constname = this.is.readUnsignedShort();
                CpUtf8 type = (CpUtf8)this.cp.get(typename);
                CpUtf8 constant = (CpUtf8)this.cp.get(constname);
                return new EnumElementValue(tag, type, constant);
            }
            case 'c': {
                int classInfoIndex = this.is.readUnsignedShort();
                CpUtf8 classInfo = (CpUtf8)this.cp.get(classInfoIndex);
                return new ClassElementValue(tag, classInfo);
            }
            case '@': {
                Annotation nestedAnnotation = this.readAnnotation(scope);
                return new AnnotationElementValue(tag, nestedAnnotation);
            }
            case '[': {
                int numElements = this.is.readUnsignedShort();
                ArrayList<ElementValue> arrayValues = new ArrayList<ElementValue>();
                for (int i = 0; i < numElements; ++i) {
                    arrayValues.add(this.readElementValue(scope.with("[")));
                }
                return new ArrayElementValue(tag, arrayValues);
            }
        }
        logger.debug("Unknown element_value tag: ({}) '{}'", (Object)tag, (Object)Character.valueOf(tag));
        throw new IllegalArgumentException("Unrecognized tag for annotation element value: " + tag);
    }

    static class AnnotationScope
    extends ArrayList<String> {
        AnnotationScope() {
        }

        AnnotationScope with(String value) {
            this.add(value);
            return this;
        }
    }
}

