/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.util;

import java.lang.reflect.Field;
import javax.annotation.Nullable;
import software.coley.cafedude.classfile.instruction.Opcodes;
import software.coley.cafedude.classfile.instruction.ReservedOpcodes;

public class OpcodeUtil {
    private static final String[] names = new String[256];

    @Nullable
    public static String getOpcodeName(int opcode) {
        if (opcode < 0 || opcode >= names.length) {
            return null;
        }
        return names[opcode];
    }

    static {
        try {
            Field[] fields;
            int i = 0;
            for (Field field : fields = Opcodes.class.getFields()) {
                if (field.getType() != Integer.TYPE) continue;
                OpcodeUtil.names[i++] = field.getName().toLowerCase();
            }
            for (Field field : fields = ReservedOpcodes.class.getFields()) {
                if (field.getType() != Integer.TYPE) continue;
                OpcodeUtil.names[i++] = field.getName().toLowerCase();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

