/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.classfile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import software.coley.cafedude.classfile.InvalidCpIndexException;
import software.coley.cafedude.classfile.constant.CpEntry;

public class ConstPool
implements List<CpEntry> {
    private final List<CpEntry> backing = new ArrayList<CpEntry>();
    private final SortedSet<Integer> wideIndices = new TreeSet<Integer>();
    private final Map<Integer, Integer> indexToWides = new HashMap<Integer, Integer>();

    private int internalToCp(int index) {
        if (index == -1) {
            return -1;
        }
        int wideCount = this.indexToWides.computeIfAbsent(index, i -> this.wideIndices.headSet((Integer)i).size());
        return 1 + index + wideCount;
    }

    private int cpToInternal(int index) {
        if (index == 0) {
            return index;
        }
        int internal = index - 1;
        while (this.internalToCp(internal - 1) >= index) {
            --internal;
        }
        return internal;
    }

    private void onClear() {
        this.wideIndices.clear();
    }

    private void onAdd(@Nonnull CpEntry cpEntry, int location) {
        int entrySize = cpEntry.isWide() ? 2 : 1;
        SortedSet<Integer> larger = this.wideIndices.tailSet(location);
        if (!larger.isEmpty()) {
            ArrayList<Integer> tmp = new ArrayList<Integer>(larger);
            larger.clear();
            tmp.forEach(i -> this.addWideIndex(i + entrySize));
        }
        if (cpEntry.isWide()) {
            this.addWideIndex(location);
        }
        cpEntry.setIndex(this.internalToCp(location));
    }

    private void onRemove(@Nonnull CpEntry cpEntry, int location) {
        SortedSet<Integer> larger;
        int entrySize;
        int n = entrySize = cpEntry.isWide() ? 2 : 1;
        if (cpEntry.isWide()) {
            this.wideIndices.remove(location);
        }
        if (!(larger = this.wideIndices.tailSet(location + 1)).isEmpty()) {
            ArrayList<Integer> tmp = new ArrayList<Integer>(larger);
            larger.clear();
            tmp.forEach(i -> this.addWideIndex(i - entrySize));
        }
        cpEntry.setIndex(-1);
    }

    private void addWideIndex(int i) {
        this.wideIndices.add(i);
        this.indexToWides.clear();
    }

    @Override
    public int size() {
        if (this.backing.isEmpty()) {
            return 0;
        }
        return this.internalToCp(this.backing.size() - 1);
    }

    @Override
    public boolean isEmpty() {
        return this.backing.isEmpty();
    }

    @Override
    public boolean contains(@Nonnull Object o) {
        return this.backing.contains(o);
    }

    @Override
    @Nonnull
    public Iterator<CpEntry> iterator() {
        return this.backing.iterator();
    }

    @Override
    @Nonnull
    public Object[] toArray() {
        return this.backing.toArray(new CpEntry[0]);
    }

    @Override
    @Nonnull
    public <T> T[] toArray(T[] a) {
        return this.backing.toArray();
    }

    @Override
    public boolean add(@Nonnull CpEntry cpEntry) {
        this.onAdd(cpEntry, this.backing.size());
        return this.backing.add(cpEntry);
    }

    @Override
    public void add(int index, @Nonnull CpEntry element) {
        this.onAdd(element, index);
        this.backing.add(this.cpToInternal(index), element);
    }

    @Override
    @Nullable
    public CpEntry remove(int index) {
        CpEntry ret = this.backing.remove(this.cpToInternal(index));
        if (ret != null) {
            this.onRemove(ret, index);
        }
        return ret;
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof CpEntry) {
            CpEntry cpEntry = (CpEntry)o;
            this.onRemove(cpEntry, this.indexOf(cpEntry));
            return this.backing.remove(cpEntry);
        }
        return false;
    }

    @Override
    public boolean containsAll(@Nonnull Collection<?> c) {
        return new HashSet<CpEntry>(this.backing).containsAll(c);
    }

    @Override
    public boolean addAll(@Nonnull Collection<? extends CpEntry> c) {
        for (CpEntry cpEntry : c) {
            this.add(cpEntry);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, @Nonnull Collection<? extends CpEntry> c) {
        for (CpEntry cpEntry : c) {
            this.add(index, cpEntry);
        }
        return true;
    }

    @Override
    public boolean removeAll(@Nonnull Collection<?> c) {
        boolean ret = false;
        for (Object o : c) {
            ret |= this.remove(o);
        }
        return ret;
    }

    @Override
    public boolean retainAll(@Nonnull Collection<?> c) {
        boolean ret = false;
        for (CpEntry o : this) {
            if (c.contains(o)) continue;
            ret |= this.remove(o);
        }
        return ret;
    }

    @Override
    public void clear() {
        this.onClear();
        this.backing.clear();
    }

    @Override
    @Nullable
    public CpEntry get(int index) {
        try {
            if (index == 0) {
                return null;
            }
            return this.backing.get(this.cpToInternal(index));
        }
        catch (IndexOutOfBoundsException e) {
            throw new InvalidCpIndexException(this, index);
        }
    }

    @Override
    @Nullable
    public CpEntry set(int index, @Nonnull CpEntry element) {
        CpEntry ret = this.remove(index);
        this.add(index, element);
        return ret;
    }

    @Override
    public int indexOf(Object o) {
        return this.internalToCp(this.backing.indexOf(o));
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.internalToCp(this.backing.lastIndexOf(o));
    }

    @Override
    @Nonnull
    public ListIterator<CpEntry> listIterator() {
        return this.backing.listIterator();
    }

    @Override
    @Nonnull
    public ListIterator<CpEntry> listIterator(int index) {
        return this.backing.listIterator(this.cpToInternal(index));
    }

    @Override
    @Nonnull
    public List<CpEntry> subList(int fromIndex, int toIndex) {
        return this.backing.subList(this.cpToInternal(fromIndex), this.cpToInternal(toIndex));
    }
}

