/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.classfile.attribute;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import software.coley.cafedude.classfile.attribute.Attribute;
import software.coley.cafedude.classfile.behavior.CpAccessor;
import software.coley.cafedude.classfile.constant.CpClass;
import software.coley.cafedude.classfile.constant.CpEntry;
import software.coley.cafedude.classfile.constant.CpUtf8;

public class InnerClassesAttribute
extends Attribute {
    private List<InnerClass> innerClasses;

    public InnerClassesAttribute(@Nonnull CpUtf8 name, @Nonnull List<InnerClass> classes) {
        super(name);
        this.innerClasses = classes;
    }

    @Nonnull
    public List<InnerClass> getInnerClasses() {
        return this.innerClasses;
    }

    public void setInnerClasses(@Nonnull List<InnerClass> innerClasses) {
        this.innerClasses = innerClasses;
    }

    @Override
    @Nonnull
    public Set<CpEntry> cpAccesses() {
        Set<CpEntry> set = super.cpAccesses();
        for (InnerClass inner : this.getInnerClasses()) {
            set.addAll(inner.cpAccesses());
        }
        return set;
    }

    @Override
    public int computeInternalLength() {
        return 2 + this.innerClasses.size() * 8;
    }

    public static class InnerClass
    implements CpAccessor {
        private CpClass innerClassInfo;
        private CpClass outerClassInfo;
        private CpUtf8 innerName;
        private int innerClassAccessFlags;

        public InnerClass(@Nonnull CpClass innerClassInfo, @Nullable CpClass outerClassInfo, @Nullable CpUtf8 innerName, int innerClassAccessFlags) {
            this.innerClassInfo = innerClassInfo;
            this.outerClassInfo = outerClassInfo;
            this.innerName = innerName;
            this.innerClassAccessFlags = innerClassAccessFlags;
        }

        @Nonnull
        public CpClass getInnerClassInfo() {
            return this.innerClassInfo;
        }

        public void setInnerClassInfo(@Nonnull CpClass innerClassInfo) {
            this.innerClassInfo = innerClassInfo;
        }

        @Nullable
        public CpClass getOuterClassInfo() {
            return this.outerClassInfo;
        }

        public void setOuterClassInfo(@Nullable CpClass outerClassInfo) {
            this.outerClassInfo = outerClassInfo;
        }

        @Nullable
        public CpUtf8 getInnerName() {
            return this.innerName;
        }

        public void setInnerName(@Nullable CpUtf8 innerName) {
            this.innerName = innerName;
        }

        public int getInnerClassAccessFlags() {
            return this.innerClassAccessFlags;
        }

        public void setInnerClassAccessFlags(int innerClassAccessFlags) {
            this.innerClassAccessFlags = innerClassAccessFlags;
        }

        @Override
        @Nonnull
        public Set<CpEntry> cpAccesses() {
            HashSet<CpEntry> set = new HashSet<CpEntry>();
            set.add(this.getOuterClassInfo());
            set.add(this.getInnerClassInfo());
            set.add(this.getInnerName());
            return set;
        }
    }
}

