/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.classfile.attribute;

import java.util.List;
import javax.annotation.Nonnull;
import software.coley.cafedude.classfile.attribute.Attribute;
import software.coley.cafedude.classfile.constant.CpUtf8;

public class LineNumberTableAttribute
extends Attribute {
    private List<LineEntry> entries;

    public LineNumberTableAttribute(@Nonnull CpUtf8 name, @Nonnull List<LineEntry> entries) {
        super(name);
        this.entries = entries;
    }

    @Override
    public int computeInternalLength() {
        return 2 + 4 * this.entries.size();
    }

    @Nonnull
    public List<LineEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(@Nonnull List<LineEntry> entries) {
        this.entries = entries;
    }

    public static class LineEntry {
        private final int startPc;
        private final int line;

        public LineEntry(int startPc, int line) {
            this.startPc = startPc;
            this.line = line;
        }

        public int getStartPc() {
            return this.startPc;
        }

        public int getLine() {
            return this.line;
        }

        public String toString() {
            return "LineEntry{startPc=" + this.startPc + ", line=" + this.line + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LineEntry lineEntry = (LineEntry)o;
            if (this.startPc != lineEntry.startPc) {
                return false;
            }
            return this.line == lineEntry.line;
        }

        public int hashCode() {
            int result = this.startPc;
            result = 31 * result + this.line;
            return result;
        }
    }
}

