/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.classfile.attribute;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import software.coley.cafedude.classfile.attribute.Attribute;
import software.coley.cafedude.classfile.behavior.CpAccessor;
import software.coley.cafedude.classfile.constant.CpEntry;
import software.coley.cafedude.classfile.constant.CpUtf8;

public class LocalVariableTypeTableAttribute
extends Attribute {
    private List<VarTypeEntry> entries;

    public LocalVariableTypeTableAttribute(@Nonnull CpUtf8 name, @Nonnull List<VarTypeEntry> entries) {
        super(name);
        this.entries = entries;
    }

    @Override
    @Nonnull
    public Set<CpEntry> cpAccesses() {
        Set<CpEntry> set = super.cpAccesses();
        for (VarTypeEntry entry : this.getEntries()) {
            set.addAll(entry.cpAccesses());
        }
        return set;
    }

    @Override
    public int computeInternalLength() {
        return 2 + 10 * this.entries.size();
    }

    @Nonnull
    public List<VarTypeEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(@Nonnull List<VarTypeEntry> entries) {
        this.entries = entries;
    }

    public static class VarTypeEntry
    implements CpAccessor {
        private final int startPc;
        private final int length;
        private final CpUtf8 name;
        private final CpUtf8 signature;
        private final int index;

        public VarTypeEntry(int startPc, int length, @Nonnull CpUtf8 name, @Nonnull CpUtf8 signature, int index) {
            this.startPc = startPc;
            this.length = length;
            this.name = name;
            this.signature = signature;
            this.index = index;
        }

        public int getStartPc() {
            return this.startPc;
        }

        public int getLength() {
            return this.length;
        }

        @Nonnull
        public CpUtf8 getName() {
            return this.name;
        }

        @Nonnull
        public CpUtf8 getSignature() {
            return this.signature;
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        @Nonnull
        public Set<CpEntry> cpAccesses() {
            HashSet<CpEntry> set = new HashSet<CpEntry>();
            set.add(this.name);
            set.add(this.signature);
            return set;
        }
    }
}

