/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.classfile.attribute;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import software.coley.cafedude.classfile.attribute.Attribute;
import software.coley.cafedude.classfile.behavior.AttributeHolder;
import software.coley.cafedude.classfile.behavior.CpAccessor;
import software.coley.cafedude.classfile.constant.CpEntry;
import software.coley.cafedude.classfile.constant.CpUtf8;
import software.coley.cafedude.io.AttributeContext;

public class RecordAttribute
extends Attribute {
    private List<RecordComponent> components;

    public RecordAttribute(@Nonnull CpUtf8 name, @Nonnull List<RecordComponent> components) {
        super(name);
        this.components = components;
    }

    @Override
    @Nonnull
    public Set<CpEntry> cpAccesses() {
        Set<CpEntry> set = super.cpAccesses();
        for (RecordComponent component : this.getComponents()) {
            set.addAll(component.cpAccesses());
        }
        return set;
    }

    @Override
    public int computeInternalLength() {
        return 2 + this.components.stream().mapToInt(RecordComponent::length).sum();
    }

    @Nonnull
    public List<RecordComponent> getComponents() {
        return this.components;
    }

    public void setComponents(@Nonnull List<RecordComponent> components) {
        this.components = components;
    }

    public static class RecordComponent
    implements CpAccessor,
    AttributeHolder {
        private CpUtf8 name;
        private CpUtf8 desc;
        private List<Attribute> attributes;

        public RecordComponent(@Nonnull CpUtf8 name, @Nonnull CpUtf8 desc, @Nonnull List<Attribute> attributes) {
            this.name = name;
            this.desc = desc;
            this.attributes = attributes;
        }

        @Nonnull
        public CpUtf8 getName() {
            return this.name;
        }

        public void setName(@Nonnull CpUtf8 name) {
            this.name = name;
        }

        @Nonnull
        public CpUtf8 getDesc() {
            return this.desc;
        }

        public void setDesc(@Nonnull CpUtf8 desc) {
            this.desc = desc;
        }

        @Override
        @Nonnull
        public List<Attribute> getAttributes() {
            return this.attributes;
        }

        @Override
        @Nullable
        public <T extends Attribute> T getAttribute(Class<T> type) {
            return null;
        }

        @Override
        public void setAttributes(@Nonnull List<Attribute> attributes) {
            this.attributes = attributes;
        }

        @Override
        @Nonnull
        public AttributeContext getHolderType() {
            return AttributeContext.RECORD_COMPONENT;
        }

        @Override
        @Nonnull
        public Set<CpEntry> cpAccesses() {
            HashSet<CpEntry> set = new HashSet<CpEntry>();
            set.add(this.name);
            set.add(this.desc);
            return set;
        }

        public int length() {
            int len = 6;
            for (Attribute attribute : this.attributes) {
                len += attribute.computeCompleteLength();
            }
            return len;
        }
    }
}

