/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.transform;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.coley.cafedude.classfile.ClassFile;
import software.coley.cafedude.classfile.ConstantPoolConstants;
import software.coley.cafedude.classfile.Descriptor;
import software.coley.cafedude.classfile.Field;
import software.coley.cafedude.classfile.Method;
import software.coley.cafedude.classfile.annotation.Annotation;
import software.coley.cafedude.classfile.annotation.ClassElementValue;
import software.coley.cafedude.classfile.annotation.ElementValue;
import software.coley.cafedude.classfile.annotation.EnumElementValue;
import software.coley.cafedude.classfile.annotation.PrimitiveElementValue;
import software.coley.cafedude.classfile.annotation.TargetInfo;
import software.coley.cafedude.classfile.annotation.TypeAnnotation;
import software.coley.cafedude.classfile.attribute.AnnotationDefaultAttribute;
import software.coley.cafedude.classfile.attribute.AnnotationsAttribute;
import software.coley.cafedude.classfile.attribute.Attribute;
import software.coley.cafedude.classfile.attribute.AttributeContexts;
import software.coley.cafedude.classfile.attribute.BootstrapMethodsAttribute;
import software.coley.cafedude.classfile.attribute.CodeAttribute;
import software.coley.cafedude.classfile.attribute.ConstantValueAttribute;
import software.coley.cafedude.classfile.attribute.DefaultAttribute;
import software.coley.cafedude.classfile.attribute.EnclosingMethodAttribute;
import software.coley.cafedude.classfile.attribute.ExceptionsAttribute;
import software.coley.cafedude.classfile.attribute.InnerClassesAttribute;
import software.coley.cafedude.classfile.attribute.LocalVariableTableAttribute;
import software.coley.cafedude.classfile.attribute.LocalVariableTypeTableAttribute;
import software.coley.cafedude.classfile.attribute.ModuleAttribute;
import software.coley.cafedude.classfile.attribute.NestHostAttribute;
import software.coley.cafedude.classfile.attribute.NestMembersAttribute;
import software.coley.cafedude.classfile.attribute.ParameterAnnotationsAttribute;
import software.coley.cafedude.classfile.attribute.PermittedClassesAttribute;
import software.coley.cafedude.classfile.attribute.RecordAttribute;
import software.coley.cafedude.classfile.attribute.SignatureAttribute;
import software.coley.cafedude.classfile.attribute.SourceFileAttribute;
import software.coley.cafedude.classfile.behavior.AttributeHolder;
import software.coley.cafedude.classfile.constant.CpClass;
import software.coley.cafedude.classfile.constant.CpEntry;
import software.coley.cafedude.classfile.constant.CpUtf8;
import software.coley.cafedude.io.AttributeContext;
import software.coley.cafedude.transform.Transformer;

public class IllegalStrippingTransformer
extends Transformer
implements ConstantPoolConstants {
    private static final Logger logger = LoggerFactory.getLogger(IllegalStrippingTransformer.class);

    public IllegalStrippingTransformer(ClassFile clazz) {
        super(clazz);
    }

    @Override
    public void transform() {
        logger.info("Transforming '{}'", (Object)this.clazz.getName());
        Set<CpEntry> cpAccesses = this.clazz.cpAccesses();
        this.removeInvalidBootstrapMethodAttribute();
        this.clazz.getAttributes().removeIf(attribute -> !this.isValidWrapped(this.clazz, (Attribute)attribute));
        for (Field field : this.clazz.getFields()) {
            field.getAttributes().removeIf(attribute -> !this.isValidWrapped(field, (Attribute)attribute));
        }
        for (Method method : this.clazz.getMethods()) {
            method.getAttributes().removeIf(attribute -> !this.isValidWrapped(method, (Attribute)attribute));
        }
        Set<CpEntry> filteredCpAccesses = this.clazz.cpAccesses();
        cpAccesses.removeAll(filteredCpAccesses);
    }

    private void removeInvalidBootstrapMethodAttribute() {
        List dynamicCpAccesses;
        BootstrapMethodsAttribute bsmAttribute = this.clazz.getAttribute(BootstrapMethodsAttribute.class);
        if (bsmAttribute != null && (dynamicCpAccesses = this.clazz.getMethods().stream().flatMap(m -> m.cpAccesses().stream()).filter(cp -> cp.getTag() == 17 || cp.getTag() == 18).collect(Collectors.toList())).isEmpty()) {
            this.clazz.getAttributes().remove(bsmAttribute);
        }
    }

    private boolean isValidWrapped(AttributeHolder holder, Attribute attribute) {
        try {
            return this.isValid(holder, attribute);
        }
        catch (Exception ex) {
            logger.warn("Encountered exception when parsing attribute '{}' in context '{}', dropping it", (Object)attribute.getClass().getName(), (Object)holder.getHolderType().name());
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isValid(AttributeHolder holder, Attribute attribute) {
        void var11_48;
        AttributeContext context;
        HashMap<CpEntry, Predicate<Integer>> expectedTypeMasks = new HashMap<CpEntry, Predicate<Integer>>();
        HashMap<CpEntry, Predicate<CpEntry>> cpEntryValidators = new HashMap<CpEntry, Predicate<CpEntry>>();
        int maxCpIndex = this.pool.size();
        if (attribute.getName().getIndex() > maxCpIndex) {
            return false;
        }
        if (attribute instanceof DefaultAttribute) {
            return true;
        }
        String name = attribute.getName().getText();
        Collection<AttributeContext> allowedContexts = AttributeContexts.getAllowedContexts(name);
        if (!allowedContexts.contains((Object)(context = holder.getHolderType()))) {
            logger.debug("Found '{}' declared in illegal context {}, allowed contexts: {}", new Object[]{name, context.name(), allowedContexts});
            return false;
        }
        boolean allow0Case = false;
        String string = name;
        int n = -1;
        switch (string.hashCode()) {
            case -1968073715: {
                if (!string.equals("ConstantValue")) break;
                boolean bl = false;
                break;
            }
            case 1971868943: {
                if (!string.equals("RuntimeInvisibleAnnotations")) break;
                boolean bl = true;
                break;
            }
            case -528253654: {
                if (!string.equals("RuntimeVisibleAnnotations")) break;
                int n2 = 2;
                break;
            }
            case -1233741835: {
                if (!string.equals("RuntimeInvisibleTypeAnnotations")) break;
                int n3 = 3;
                break;
            }
            case 1629108880: {
                if (!string.equals("RuntimeVisibleTypeAnnotations")) break;
                int n4 = 4;
                break;
            }
            case -864757200: {
                if (!string.equals("RuntimeInvisibleParameterAnnotations")) break;
                int n5 = 5;
                break;
            }
            case -918183819: {
                if (!string.equals("RuntimeVisibleParameterAnnotations")) break;
                int n6 = 6;
                break;
            }
            case 1181327346: {
                if (!string.equals("AnnotationDefault")) break;
                int n7 = 7;
                break;
            }
            case 1345547328: {
                if (!string.equals("NestHost")) break;
                int n8 = 8;
                break;
            }
            case 120957825: {
                if (!string.equals("NestMembers")) break;
                int n9 = 9;
                break;
            }
            case 1372865485: {
                if (!string.equals("EnclosingMethod")) break;
                int n10 = 10;
                break;
            }
            case 679220772: {
                if (!string.equals("Exceptions")) break;
                int n11 = 11;
                break;
            }
            case 2061183248: {
                if (!string.equals("InnerClasses")) break;
                int n12 = 12;
                break;
            }
            case 0x20220D: {
                if (!string.equals("Code")) break;
                int n13 = 13;
                break;
            }
            case -1217415016: {
                if (!string.equals("Signature")) break;
                int n14 = 14;
                break;
            }
            case 881600599: {
                if (!string.equals("SourceFile")) break;
                int n15 = 15;
                break;
            }
            case -1984916852: {
                if (!string.equals("Module")) break;
                int n16 = 16;
                break;
            }
            case 302571908: {
                if (!string.equals("BootstrapMethods")) break;
                int n17 = 17;
                break;
            }
            case 1690786087: {
                if (!string.equals("LocalVariableTable")) break;
                int n18 = 18;
                break;
            }
            case 647494029: {
                if (!string.equals("LocalVariableTypeTable")) break;
                int n19 = 19;
                break;
            }
            case 822139390: {
                if (!string.equals("PermittedSubclasses")) break;
                int n20 = 20;
                break;
            }
            case -1851041679: {
                if (!string.equals("Record")) break;
                int n21 = 21;
                break;
            }
            case 1698628945: {
                if (!string.equals("LineNumberTable")) break;
                int n22 = 22;
                break;
            }
            case 1799467079: {
                if (!string.equals("SourceDebugExtension")) break;
                int n23 = 23;
                break;
            }
            case 361120211: {
                if (!string.equals("Deprecated")) break;
                int n24 = 24;
                break;
            }
            case -1301870811: {
                if (!string.equals("Synthetic")) break;
                int n25 = 25;
                break;
            }
            case -1956605830: {
                if (!string.equals("CharacterRangeTable")) break;
                int n26 = 26;
                break;
            }
            case -2113023490: {
                if (!string.equals("CompilationID")) break;
                int n27 = 27;
                break;
            }
            case -1682911797: {
                if (!string.equals("MethodParameters")) break;
                int n28 = 28;
                break;
            }
            case 1103964136: {
                if (!string.equals("ModuleHashes")) break;
                int n29 = 29;
                break;
            }
            case 1038813715: {
                if (!string.equals("ModuleMainClass")) break;
                int n30 = 30;
                break;
            }
            case 654770073: {
                if (!string.equals("ModulePackages")) break;
                int n31 = 31;
                break;
            }
            case 539437144: {
                if (!string.equals("ModuleResolution")) break;
                int n32 = 32;
                break;
            }
            case 1447483197: {
                if (!string.equals("ModuleTarget")) break;
                int n33 = 33;
                break;
            }
            case 1810971286: {
                if (!string.equals("SourceID")) break;
                int n34 = 34;
                break;
            }
            case -1165627814: {
                if (!string.equals("StackMapTable")) break;
                int n35 = 35;
            }
        }
        switch (var11_48) {
            case 0: {
                CpEntry valueIndex = ((ConstantValueAttribute)attribute).getConstantValue();
                expectedTypeMasks.put(valueIndex, i -> i >= 3 && i <= 8);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                AnnotationsAttribute annotations = (AnnotationsAttribute)attribute;
                for (Annotation anno : annotations.getAnnotations()) {
                    this.addAnnotationValidation(holder, expectedTypeMasks, cpEntryValidators, anno);
                }
                break;
            }
            case 5: 
            case 6: {
                if (context != AttributeContext.METHOD) {
                    return false;
                }
                ParameterAnnotationsAttribute paramAnnotations = (ParameterAnnotationsAttribute)attribute;
                Method method = (Method)holder;
                String desc = method.getType().getText();
                int parameterCount = Descriptor.from(desc).getParameterCount();
                if (paramAnnotations.getParameterAnnotations().keySet().stream().anyMatch(key -> key >= parameterCount)) {
                    String methodName = method.getName().getText();
                    logger.debug("Out of bounds parameter-annotation indices used on method {}", (Object)methodName);
                    return false;
                }
                Collection<List<Annotation>> parameterAnnos = paramAnnotations.getParameterAnnotations().values();
                Iterator iterator = parameterAnnos.iterator();
                while (iterator.hasNext()) {
                    List annotationList = (List)iterator.next();
                    Iterator iterator2 = annotationList.iterator();
                    while (iterator2.hasNext()) {
                        Annotation anno = (Annotation)iterator2.next();
                        this.addAnnotationValidation(holder, expectedTypeMasks, cpEntryValidators, anno);
                    }
                }
                break;
            }
            case 7: {
                AnnotationDefaultAttribute annotationDefault = (AnnotationDefaultAttribute)attribute;
                ElementValue elementValue = annotationDefault.getElementValue();
                this.addElementValueValidation(expectedTypeMasks, cpEntryValidators, elementValue);
                break;
            }
            case 8: {
                NestHostAttribute nestHost = (NestHostAttribute)attribute;
                cpEntryValidators.put(nestHost.getHostClass(), this.matchClass());
                break;
            }
            case 9: {
                NestMembersAttribute nestMembers = (NestMembersAttribute)attribute;
                for (CpClass member : nestMembers.getMemberClasses()) {
                    cpEntryValidators.put(member, this.matchClass());
                }
                break;
            }
            case 10: {
                EnclosingMethodAttribute enclosingMethod = (EnclosingMethodAttribute)attribute;
                expectedTypeMasks.put(enclosingMethod.getClassEntry(), i -> i == 7);
                cpEntryValidators.put(enclosingMethod.getClassEntry(), this.matchClass());
                expectedTypeMasks.put(enclosingMethod.getMethodEntry(), i -> i == 0 || i == 12);
                allow0Case = enclosingMethod.getMethodEntry() == null;
                break;
            }
            case 11: {
                ExceptionsAttribute exceptions = (ExceptionsAttribute)attribute;
                for (CpClass cpClass : exceptions.getExceptionTable()) {
                    cpEntryValidators.put(cpClass, this.matchClass());
                }
                break;
            }
            case 12: {
                InnerClassesAttribute innerClasses = (InnerClassesAttribute)attribute;
                for (InnerClassesAttribute.InnerClass innerClass : innerClasses.getInnerClasses()) {
                    expectedTypeMasks.put(innerClass.getInnerClassInfo(), i -> i == 0 || i == 7);
                    cpEntryValidators.put(innerClass.getInnerClassInfo(), this.matchClass());
                    expectedTypeMasks.put(innerClass.getOuterClassInfo(), i -> i == 0 || i == 7);
                    expectedTypeMasks.put(innerClass.getInnerName(), i -> i == 0 || i == 1);
                    allow0Case |= innerClass.getInnerClassInfo() == null || innerClass.getOuterClassInfo() == null || innerClass.getInnerName() == null;
                }
                break;
            }
            case 13: {
                if (context != AttributeContext.METHOD) {
                    return false;
                }
                Method method = (Method)holder;
                if ((method.getAccess() & 0x400) > 0) {
                    logger.debug("Illegal 'Code' attribute on abstract method {}", (Object)method.getName().getText());
                    return false;
                }
                CodeAttribute code = (CodeAttribute)attribute;
                code.getAttributes().removeIf(sub -> !this.isValid(code, (Attribute)sub));
                for (CodeAttribute.ExceptionTableEntry exceptionTableEntry : code.getExceptionTable()) {
                    CpClass cpClass = exceptionTableEntry.getCatchType();
                    if (cpClass == null) {
                        allow0Case = true;
                        continue;
                    }
                    cpEntryValidators.put(cpClass, this.matchClass());
                    expectedTypeMasks.put(cpClass, i -> i == 0 || i == 7);
                }
                break;
            }
            case 14: {
                SignatureAttribute signatureAttribute = (SignatureAttribute)attribute;
                cpEntryValidators.put(signatureAttribute.getSignature(), this.matchUtf8NonEmpty());
                break;
            }
            case 15: {
                SourceFileAttribute sourceFileAttribute = (SourceFileAttribute)attribute;
                cpEntryValidators.put(sourceFileAttribute.getSourceFilename(), this.matchUtf8NonEmpty());
                break;
            }
            case 16: {
                ModuleAttribute moduleAttribute = (ModuleAttribute)attribute;
                expectedTypeMasks.put(moduleAttribute.getVersion(), i -> i == 0 || i == 1);
                if (moduleAttribute.getVersion() == null) {
                    allow0Case = true;
                }
                for (ModuleAttribute.Requires requires : moduleAttribute.getRequires()) {
                    expectedTypeMasks.put(requires.getVersion(), i -> i == 0 || i == 1);
                }
                break;
            }
            case 17: {
                BootstrapMethodsAttribute bootstrapMethodsAttribute = (BootstrapMethodsAttribute)attribute;
                for (BootstrapMethodsAttribute.BootstrapMethod bootstrapMethod : bootstrapMethodsAttribute.getBootstrapMethods()) {
                    expectedTypeMasks.put(bootstrapMethod.getBsmMethodRef(), i -> i == 15);
                    for (CpEntry cpEntry : bootstrapMethod.getArgs()) {
                        expectedTypeMasks.put(cpEntry, i -> i >= 3 && i <= 8 || i >= 15 && i <= 17);
                    }
                }
                break;
            }
            case 18: {
                LocalVariableTableAttribute localVariableTableAttribute = (LocalVariableTableAttribute)attribute;
                for (LocalVariableTableAttribute.VarEntry varEntry : localVariableTableAttribute.getEntries()) {
                    expectedTypeMasks.put(varEntry.getName(), i -> i == 1);
                    expectedTypeMasks.put(varEntry.getDesc(), i -> i == 1);
                    cpEntryValidators.put(varEntry.getName(), this.matchUtf8ValidQualifiedName().and(this.matchUtf8Word()));
                    cpEntryValidators.put(varEntry.getDesc(), this.matchUtf8FieldDescriptor());
                }
                break;
            }
            case 19: {
                LocalVariableTypeTableAttribute localVariableTypeTableAttribute = (LocalVariableTypeTableAttribute)attribute;
                for (LocalVariableTypeTableAttribute.VarTypeEntry varTypeEntry : localVariableTypeTableAttribute.getEntries()) {
                    cpEntryValidators.put(varTypeEntry.getName(), this.matchUtf8ValidQualifiedName().and(this.matchUtf8Word()));
                    cpEntryValidators.put(varTypeEntry.getSignature(), this.matchUtf8NonEmpty());
                }
                break;
            }
            case 20: {
                PermittedClassesAttribute permittedClassesAttribute = (PermittedClassesAttribute)attribute;
                for (CpClass index : permittedClassesAttribute.getClasses()) {
                    cpEntryValidators.put(index, this.matchClass());
                }
                break;
            }
            case 21: {
                RecordAttribute recordAttribute = (RecordAttribute)attribute;
                for (RecordAttribute.RecordComponent component : recordAttribute.getComponents()) {
                    cpEntryValidators.put(component.getName(), this.matchUtf8Word());
                    cpEntryValidators.put(component.getDesc(), this.matchUtf8FieldDescriptor());
                }
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
        }
        for (Map.Entry entry : expectedTypeMasks.entrySet()) {
            CpEntry cpEntry = (CpEntry)entry.getKey();
            if (allow0Case && cpEntry == null) continue;
            if (cpEntry == null) {
                logger.debug("Invalid '{}' attribute on {}, contains CP reference to null!", (Object)name, (Object)context.name());
                return false;
            }
            int tag = cpEntry.getTag();
            if (!((Predicate)entry.getValue()).test(tag)) {
                logger.debug("Invalid '{}' attribute on {}, contains CP reference to index with wrong type!", (Object)name, (Object)context.name());
                return false;
            }
            if (!cpEntryValidators.containsKey(cpEntry) || ((Predicate)cpEntryValidators.get(cpEntry)).test(cpEntry)) continue;
            logger.debug("Invalid '{}' attribute, contains CP reference to item that does not match criteria at index: {}", (Object)name, (Object)cpEntry);
            return false;
        }
        return true;
    }

    private void addAnnotationValidation(AttributeHolder holder, Map<CpEntry, Predicate<Integer>> expectedTypeMasks, Map<CpEntry, Predicate<CpEntry>> cpEntryValidators, Annotation anno) {
        expectedTypeMasks.put(anno.getType(), i -> i == 1);
        cpEntryValidators.put(anno.getType(), this.matchUtf8FieldDescriptor());
        for (Map.Entry<CpUtf8, ElementValue> entry : anno.getValues().entrySet()) {
            CpUtf8 elementTypeIndex = entry.getKey();
            cpEntryValidators.put(elementTypeIndex, this.matchUtf8InternalName());
            this.addElementValueValidation(expectedTypeMasks, cpEntryValidators, entry.getValue());
        }
        if (anno instanceof TypeAnnotation) {
            TypeAnnotation typeAnnotation = (TypeAnnotation)anno;
            TargetInfo targetInfo = typeAnnotation.getTargetInfo();
            switch (targetInfo.getTargetTypeKind()) {
                case TYPE_PARAMETER_BOUND_TARGET: {
                    break;
                }
                case TYPE_PARAMETER_TARGET: {
                    break;
                }
                case FORMAL_PARAMETER_TARGET: {
                    break;
                }
                case TYPE_ARGUMENT_TARGET: {
                    break;
                }
                case LOCALVAR_TARGET: {
                    break;
                }
                case THROWS_TARGET: {
                    break;
                }
                case OFFSET_TARGET: {
                    break;
                }
                case SUPERTYPE_TARGET: {
                    if (holder instanceof ClassFile) {
                        TargetInfo.SuperTypeTargetInfo superTypeTargetInfo = (TargetInfo.SuperTypeTargetInfo)targetInfo;
                        if (superTypeTargetInfo.isExtends()) break;
                        ClassFile classFile = (ClassFile)holder;
                        if (superTypeTargetInfo.getSuperTypeIndex() < classFile.getInterfaceClasses().size()) break;
                        expectedTypeMasks.put(null, i -> false);
                        break;
                    }
                    expectedTypeMasks.put(null, i -> false);
                    break;
                }
                case CATCH_TARGET: {
                    if (holder instanceof CodeAttribute) {
                        CodeAttribute code = (CodeAttribute)holder;
                        TargetInfo.CatchTargetInfo catchTargetInfo = (TargetInfo.CatchTargetInfo)targetInfo;
                        if (catchTargetInfo.getExceptionTableIndex() < code.getExceptionTable().size()) break;
                        expectedTypeMasks.put(null, i -> false);
                        break;
                    }
                    expectedTypeMasks.put(null, i -> false);
                    break;
                }
            }
        }
    }

    private void addElementValueValidation(Map<CpEntry, Predicate<Integer>> expectedTypeMasks, Map<CpEntry, Predicate<CpEntry>> cpEntryValidators, ElementValue elementValue) {
        if (elementValue instanceof ClassElementValue) {
            CpUtf8 classIndex = ((ClassElementValue)elementValue).getClassEntry();
            cpEntryValidators.put(classIndex, this.matchUtf8InternalName());
        } else if (elementValue instanceof EnumElementValue) {
            EnumElementValue enumElementValue = (EnumElementValue)elementValue;
            cpEntryValidators.put(enumElementValue.getType(), this.matchUtf8FieldDescriptor());
        } else if (elementValue instanceof PrimitiveElementValue) {
            expectedTypeMasks.put(((PrimitiveElementValue)elementValue).getValue(), i -> i >= 3 && i <= 6);
        }
    }

    private Predicate<CpEntry> matchClass() {
        return e -> e instanceof CpClass && this.matchUtf8InternalName().test(((CpClass)e).getName());
    }

    private Predicate<CpEntry> matchUtf8InternalName() {
        return this.matchUtf8NonEmpty();
    }

    private Predicate<CpEntry> matchUtf8FieldDescriptor() {
        return e -> {
            if (e instanceof CpUtf8) {
                String text = ((CpUtf8)e).getText();
                while (text.startsWith("[")) {
                    text = text.substring(1);
                }
                if (text.length() > 1) {
                    char first = text.charAt(0);
                    if (first == 'L') {
                        return text.charAt(text.length() - 1) == ';';
                    }
                } else if (text.length() == 1) {
                    char desc = text.charAt(0);
                    switch (desc) {
                        case 'B': 
                        case 'C': 
                        case 'D': 
                        case 'F': 
                        case 'I': 
                        case 'J': 
                        case 'S': 
                        case 'Z': {
                            return true;
                        }
                    }
                    return false;
                }
                return false;
            }
            return false;
        };
    }

    private Predicate<CpEntry> matchUtf8ValidQualifiedName() {
        return e -> {
            if (e instanceof CpUtf8) {
                String text = ((CpUtf8)e).getText();
                if (text.indexOf(46) >= 0) {
                    return false;
                }
                if (text.indexOf(59) >= 0) {
                    return false;
                }
                if (text.indexOf(91) >= 0) {
                    return false;
                }
                return text.indexOf(47) < 0;
            }
            return false;
        };
    }

    private Predicate<CpEntry> matchUtf8NonEmpty() {
        return e -> e instanceof CpUtf8 && ((CpUtf8)e).getText().length() > 0;
    }

    private Predicate<CpEntry> matchUtf8Word() {
        return e -> e instanceof CpUtf8 && ((CpUtf8)e).getText().matches("[<>;/$\\w]+");
    }
}

