/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.classfile.instruction;

import java.lang.reflect.Field;
import java.util.Arrays;
import software.coley.cafedude.classfile.instruction.Opcodes;

public class OpcodeNames {
    private static final String UNKNOWN = "?";
    private static final String[] NAMES = new String[255];

    public static String name(int opcode) {
        if (opcode < 0 || opcode >= NAMES.length - 1) {
            return UNKNOWN;
        }
        return NAMES[opcode];
    }

    static {
        Arrays.fill(NAMES, UNKNOWN);
        try {
            for (Field field : Opcodes.class.getDeclaredFields()) {
                String name;
                if (field.getType() != Integer.TYPE) continue;
                int opcode = field.getInt(null);
                OpcodeNames.NAMES[opcode] = name = field.getName();
            }
        }
        catch (Throwable t) {
            throw new IllegalStateException("Failed to populate opcode names", t);
        }
    }
}

