/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.io;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.coley.cafedude.classfile.ConstPool;
import software.coley.cafedude.classfile.InvalidCpIndexException;
import software.coley.cafedude.classfile.attribute.AnnotationDefaultAttribute;
import software.coley.cafedude.classfile.attribute.AnnotationsAttribute;
import software.coley.cafedude.classfile.attribute.Attribute;
import software.coley.cafedude.classfile.attribute.AttributeContexts;
import software.coley.cafedude.classfile.attribute.AttributeVersions;
import software.coley.cafedude.classfile.attribute.BootstrapMethodsAttribute;
import software.coley.cafedude.classfile.attribute.CodeAttribute;
import software.coley.cafedude.classfile.attribute.ConstantValueAttribute;
import software.coley.cafedude.classfile.attribute.DefaultAttribute;
import software.coley.cafedude.classfile.attribute.DeprecatedAttribute;
import software.coley.cafedude.classfile.attribute.EnclosingMethodAttribute;
import software.coley.cafedude.classfile.attribute.ExceptionsAttribute;
import software.coley.cafedude.classfile.attribute.InnerClassesAttribute;
import software.coley.cafedude.classfile.attribute.LineNumberTableAttribute;
import software.coley.cafedude.classfile.attribute.LocalVariableTableAttribute;
import software.coley.cafedude.classfile.attribute.LocalVariableTypeTableAttribute;
import software.coley.cafedude.classfile.attribute.MethodParametersAttribute;
import software.coley.cafedude.classfile.attribute.ModuleAttribute;
import software.coley.cafedude.classfile.attribute.ModuleHashesAttribute;
import software.coley.cafedude.classfile.attribute.ModuleMainClassAttribute;
import software.coley.cafedude.classfile.attribute.ModulePackagesAttribute;
import software.coley.cafedude.classfile.attribute.ModuleTargetAttribute;
import software.coley.cafedude.classfile.attribute.NestHostAttribute;
import software.coley.cafedude.classfile.attribute.NestMembersAttribute;
import software.coley.cafedude.classfile.attribute.ParameterAnnotationsAttribute;
import software.coley.cafedude.classfile.attribute.PermittedClassesAttribute;
import software.coley.cafedude.classfile.attribute.RecordAttribute;
import software.coley.cafedude.classfile.attribute.SignatureAttribute;
import software.coley.cafedude.classfile.attribute.SourceDebugExtensionAttribute;
import software.coley.cafedude.classfile.attribute.SourceFileAttribute;
import software.coley.cafedude.classfile.attribute.StackMapTableAttribute;
import software.coley.cafedude.classfile.attribute.SyntheticAttribute;
import software.coley.cafedude.classfile.constant.CpClass;
import software.coley.cafedude.classfile.constant.CpEntry;
import software.coley.cafedude.classfile.constant.CpMethodHandle;
import software.coley.cafedude.classfile.constant.CpModule;
import software.coley.cafedude.classfile.constant.CpNameType;
import software.coley.cafedude.classfile.constant.CpPackage;
import software.coley.cafedude.classfile.constant.CpUtf8;
import software.coley.cafedude.classfile.instruction.Instruction;
import software.coley.cafedude.io.AnnotationReader;
import software.coley.cafedude.io.AttributeContext;
import software.coley.cafedude.io.ClassBuilder;
import software.coley.cafedude.io.ClassFileReader;
import software.coley.cafedude.io.IndexableByteStream;
import software.coley.cafedude.io.InstructionReader;

public class AttributeReader {
    private static final Logger logger = LoggerFactory.getLogger(AttributeReader.class);
    private final IndexableByteStream is;
    private final ClassFileReader reader;
    private final ClassBuilder builder;
    private final ConstPool cp;
    private final int expectedContentLength;
    private final CpUtf8 name;

    private AttributeReader(@Nonnull ClassFileReader reader, @Nonnull ClassBuilder builder, @Nonnull DataInputStream is) throws IOException {
        this.reader = reader;
        this.builder = builder;
        this.cp = builder.getPool();
        this.name = (CpUtf8)this.cp.get(is.readUnsignedShort());
        this.expectedContentLength = is.readInt();
        byte[] subsection = new byte[this.expectedContentLength];
        is.readFully(subsection);
        this.is = new IndexableByteStream(subsection);
    }

    @Nullable
    public static Attribute readFromClass(@Nonnull ClassFileReader reader, @Nonnull ClassBuilder builder, @Nonnull DataInputStream is, @Nonnull AttributeContext context) {
        try {
            return new AttributeReader(reader, builder, is).read(context);
        }
        catch (Exception ex) {
            logger.debug("Dropping attribute on {}: {}", (Object)context.name(), (Object)ex.getMessage());
            return null;
        }
    }

    @Nullable
    public Attribute readAttribute(@Nonnull AttributeContext context) throws IOException {
        try {
            Attribute attribute = this.read(context);
            if (attribute == null) {
                return null;
            }
            int read = this.is.getIndex();
            if (read != this.expectedContentLength) {
                logger.debug("Invalid '{}' on {}, claimed to be {} bytes, but was {}", new Object[]{this.name.getText(), context.name(), this.expectedContentLength, read});
                return null;
            }
            return attribute;
        }
        catch (InvalidCpIndexException cpIndexException) {
            if (this.name != null) {
                logger.debug("Invalid '{}' on {}, invalid constant pool index: {}", new Object[]{this.name.getText(), context.name(), cpIndexException.getIndex()});
            } else {
                logger.debug("Invalid attribute on {}, invalid attribute name index", (Object)context.name());
            }
            return null;
        }
        catch (Exception ex) {
            if (this.reader.doDropEofAttributes()) {
                if (this.name != null) {
                    logger.debug("Invalid '{}' on {}, EOF thrown when parsing attribute, expected {} bytes", new Object[]{this.name.getText(), context.name(), this.expectedContentLength});
                } else {
                    logger.debug("Invalid attribute on {}, invalid attribute name index", (Object)context.name());
                }
                return null;
            }
            throw ex;
        }
    }

    @Nullable
    private Attribute read(@Nonnull AttributeContext context) throws IOException {
        Collection<AttributeContext> allowedContexts;
        int introducedAt;
        if (this.reader.doDropForwardVersioned() && (introducedAt = AttributeVersions.getIntroducedVersion(this.name.getText())) > this.builder.getVersionMajor()) {
            logger.debug("Found '{}' on {} in class version {}, min supported is {}", new Object[]{this.name.getText(), context.name(), this.builder.getVersionMajor(), introducedAt});
            return null;
        }
        if (this.reader.doDropBadContextAttributes() && !(allowedContexts = AttributeContexts.getAllowedContexts(this.name.getText())).contains((Object)context)) {
            logger.debug("Found '{}' in invalid context {}", (Object)this.name.getText(), (Object)context.name());
            return null;
        }
        switch (this.name.getText()) {
            case "Code": {
                return this.readCode();
            }
            case "ConstantValue": {
                return this.readConstantValue();
            }
            case "Deprecated": {
                return new DeprecatedAttribute(this.name);
            }
            case "EnclosingMethod": {
                return this.readEnclosingMethod();
            }
            case "Exceptions": {
                return this.readExceptions();
            }
            case "InnerClasses": {
                return this.readInnerClasses();
            }
            case "NestHost": {
                return this.readNestHost();
            }
            case "NestMembers": {
                return this.readNestMembers();
            }
            case "SourceDebugExtension": {
                return this.readSourceDebugExtension();
            }
            case "RuntimeInvisibleAnnotations": {
                return this.readAnnotations(context, false);
            }
            case "RuntimeVisibleAnnotations": {
                return this.readAnnotations(context, true);
            }
            case "RuntimeInvisibleParameterAnnotations": {
                return this.readParameterAnnotations(context, false);
            }
            case "RuntimeVisibleParameterAnnotations": {
                return this.readParameterAnnotations(context, true);
            }
            case "RuntimeInvisibleTypeAnnotations": {
                return this.readTypeAnnotations(context, false);
            }
            case "RuntimeVisibleTypeAnnotations": {
                return this.readTypeAnnotations(context, true);
            }
            case "AnnotationDefault": {
                return this.readAnnotationDefault(context);
            }
            case "Synthetic": {
                return this.readSynthetic();
            }
            case "BootstrapMethods": {
                return this.readBoostrapMethods();
            }
            case "Signature": {
                return this.readSignature();
            }
            case "SourceFile": {
                return this.readSourceFile();
            }
            case "MethodParameters": {
                return this.readMethodParameters();
            }
            case "Module": {
                return this.readModule();
            }
            case "ModuleMainClass": {
                return this.readModuleMainClass();
            }
            case "ModulePackages": {
                return this.readModulePackages();
            }
            case "ModuleTarget": {
                return this.readModuleTarget();
            }
            case "ModuleHashes": {
                return this.readModuleHashes();
            }
            case "StackMapTable": {
                return this.readStackMapTable();
            }
            case "LineNumberTable": {
                return this.readLineNumbers();
            }
            case "LocalVariableTable": {
                return this.readLocalVariables();
            }
            case "LocalVariableTypeTable": {
                return this.readLocalVariableTypes();
            }
            case "PermittedSubclasses": {
                return this.readPermittedClasses();
            }
            case "Record": {
                return this.readRecord();
            }
        }
        if (this.expectedContentLength < 2) {
            logger.debug("Invalid attribute, its content length <= 1");
            this.is.skipBytes(this.expectedContentLength);
            return null;
        }
        this.is.skipBytes(this.expectedContentLength);
        return new DefaultAttribute(this.name, this.is.getBuffer());
    }

    @Nonnull
    private RecordAttribute readRecord() throws IOException {
        ArrayList<RecordAttribute.RecordComponent> components = new ArrayList<RecordAttribute.RecordComponent>();
        int count = this.is.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            CpUtf8 name = (CpUtf8)this.cp.get(this.is.readUnsignedShort());
            CpUtf8 descriptor = (CpUtf8)this.cp.get(this.is.readUnsignedShort());
            int numAttributes = this.is.readUnsignedShort();
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            for (int x = 0; x < numAttributes; ++x) {
                Attribute attr = new AttributeReader(this.reader, this.builder, this.is).readAttribute(AttributeContext.ATTRIBUTE);
                if (attr == null) continue;
                attributes.add(attr);
            }
            components.add(new RecordAttribute.RecordComponent(name, descriptor, attributes));
        }
        return new RecordAttribute(this.name, components);
    }

    @Nonnull
    private PermittedClassesAttribute readPermittedClasses() throws IOException {
        ArrayList<CpClass> entries = new ArrayList<CpClass>();
        int count = this.is.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            CpClass entry = (CpClass)this.cp.get(this.is.readUnsignedShort());
            entries.add(entry);
        }
        return new PermittedClassesAttribute(this.name, entries);
    }

    @Nonnull
    private LocalVariableTypeTableAttribute readLocalVariableTypes() throws IOException {
        ArrayList<LocalVariableTypeTableAttribute.VarTypeEntry> entries = new ArrayList<LocalVariableTypeTableAttribute.VarTypeEntry>();
        int count = this.is.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            int startPc = this.is.readUnsignedShort();
            int length = this.is.readUnsignedShort();
            CpUtf8 name = (CpUtf8)this.cp.get(this.is.readUnsignedShort());
            CpUtf8 sig = (CpUtf8)this.cp.get(this.is.readUnsignedShort());
            int index = this.is.readUnsignedShort();
            entries.add(new LocalVariableTypeTableAttribute.VarTypeEntry(startPc, length, name, sig, index));
        }
        return new LocalVariableTypeTableAttribute(this.name, entries);
    }

    @Nonnull
    private LocalVariableTableAttribute readLocalVariables() throws IOException {
        ArrayList<LocalVariableTableAttribute.VarEntry> entries = new ArrayList<LocalVariableTableAttribute.VarEntry>();
        int count = this.is.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            int startPc = this.is.readUnsignedShort();
            int length = this.is.readUnsignedShort();
            CpUtf8 name = (CpUtf8)this.cp.get(this.is.readUnsignedShort());
            CpUtf8 desc = (CpUtf8)this.cp.get(this.is.readUnsignedShort());
            int index = this.is.readUnsignedShort();
            entries.add(new LocalVariableTableAttribute.VarEntry(startPc, length, name, desc, index));
        }
        return new LocalVariableTableAttribute(this.name, entries);
    }

    @Nonnull
    private LineNumberTableAttribute readLineNumbers() throws IOException {
        ArrayList<LineNumberTableAttribute.LineEntry> entries = new ArrayList<LineNumberTableAttribute.LineEntry>();
        int count = this.is.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            int offset = this.is.readUnsignedShort();
            int line = this.is.readUnsignedShort();
            entries.add(new LineNumberTableAttribute.LineEntry(offset, line));
        }
        return new LineNumberTableAttribute(this.name, entries);
    }

    @Nonnull
    private MethodParametersAttribute readMethodParameters() throws IOException {
        ArrayList<MethodParametersAttribute.Parameter> entries = new ArrayList<MethodParametersAttribute.Parameter>();
        int count = this.is.readUnsignedByte();
        for (int i = 0; i < count; ++i) {
            CpUtf8 name = (CpUtf8)this.orNullInCp(this.is.readUnsignedShort());
            int accessFlags = this.is.readUnsignedShort();
            entries.add(new MethodParametersAttribute.Parameter(accessFlags, name));
        }
        return new MethodParametersAttribute(this.name, entries);
    }

    @Nullable
    private ModuleAttribute readModule() throws IOException {
        CpModule module = (CpModule)this.cp.get(this.is.readUnsignedShort());
        if (module == null) {
            return null;
        }
        int flags = this.is.readUnsignedShort();
        CpUtf8 version = (CpUtf8)this.orNullInCp(this.is.readUnsignedShort());
        ArrayList<ModuleAttribute.Requires> requires = new ArrayList<ModuleAttribute.Requires>();
        int count = this.is.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            CpModule reqModule = (CpModule)this.cp.get(this.is.readUnsignedShort());
            if (reqModule == null) continue;
            int reqFlags = this.is.readUnsignedShort();
            CpUtf8 reqVersion = (CpUtf8)this.orNullInCp(this.is.readUnsignedShort());
            requires.add(new ModuleAttribute.Requires(reqModule, reqFlags, reqVersion));
        }
        ArrayList<ModuleAttribute.Exports> exports = new ArrayList<ModuleAttribute.Exports>();
        count = this.is.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            CpPackage expPackage = (CpPackage)this.cp.get(this.is.readUnsignedShort());
            if (expPackage == null) continue;
            int expFlags = this.is.readUnsignedShort();
            int expCount = this.is.readUnsignedShort();
            ArrayList<CpModule> expModules = new ArrayList<CpModule>();
            for (int j = 0; j < expCount; ++j) {
                CpModule expModule = (CpModule)this.cp.get(this.is.readUnsignedShort());
                expModules.add(expModule);
            }
            exports.add(new ModuleAttribute.Exports(expPackage, expFlags, expModules));
        }
        ArrayList<ModuleAttribute.Opens> opens = new ArrayList<ModuleAttribute.Opens>();
        count = this.is.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            CpPackage openPackage = (CpPackage)this.cp.get(this.is.readUnsignedShort());
            if (openPackage == null) continue;
            int openFlags = this.is.readUnsignedShort();
            int openCount = this.is.readUnsignedShort();
            ArrayList<CpModule> openModules = new ArrayList<CpModule>();
            for (int j = 0; j < openCount; ++j) {
                CpModule openModule = (CpModule)this.cp.get(this.is.readUnsignedShort());
                openModules.add(openModule);
            }
            opens.add(new ModuleAttribute.Opens(openPackage, openFlags, openModules));
        }
        ArrayList<CpClass> uses = new ArrayList<CpClass>();
        count = this.is.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            CpClass useClass = (CpClass)this.cp.get(this.is.readUnsignedShort());
            uses.add(useClass);
        }
        ArrayList<ModuleAttribute.Provides> provides = new ArrayList<ModuleAttribute.Provides>();
        count = this.is.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            CpClass service = (CpClass)this.cp.get(this.is.readUnsignedShort());
            if (service == null) continue;
            int prvCount = this.is.readUnsignedShort();
            ArrayList<CpClass> providers = new ArrayList<CpClass>();
            for (int j = 0; j < prvCount; ++j) {
                CpClass provider = (CpClass)this.cp.get(this.is.readUnsignedShort());
                providers.add(provider);
            }
            provides.add(new ModuleAttribute.Provides(service, providers));
        }
        return new ModuleAttribute(this.name, module, flags, version, requires, exports, opens, uses, provides);
    }

    @Nonnull
    private ModuleMainClassAttribute readModuleMainClass() throws IOException {
        return new ModuleMainClassAttribute(this.name, (CpClass)this.cp.get(this.is.readUnsignedShort()));
    }

    @Nonnull
    private ModulePackagesAttribute readModulePackages() throws IOException {
        ArrayList<CpPackage> packages = new ArrayList<CpPackage>();
        int count = this.is.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            packages.add((CpPackage)this.cp.get(this.is.readUnsignedShort()));
        }
        return new ModulePackagesAttribute(this.name, packages);
    }

    @Nonnull
    private ModuleTargetAttribute readModuleTarget() throws IOException {
        CpUtf8 platformName = (CpUtf8)this.cp.get(this.is.readUnsignedShort());
        return new ModuleTargetAttribute(this.name, platformName);
    }

    @Nonnull
    private ModuleHashesAttribute readModuleHashes() throws IOException {
        CpUtf8 algorithm = (CpUtf8)this.cp.get(this.is.readUnsignedShort());
        int moduleCount = this.is.readUnsignedShort();
        LinkedHashMap<CpUtf8, byte[]> moduleHashes = new LinkedHashMap<CpUtf8, byte[]>();
        for (int i = 0; i < moduleCount; ++i) {
            int moduleNameIndex = this.is.readUnsignedShort();
            int moduleHashLength = this.is.readUnsignedShort();
            CpUtf8 moduleName = (CpUtf8)this.cp.get(moduleNameIndex);
            byte[] moduleHash = new byte[moduleHashLength];
            this.is.read(moduleHash);
            moduleHashes.put(moduleName, moduleHash);
        }
        return new ModuleHashesAttribute(this.name, algorithm, moduleHashes);
    }

    @Nonnull
    private SignatureAttribute readSignature() throws IOException {
        CpUtf8 signature = (CpUtf8)this.cp.get(this.is.readUnsignedShort());
        return new SignatureAttribute(this.name, signature);
    }

    @Nonnull
    private SourceFileAttribute readSourceFile() throws IOException {
        CpUtf8 sourceFile = (CpUtf8)this.cp.get(this.is.readUnsignedShort());
        return new SourceFileAttribute(this.name, sourceFile);
    }

    @Nonnull
    private EnclosingMethodAttribute readEnclosingMethod() throws IOException {
        CpClass enclosingClass = (CpClass)this.cp.get(this.is.readUnsignedShort());
        CpNameType enclosingMethod = (CpNameType)this.orNullInCp(this.is.readUnsignedShort());
        return new EnclosingMethodAttribute(this.name, enclosingClass, enclosingMethod);
    }

    @Nonnull
    private ExceptionsAttribute readExceptions() throws IOException {
        int numberOfExceptionIndices = this.is.readUnsignedShort();
        ArrayList<CpClass> exceptions = new ArrayList<CpClass>(numberOfExceptionIndices);
        for (int i = 0; i < numberOfExceptionIndices; ++i) {
            exceptions.add((CpClass)this.cp.get(this.is.readUnsignedShort()));
        }
        return new ExceptionsAttribute(this.name, exceptions);
    }

    @Nonnull
    private InnerClassesAttribute readInnerClasses() throws IOException {
        int numberOfInnerClasses = this.is.readUnsignedShort();
        ArrayList<InnerClassesAttribute.InnerClass> innerClasses = new ArrayList<InnerClassesAttribute.InnerClass>();
        for (int i = 0; i < numberOfInnerClasses; ++i) {
            CpClass innerClass = (CpClass)this.cp.get(this.is.readUnsignedShort());
            CpClass outerClass = (CpClass)this.orNullInCp(this.is.readUnsignedShort());
            CpUtf8 innerName = (CpUtf8)this.orNullInCp(this.is.readUnsignedShort());
            int innerClassAccessFlags = this.is.readUnsignedShort();
            innerClasses.add(new InnerClassesAttribute.InnerClass(innerClass, outerClass, innerName, innerClassAccessFlags));
        }
        return new InnerClassesAttribute(this.name, innerClasses);
    }

    @Nullable
    private NestHostAttribute readNestHost() throws IOException {
        if (this.expectedContentLength != 2) {
            logger.debug("Found NestHost with illegal content length: {} != 2", (Object)this.expectedContentLength);
            return null;
        }
        CpClass nestHost = (CpClass)this.cp.get(this.is.readUnsignedShort());
        return new NestHostAttribute(this.name, nestHost);
    }

    @Nonnull
    private NestMembersAttribute readNestMembers() throws IOException {
        int count = this.is.readUnsignedShort();
        ArrayList<CpClass> memberClassIndices = new ArrayList<CpClass>();
        for (int i = 0; i < count; ++i) {
            memberClassIndices.add((CpClass)this.cp.get(this.is.readUnsignedShort()));
        }
        return new NestMembersAttribute(this.name, memberClassIndices);
    }

    @Nullable
    private SourceDebugExtensionAttribute readSourceDebugExtension() throws IOException {
        byte[] debugExtension = new byte[this.expectedContentLength];
        this.is.readFully(debugExtension);
        try {
            new DataInputStream(new ByteArrayInputStream(debugExtension)).readUTF();
        }
        catch (Throwable t) {
            logger.debug("Invalid SourceDebugExtension, not a valid UTF");
            return null;
        }
        return new SourceDebugExtensionAttribute(this.name, debugExtension);
    }

    @Nullable
    private AnnotationsAttribute readAnnotations(AttributeContext context, boolean visible) throws IOException {
        return new AnnotationReader(this.reader, this.builder.getPool(), this.is, this.expectedContentLength, this.name, context, visible).readAnnotations();
    }

    @Nullable
    private ParameterAnnotationsAttribute readParameterAnnotations(AttributeContext context, boolean visible) throws IOException {
        return new AnnotationReader(this.reader, this.builder.getPool(), this.is, this.expectedContentLength, this.name, context, visible).readParameterAnnotations();
    }

    @Nullable
    private AnnotationsAttribute readTypeAnnotations(AttributeContext context, boolean visible) throws IOException {
        return new AnnotationReader(this.reader, this.builder.getPool(), this.is, this.expectedContentLength, this.name, context, visible).readTypeAnnotations();
    }

    @Nullable
    private AnnotationDefaultAttribute readAnnotationDefault(AttributeContext context) throws IOException {
        return new AnnotationReader(this.reader, this.builder.getPool(), this.is, this.expectedContentLength, this.name, context, true).readAnnotationDefault();
    }

    @Nonnull
    private SyntheticAttribute readSynthetic() {
        return new SyntheticAttribute(this.name);
    }

    @Nonnull
    private BootstrapMethodsAttribute readBoostrapMethods() throws IOException {
        ArrayList<BootstrapMethodsAttribute.BootstrapMethod> bootstrapMethods = new ArrayList<BootstrapMethodsAttribute.BootstrapMethod>();
        int bsmCount = this.is.readUnsignedShort();
        for (int i = 0; i < bsmCount; ++i) {
            CpMethodHandle methodRef = (CpMethodHandle)this.cp.get(this.is.readUnsignedShort());
            int argCount = this.is.readUnsignedShort();
            ArrayList<CpEntry> args = new ArrayList<CpEntry>();
            for (int j = 0; j < argCount; ++j) {
                args.add(this.cp.get(this.is.readUnsignedShort()));
            }
            bootstrapMethods.add(new BootstrapMethodsAttribute.BootstrapMethod(methodRef, args));
        }
        return new BootstrapMethodsAttribute(this.name, bootstrapMethods);
    }

    @Nonnull
    private CodeAttribute readCode() throws IOException {
        int maxStack = -1;
        int maxLocals = -1;
        int codeLength = -1;
        ArrayList<CodeAttribute.ExceptionTableEntry> exceptions = new ArrayList<CodeAttribute.ExceptionTableEntry>();
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        if (this.builder.isOakVersion()) {
            maxStack = this.is.readUnsignedByte();
            maxLocals = this.is.readUnsignedByte();
            codeLength = this.is.readUnsignedShort();
        } else {
            maxStack = this.is.readUnsignedShort();
            maxLocals = this.is.readUnsignedShort();
            codeLength = this.is.readInt();
        }
        byte[] code = new byte[codeLength];
        this.is.readFully(code);
        InstructionReader reader = new InstructionReader(this.reader.fallbackReaderSupplier.get());
        List<Instruction> instructions = reader.read(code, this.cp);
        int numExceptions = this.is.readUnsignedShort();
        for (int i = 0; i < numExceptions; ++i) {
            exceptions.add(this.readCodeException());
        }
        int numAttributes = this.is.readUnsignedShort();
        for (int i = 0; i < numAttributes; ++i) {
            Attribute attr = new AttributeReader(this.reader, this.builder, this.is).readAttribute(AttributeContext.ATTRIBUTE);
            if (attr == null) continue;
            attributes.add(attr);
        }
        return new CodeAttribute(this.name, maxStack, maxLocals, instructions, exceptions, attributes);
    }

    @Nonnull
    private CodeAttribute.ExceptionTableEntry readCodeException() throws IOException {
        return new CodeAttribute.ExceptionTableEntry(this.is.readUnsignedShort(), this.is.readUnsignedShort(), this.is.readUnsignedShort(), (CpClass)this.orNullInCp(this.is.readUnsignedShort()));
    }

    @Nonnull
    private ConstantValueAttribute readConstantValue() throws IOException {
        CpEntry value = this.cp.get(this.is.readUnsignedShort());
        return new ConstantValueAttribute(this.name, value);
    }

    @Nonnull
    private StackMapTableAttribute readStackMapTable() throws IOException {
        int numEntries = this.is.readUnsignedShort();
        ArrayList<StackMapTableAttribute.StackMapFrame> frames = new ArrayList<StackMapTableAttribute.StackMapFrame>(numEntries);
        for (int i = 0; i < numEntries; ++i) {
            int j;
            ArrayList<StackMapTableAttribute.TypeInfo> locals;
            int frameType = this.is.readUnsignedByte();
            if (frameType <= 63) {
                frames.add(new StackMapTableAttribute.SameFrame(frameType));
                continue;
            }
            if (frameType <= 127) {
                StackMapTableAttribute.TypeInfo stack = this.readVerificationTypeInfo();
                frames.add(new StackMapTableAttribute.SameLocalsOneStackItem(frameType - 64, stack));
                continue;
            }
            if (frameType < 247) {
                throw new IllegalArgumentException("Unknown stackframe tag " + frameType);
            }
            if (frameType <= 247) {
                int offsetDelta = this.is.readUnsignedShort();
                StackMapTableAttribute.TypeInfo stack = this.readVerificationTypeInfo();
                frames.add(new StackMapTableAttribute.SameLocalsOneStackItemExtended(offsetDelta, stack));
                continue;
            }
            if (frameType <= 250) {
                int k = 251 - frameType;
                int offsetDelta = this.is.readUnsignedShort();
                frames.add(new StackMapTableAttribute.ChopFrame(offsetDelta, k));
                continue;
            }
            if (frameType < 252) {
                int offsetDelta = this.is.readUnsignedShort();
                frames.add(new StackMapTableAttribute.SameFrameExtended(offsetDelta));
                continue;
            }
            if (frameType <= 254) {
                int offsetDelta = this.is.readUnsignedShort();
                int numLocals = frameType - 251;
                locals = new ArrayList<StackMapTableAttribute.TypeInfo>(numLocals);
                for (j = 0; j < numLocals; ++j) {
                    locals.add(this.readVerificationTypeInfo());
                }
                frames.add(new StackMapTableAttribute.AppendFrame(offsetDelta, locals));
                continue;
            }
            if (frameType <= 255) {
                int offsetDelta = this.is.readUnsignedShort();
                int numLocals = this.is.readUnsignedShort();
                locals = new ArrayList(numLocals);
                for (j = 0; j < numLocals; ++j) {
                    locals.add(this.readVerificationTypeInfo());
                }
                int numStackItems = this.is.readUnsignedShort();
                ArrayList<StackMapTableAttribute.TypeInfo> stack = new ArrayList<StackMapTableAttribute.TypeInfo>(numStackItems);
                for (int j2 = 0; j2 < numStackItems; ++j2) {
                    stack.add(this.readVerificationTypeInfo());
                }
                frames.add(new StackMapTableAttribute.FullFrame(offsetDelta, locals, stack));
                continue;
            }
            throw new IllegalArgumentException("Unknown frame type " + frameType);
        }
        return new StackMapTableAttribute(this.name, frames);
    }

    @Nonnull
    private StackMapTableAttribute.TypeInfo readVerificationTypeInfo() throws IOException {
        int tag = this.is.readUnsignedByte();
        switch (tag) {
            case 0: {
                return new StackMapTableAttribute.TopVariableInfo();
            }
            case 1: {
                return new StackMapTableAttribute.IntegerVariableInfo();
            }
            case 2: {
                return new StackMapTableAttribute.FloatVariableInfo();
            }
            case 3: {
                return new StackMapTableAttribute.DoubleVariableInfo();
            }
            case 4: {
                return new StackMapTableAttribute.LongVariableInfo();
            }
            case 5: {
                return new StackMapTableAttribute.NullVariableInfo();
            }
            case 6: {
                return new StackMapTableAttribute.UninitializedThisVariableInfo();
            }
            case 7: {
                CpClass classEntry = (CpClass)this.cp.get(this.is.readUnsignedShort());
                return new StackMapTableAttribute.ObjectVariableInfo(classEntry);
            }
            case 8: {
                int offset = this.is.readUnsignedShort();
                return new StackMapTableAttribute.UninitializedVariableInfo(offset);
            }
        }
        throw new IllegalArgumentException("Unknown verification type tag " + tag);
    }

    @Nullable
    private <T extends CpEntry> T orNullInCp(int index) {
        return (T)(index == 0 ? null : this.cp.get(index));
    }
}

