/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.transform;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import software.coley.cafedude.classfile.ConstPool;
import software.coley.cafedude.classfile.constant.CpDynamic;
import software.coley.cafedude.classfile.constant.CpEntry;
import software.coley.cafedude.classfile.constant.CpMethodHandle;
import software.coley.cafedude.classfile.constant.CpMethodType;
import software.coley.cafedude.classfile.constant.CpString;
import software.coley.cafedude.classfile.instruction.BasicInstruction;
import software.coley.cafedude.classfile.instruction.Instruction;
import software.coley.cafedude.classfile.instruction.IntOperandInstruction;
import software.coley.cafedude.io.FallbackInstructionReader;

final class IllegalRewritingInstructionsReader
implements FallbackInstructionReader {
    private static final Instruction NOP_INSN = new BasicInstruction(0);
    private static final Instruction ALOAD_0_INSN = new BasicInstruction(42);
    private static final Instruction RETURN_INSN = new BasicInstruction(177);
    private final ConstPool cp;
    private Map<Integer, Integer> cpMap;
    boolean rewritten;

    public IllegalRewritingInstructionsReader(ConstPool cp) {
        this.cp = cp;
    }

    @Override
    public List<Instruction> read(int opcode, ByteBuffer buffer) {
        switch (opcode) {
            case 202: {
                this.rewritten = true;
                buffer.get();
                return Arrays.asList(NOP_INSN, NOP_INSN);
            }
            case 220: {
                this.rewritten = true;
                return Collections.singletonList(ALOAD_0_INSN);
            }
            case 230: {
                this.rewritten = true;
                return Collections.singletonList(new IntOperandInstruction(18, this.rewriteIndex(buffer.get() & 0xFF)));
            }
            case 231: {
                this.rewritten = true;
                short idx = buffer.getShort();
                int newIndex = this.rewriteIndex(idx & 0xFFFF);
                if (newIndex == -1) {
                    newIndex = this.rewriteIndex(IllegalRewritingInstructionsReader.swap(idx) & 0xFFFF);
                }
                if (newIndex == -1) {
                    throw new IllegalStateException("Failed to rewrite fast_aldc_w: " + idx);
                }
                return Collections.singletonList(new IntOperandInstruction(19, newIndex));
            }
            case 232: {
                this.rewritten = true;
                return Collections.singletonList(RETURN_INSN);
            }
            case 234: {
                this.rewritten = true;
                return Collections.singletonList(NOP_INSN);
            }
        }
        throw new IllegalStateException("Don't know how to rewrite " + opcode);
    }

    private int rewriteIndex(int idx) {
        Integer v;
        Map<Integer, Integer> cpMap = this.cpMap;
        if (cpMap == null) {
            cpMap = new HashMap<Integer, Integer>();
            int index = 0;
            int cpIndex = 1;
            for (CpEntry item : this.cp) {
                if (item instanceof CpString || item instanceof CpMethodHandle || item instanceof CpMethodType || item instanceof CpDynamic) {
                    cpMap.put(index++, cpIndex);
                }
                ++cpIndex;
                if (!item.isWide()) continue;
                ++cpIndex;
            }
            this.cpMap = cpMap;
        }
        return (v = cpMap.get(idx)) == null ? -1 : v;
    }

    private static short swap(short x) {
        return (short)(x >> 8 & 0xFF | x << 8);
    }
}

