/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.classfile.attribute;

import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import software.coley.cafedude.classfile.annotation.Annotation;
import software.coley.cafedude.classfile.attribute.Attribute;
import software.coley.cafedude.classfile.constant.CpEntry;
import software.coley.cafedude.classfile.constant.CpUtf8;

public class AnnotationsAttribute
extends Attribute {
    private List<Annotation> annotations;
    private boolean visible;

    public AnnotationsAttribute(@Nonnull CpUtf8 name, @Nonnull List<Annotation> annotations, boolean visible) {
        super(name);
        this.annotations = annotations;
        this.visible = visible;
    }

    @Nonnull
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(@Nonnull List<Annotation> annotations) {
        this.annotations = annotations;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    @Nonnull
    public Set<CpEntry> cpAccesses() {
        Set<CpEntry> set = super.cpAccesses();
        for (Annotation annotation : this.getAnnotations()) {
            set.addAll(annotation.cpAccesses());
        }
        return set;
    }

    @Override
    public int computeInternalLength() {
        return 2 + this.annotations.stream().mapToInt(Annotation::computeLength).sum();
    }
}

