/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.classfile.attribute;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import software.coley.cafedude.classfile.attribute.Attribute;
import software.coley.cafedude.classfile.behavior.CpAccessor;
import software.coley.cafedude.classfile.constant.CpEntry;
import software.coley.cafedude.classfile.constant.CpUtf8;

public class MethodParametersAttribute
extends Attribute {
    private List<Parameter> parameters;

    public MethodParametersAttribute(@Nonnull CpUtf8 name, @Nonnull List<Parameter> parameters) {
        super(name);
        this.parameters = parameters;
    }

    @Nonnull
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(@Nonnull List<Parameter> parameters) {
        this.parameters = parameters;
    }

    @Override
    @Nonnull
    public Set<CpEntry> cpAccesses() {
        Set<CpEntry> set = super.cpAccesses();
        for (Parameter p : this.parameters) {
            set.addAll(p.cpAccesses());
        }
        return set;
    }

    @Override
    public int computeInternalLength() {
        return 1 + this.parameters.size() * 4;
    }

    public static class Parameter
    implements CpAccessor {
        private int accessFlags;
        private CpUtf8 name;

        public Parameter(int accessFlags, @Nullable CpUtf8 name) {
            this.accessFlags = accessFlags;
            this.name = name;
        }

        public int getAccessFlags() {
            return this.accessFlags;
        }

        public void setAccessFlags(int accessFlags) {
            this.accessFlags = accessFlags;
        }

        @Nullable
        public CpUtf8 getName() {
            return this.name;
        }

        public void setName(@Nullable CpUtf8 name) {
            this.name = name;
        }

        @Override
        @Nonnull
        public Set<CpEntry> cpAccesses() {
            HashSet<CpEntry> set = new HashSet<CpEntry>();
            if (this.name != null) {
                set.add(this.name);
            }
            return set;
        }
    }
}

