/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.classfile.instruction;

import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import software.coley.cafedude.classfile.behavior.CpAccessor;
import software.coley.cafedude.classfile.constant.CpEntry;
import software.coley.cafedude.classfile.instruction.BasicInstruction;

public class CpRefInstruction
extends BasicInstruction
implements CpAccessor {
    private CpEntry entry;

    public CpRefInstruction(int opcode, @Nonnull CpEntry entry) {
        super(opcode);
        this.entry = entry;
    }

    @Nonnull
    public CpEntry getEntry() {
        return this.entry;
    }

    public void setEntry(@Nonnull CpEntry entry) {
        this.entry = entry;
    }

    @Override
    public int computeSize() {
        int opcode = this.getOpcode();
        if (opcode == 18) {
            return 2;
        }
        if (opcode == 186 || opcode == 185) {
            return 5;
        }
        return 3;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CpRefInstruction)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CpRefInstruction that = (CpRefInstruction)o;
        return this.entry.equals(that.entry);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.entry.hashCode();
        return result;
    }

    @Override
    @Nonnull
    public Set<CpEntry> cpAccesses() {
        return Collections.singleton(this.entry);
    }
}

