/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.classfile.annotation;

import javax.annotation.Nonnull;
import software.coley.cafedude.classfile.annotation.AnnotationConstants;

public enum TargetInfoType implements AnnotationConstants
{
    TYPE_PARAMETER_TARGET,
    SUPERTYPE_TARGET,
    TYPE_PARAMETER_BOUND_TARGET,
    EMPTY_TARGET,
    FORMAL_PARAMETER_TARGET,
    THROWS_TARGET,
    LOCALVAR_TARGET,
    CATCH_TARGET,
    OFFSET_TARGET,
    TYPE_ARGUMENT_TARGET;


    @Nonnull
    public static TargetInfoType fromTargetType(int type) {
        switch (type) {
            case 0: 
            case 1: {
                return TYPE_PARAMETER_TARGET;
            }
            case 16: {
                return SUPERTYPE_TARGET;
            }
            case 17: 
            case 18: {
                return TYPE_PARAMETER_BOUND_TARGET;
            }
            case 19: 
            case 20: 
            case 21: {
                return EMPTY_TARGET;
            }
            case 22: {
                return FORMAL_PARAMETER_TARGET;
            }
            case 23: {
                return THROWS_TARGET;
            }
            case 64: 
            case 65: {
                return LOCALVAR_TARGET;
            }
            case 66: {
                return CATCH_TARGET;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                return OFFSET_TARGET;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                return TYPE_ARGUMENT_TARGET;
            }
        }
        throw new IllegalArgumentException("Invalid type annotation target_type value");
    }
}

