/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.classfile.attribute;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import software.coley.cafedude.classfile.attribute.Attribute;
import software.coley.cafedude.classfile.behavior.CpAccessor;
import software.coley.cafedude.classfile.constant.CpEntry;
import software.coley.cafedude.classfile.constant.CpUtf8;

public class LocalVariableTableAttribute
extends Attribute {
    private List<VarEntry> entries;

    public LocalVariableTableAttribute(@Nonnull CpUtf8 name, @Nonnull List<VarEntry> entries) {
        super(name);
        this.entries = entries;
    }

    @Override
    @Nonnull
    public Set<CpEntry> cpAccesses() {
        Set<CpEntry> set = super.cpAccesses();
        for (VarEntry entry : this.getEntries()) {
            set.addAll(entry.cpAccesses());
        }
        return set;
    }

    @Override
    public int computeInternalLength() {
        return 2 + 10 * this.entries.size();
    }

    @Nonnull
    public List<VarEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(@Nonnull List<VarEntry> entries) {
        this.entries = entries;
    }

    public static class VarEntry
    implements CpAccessor {
        private final int startPc;
        private final int length;
        private final CpUtf8 name;
        private final CpUtf8 desc;
        private final int index;

        public VarEntry(int startPc, int length, @Nonnull CpUtf8 name, @Nonnull CpUtf8 desc, int index) {
            this.startPc = startPc;
            this.length = length;
            this.name = name;
            this.desc = desc;
            this.index = index;
        }

        public int getStartPc() {
            return this.startPc;
        }

        public int getLength() {
            return this.length;
        }

        @Nonnull
        public CpUtf8 getName() {
            return this.name;
        }

        @Nonnull
        public CpUtf8 getDesc() {
            return this.desc;
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        @Nonnull
        public Set<CpEntry> cpAccesses() {
            HashSet<CpEntry> set = new HashSet<CpEntry>();
            set.add(this.getName());
            set.add(this.getDesc());
            return set;
        }
    }
}

