/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.io;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import software.coley.cafedude.InvalidClassException;
import software.coley.cafedude.classfile.ClassFile;
import software.coley.cafedude.classfile.ConstPool;
import software.coley.cafedude.classfile.Field;
import software.coley.cafedude.classfile.Method;
import software.coley.cafedude.classfile.Modifiers;
import software.coley.cafedude.classfile.attribute.Attribute;
import software.coley.cafedude.classfile.constant.CpClass;
import software.coley.cafedude.classfile.constant.Placeholders;

public class ClassBuilder {
    private final List<Attribute> attributes = new ArrayList<Attribute>();
    private final List<CpClass> interfaces = new ArrayList<CpClass>();
    private final List<Field> fields = new ArrayList<Field>();
    private final List<Method> methods = new ArrayList<Method>();
    private ConstPool pool = new ConstPool();
    private int versionMajor;
    private int versionMinor;
    private int access;
    private CpClass thisClass = Placeholders.CLASS;
    private CpClass superClass = Placeholders.CLASS;

    public boolean isOakVersion() {
        return this.versionMajor == 45 && this.versionMinor <= 2 || this.versionMajor < 45;
    }

    public boolean isAnnotation() {
        return Modifiers.has(this.access, 8192);
    }

    @Nonnull
    public ConstPool getPool() {
        return this.pool;
    }

    public void setConstPool(@Nonnull ConstPool pool) {
        this.pool = pool;
    }

    public int getVersionMajor() {
        return this.versionMajor;
    }

    public void setVersionMajor(int versionMajor) {
        this.versionMajor = versionMajor;
    }

    public int getVersionMinor() {
        return this.versionMinor;
    }

    public void setVersionMinor(int versionMinor) {
        this.versionMinor = versionMinor;
    }

    public int getAccess() {
        return this.access;
    }

    public void setAccess(int access) {
        this.access = access;
    }

    public void setThisClass(@Nonnull CpClass thisClass) {
        this.thisClass = thisClass;
    }

    public void setSuperClass(@Nullable CpClass superClass) {
        this.superClass = superClass;
    }

    public void addInterface(@Nonnull CpClass interfaceEntry) {
        this.interfaces.add(interfaceEntry);
    }

    public void addField(@Nonnull Field field) {
        this.fields.add(field);
    }

    public void addMethod(@Nonnull Method method) {
        this.methods.add(method);
    }

    public void addAttribute(@Nonnull Attribute attribute) {
        this.attributes.add(attribute);
    }

    @Nonnull
    public List<CpClass> getInterfaces() {
        return this.interfaces;
    }

    @Nonnull
    public List<Field> getFields() {
        return this.fields;
    }

    @Nonnull
    public List<Method> getMethods() {
        return this.methods;
    }

    @Nonnull
    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    @Nonnull
    public ClassFile build() throws InvalidClassException {
        for (CpClass iface : this.interfaces) {
            if (iface != null) continue;
            throw new InvalidClassException("Interface entry was null");
        }
        return new ClassFile(this.versionMinor, this.versionMajor, this.pool, this.access, this.thisClass, this.superClass, this.interfaces, this.fields, this.methods, this.attributes);
    }
}

