/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.classfile;

import jakarta.annotation.Nonnull;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import software.coley.cafedude.classfile.Accessible;
import software.coley.cafedude.classfile.attribute.Attribute;
import software.coley.cafedude.classfile.behavior.AttributeHolder;
import software.coley.cafedude.classfile.behavior.CpAccessor;
import software.coley.cafedude.classfile.constant.CpEntry;
import software.coley.cafedude.classfile.constant.CpUtf8;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class ClassMember
implements Accessible,
AttributeHolder,
CpAccessor {
    private List<Attribute> attributes;
    private int access;
    private CpUtf8 name;
    private CpUtf8 type;

    public ClassMember(@Nonnull List<Attribute> attributes, int access, @Nonnull CpUtf8 name, @Nonnull CpUtf8 type) {
        this.attributes = attributes;
        this.access = access;
        this.name = name;
        this.type = type;
    }

    @Override
    public int getAccess() {
        return this.access;
    }

    @Override
    public void setAccess(int access) {
        this.access = access;
    }

    @Nonnull
    public CpUtf8 getName() {
        return this.name;
    }

    public void setName(@Nonnull CpUtf8 name) {
        this.name = name;
    }

    @Nonnull
    public CpUtf8 getType() {
        return this.type;
    }

    public void setType(@Nonnull CpUtf8 type) {
        this.type = type;
    }

    @Override
    @Nonnull
    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(@Nonnull List<Attribute> attributes) {
        this.attributes = attributes;
    }

    @Override
    public <T extends Attribute> T getAttribute(Class<T> type) {
        for (Attribute attribute : this.attributes) {
            if (!type.isInstance(attribute)) continue;
            return (T)((Attribute)type.cast(attribute));
        }
        return null;
    }

    @Override
    @Nonnull
    public Set<CpEntry> cpAccesses() {
        HashSet<CpEntry> set = new HashSet<CpEntry>();
        set.add(this.getName());
        set.add(this.getType());
        for (Attribute attribute : this.getAttributes()) {
            set.addAll(attribute.cpAccesses());
        }
        return set;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassMember that = (ClassMember)o;
        if (this.access != that.access) {
            return false;
        }
        if (!this.attributes.equals(that.attributes)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.attributes.hashCode();
        result = 31 * result + this.access;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }
}

