/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.classfile;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import software.coley.cafedude.classfile.constant.CpEntry;
import software.coley.cafedude.classfile.constant.CpInternal;

public class ConstPool
implements List<CpEntry> {
    private final List<CpEntry> backing = new ArrayList<CpEntry>();

    public ConstPool() {
        this.backing.add(ImplZero.INSTANCE);
    }

    @Override
    public int size() {
        return this.backing.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() <= 1;
    }

    @Override
    public boolean contains(Object o) {
        return this.backing.contains(o);
    }

    @Override
    public int indexOf(Object o) {
        for (int i = 1; i < this.backing.size(); ++i) {
            if (!Objects.equals(this.backing.get(i), o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        for (int i = this.backing.size() - 1; i >= 1; --i) {
            if (!Objects.equals(this.backing.get(i), o)) continue;
            return i;
        }
        return -1;
    }

    @Nonnull
    public CpIterator iterator() {
        return this.listIterator();
    }

    @Nonnull
    public CpIterator listIterator() {
        return this.listIterator(1);
    }

    @Nonnull
    public CpIterator listIterator(int index) {
        return new CpIterator(this, index);
    }

    @Override
    @Nonnull
    public Object[] toArray() {
        Object[] array = this.backing.toArray();
        for (int i = 0; i < array.length; ++i) {
            Object o = array[i];
            if (!(o instanceof CpEntry) || ((CpEntry)o).getTag() > 0) continue;
            array[i] = null;
        }
        return array;
    }

    @Override
    @Nonnull
    public <T> T[] toArray(@Nonnull T[] array) {
        return this.toArray();
    }

    @Override
    @Nonnull
    public List<CpEntry> subList(int fromIndex, int toIndex) {
        ArrayList<CpEntry> list = new ArrayList<CpEntry>();
        for (int i = fromIndex; i < toIndex; ++i) {
            CpEntry cp = this.get(i);
            if (cp.getTag() <= 0) continue;
            list.add(cp);
        }
        return list;
    }

    @Override
    public boolean add(CpEntry cp) {
        int index = this.size();
        this.backing.add(cp);
        cp.setIndex(index);
        if (cp.isWide()) {
            this.backing.add(ImplWidePadding.INSTANCE);
        }
        return true;
    }

    @Override
    public void add(int index, CpEntry cp) {
        if (cp.isWide()) {
            this.backing.add(index, ImplWidePadding.INSTANCE);
        }
        this.backing.add(index, cp);
        this.fixIndices(index);
    }

    @Override
    public boolean addAll(Collection<? extends CpEntry> c) {
        boolean res = false;
        for (CpEntry cpEntry : c) {
            res |= this.add(cpEntry);
        }
        return res;
    }

    @Override
    public boolean addAll(int index, Collection<? extends CpEntry> c) {
        for (CpEntry cpEntry : c) {
            this.add(index, cpEntry);
        }
        return true;
    }

    @Override
    public boolean remove(Object o) {
        int i = this.indexOf(o);
        if (i >= 1) {
            return this.remove(i) != null;
        }
        return false;
    }

    @Override
    public CpEntry remove(int index) {
        CpEntry removed = this.backing.remove(index);
        if (removed.isWide() && this.backing.get(index) instanceof ImplWidePadding) {
            this.backing.remove(index);
        }
        this.fixIndices(index);
        return removed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean res = false;
        for (Object o : c) {
            if (!(o instanceof CpEntry)) continue;
            res |= this.add((CpEntry)o);
        }
        return res;
    }

    @Override
    public void clear() {
        this.backing.clear();
        this.backing.add(ImplZero.INSTANCE);
    }

    @Override
    public boolean containsAll(@Nonnull Collection<?> c) {
        return c.stream().allMatch(this::contains);
    }

    @Override
    public boolean retainAll(@Nonnull Collection<?> c) {
        boolean ret = false;
        for (CpEntry cp : this) {
            if (c.contains(cp)) continue;
            ret |= this.remove(cp);
        }
        return ret;
    }

    @Override
    public CpEntry get(int index) {
        if (index < 1 || index >= this.size()) {
            return null;
        }
        CpEntry cp = this.backing.get(index);
        if (cp.getTag() <= 0) {
            return null;
        }
        return cp;
    }

    @Override
    public CpEntry set(int index, CpEntry cp) {
        if (cp == null) {
            throw new IllegalArgumentException("Cannot set null");
        }
        if (index < 1 || index >= this.size()) {
            return null;
        }
        return this.backing.set(index, cp);
    }

    protected void fixIndices(int startingIndex) {
        this.listIterator(startingIndex).forEach((int i, CpEntry entry) -> entry.setIndex(i));
    }

    @Nonnull
    public static CpEntry getWideFiller() {
        return ImplWidePadding.INSTANCE;
    }

    private static class ImplZero
    extends CpInternal {
        private static final ImplZero INSTANCE = new ImplZero();

        public ImplZero() {
            super(-1);
        }

        @Override
        public String toString() {
            return "Zero";
        }
    }

    public static class CpIterator
    implements ListIterator<CpEntry> {
        private final ConstPool pool;
        private int cursor;

        public CpIterator(@Nonnull ConstPool pool, int cursor) {
            this.pool = pool;
            this.cursor = cursor;
        }

        public void forEach(@Nonnull CpConsumer consumer) {
            while (this.hasNext()) {
                int i = this.cursor;
                CpEntry next = this.next();
                consumer.accept(i, next);
            }
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.pool.size();
        }

        @Override
        public CpEntry next() {
            if (this.hasNext()) {
                CpEntry cp = this.pool.get(this.cursor);
                if (cp == null) {
                    throw new NoSuchElementException("No CP at " + this.cursor);
                }
                this.cursor += cp.isWide() ? 2 : 1;
                return cp;
            }
            throw new NoSuchElementException("End of CP");
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 1;
        }

        @Override
        public CpEntry previous() {
            if (this.hasPrevious()) {
                CpEntry cp = this.pool.get(this.cursor - 1);
                if (cp == null) {
                    throw new NoSuchElementException("No CP at " + (this.cursor - 1));
                }
                if (cp.getTag() <= 0) {
                    cp = this.pool.get(this.cursor - 2);
                }
                if (cp == null) {
                    throw new NoSuchElementException("No CP at " + (this.cursor - 2));
                }
                this.cursor -= cp.isWide() ? 2 : 1;
                return cp;
            }
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return Math.min(this.cursor + 1, this.pool.size());
        }

        @Override
        public int previousIndex() {
            if (this.hasPrevious()) {
                CpEntry cp = this.pool.get(this.cursor - 1);
                if (cp == null) {
                    return -1;
                }
                return cp.getTag() <= 0 ? this.cursor - 2 : this.cursor - 1;
            }
            return -1;
        }

        @Override
        public void remove() {
            int remove = this.previousIndex();
            if (remove < 1) {
                throw new IllegalStateException();
            }
            this.pool.remove(remove);
        }

        @Override
        public void set(CpEntry cp) {
            this.pool.set(this.cursor, cp);
        }

        @Override
        public void add(CpEntry cp) {
            this.pool.set(this.cursor, cp);
        }

        public static interface CpConsumer {
            public void accept(int var1, @Nonnull CpEntry var2);
        }
    }

    private static class ImplWidePadding
    extends CpInternal {
        private static final ImplWidePadding INSTANCE = new ImplWidePadding();

        public ImplWidePadding() {
            super(-1);
        }

        @Override
        public String toString() {
            return "WidePadding";
        }
    }
}

