/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.classfile;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Descriptor {
    public static final Descriptor VOID = new Descriptor(Kind.PRIMITIVE, "V");
    public static final Descriptor BOOLEAN = new Descriptor(Kind.PRIMITIVE, "Z");
    public static final Descriptor BYTE = new Descriptor(Kind.PRIMITIVE, "B");
    public static final Descriptor CHAR = new Descriptor(Kind.PRIMITIVE, "C");
    public static final Descriptor SHORT = new Descriptor(Kind.PRIMITIVE, "S");
    public static final Descriptor INT = new Descriptor(Kind.PRIMITIVE, "I");
    public static final Descriptor FLOAT = new Descriptor(Kind.PRIMITIVE, "F");
    public static final Descriptor DOUBLE = new Descriptor(Kind.PRIMITIVE, "D");
    public static final Descriptor LONG = new Descriptor(Kind.PRIMITIVE, "J");
    public static final Descriptor OBJECT = new Descriptor(Kind.OBJECT, "Ljava/lang/Object;");
    private final Kind kind;
    private final String desc;
    private final int arrayLevel;

    private Descriptor(@Nonnull Kind kind, @Nonnull String desc) {
        this(kind, desc, 0);
    }

    private Descriptor(@Nonnull Kind kind, @Nonnull String desc, int arrayLevel) {
        this.kind = kind;
        this.desc = desc;
        this.arrayLevel = arrayLevel;
    }

    @Nonnull
    public Descriptor getElementDesc() {
        if (this.arrayLevel == 0) {
            return this;
        }
        return Descriptor.from(this.desc.substring(this.arrayLevel));
    }

    @Nonnull
    public List<Descriptor> getParameters() {
        if (this.kind == Kind.METHOD) {
            int current = 1;
            int max = this.desc.indexOf(41);
            if (max == 1) {
                return Collections.emptyList();
            }
            ArrayList<Descriptor> list = new ArrayList<Descriptor>();
            while (current < max) {
                char c = this.desc.charAt(current);
                if (Descriptor.isPrimitive(c)) {
                    list.add(Descriptor.from(c));
                    ++current;
                    continue;
                }
                if (c == 'L') {
                    int end = this.desc.indexOf(59, current + 2);
                    if (end < 0) {
                        return list;
                    }
                    list.add(Descriptor.from(this.desc.substring(current, end + 1)));
                    current = end + 1;
                    continue;
                }
                if (c == '[') {
                    int start = current;
                    while ((c = this.desc.charAt(++current)) == '[') {
                    }
                    if (Descriptor.isPrimitive(c)) {
                        ++current;
                    } else if (c == 'L') {
                        int end = this.desc.indexOf(59, current + 2);
                        if (end < 0) {
                            return list;
                        }
                        current = end + 1;
                    } else {
                        return list;
                    }
                    list.add(Descriptor.from(this.desc.substring(start, current)));
                    continue;
                }
                return list;
            }
            return list;
        }
        return Collections.singletonList(this);
    }

    public int getParameterCount() {
        if (this.kind == Kind.METHOD) {
            int count = 0;
            int current = 1;
            int max = this.desc.indexOf(41);
            while (current < max) {
                int end;
                char c = this.desc.charAt(current);
                if (Descriptor.isPrimitive(c)) {
                    ++count;
                    ++current;
                    continue;
                }
                if (c == 'L') {
                    ++count;
                    end = this.desc.indexOf(59, current + 2);
                    if (end < 0) {
                        return -1;
                    }
                    current = end + 1;
                    continue;
                }
                if (c == '[') {
                    while ((c = this.desc.charAt(++current)) == '[') {
                    }
                    if (Descriptor.isPrimitive(c)) {
                        ++current;
                        ++count;
                        continue;
                    }
                    if (c == 'L') {
                        ++count;
                        end = this.desc.indexOf(59, current + 2);
                        if (end < 0) {
                            return -1;
                        }
                        current = end + 1;
                        continue;
                    }
                    return -1;
                }
                return -1;
            }
            return count;
        }
        return -1;
    }

    public int getParameterSize() {
        if (this.kind == Kind.METHOD) {
            int size = 0;
            int current = 1;
            int max = this.desc.indexOf(41);
            while (current < max) {
                int end;
                char c = this.desc.charAt(current);
                if (Descriptor.isPrimitive(c)) {
                    size += c == 'J' || c == 'D' ? 2 : 1;
                    ++current;
                    continue;
                }
                if (c == 'L') {
                    ++size;
                    end = this.desc.indexOf(59, current + 2);
                    if (end < 0) {
                        return -1;
                    }
                    current = end + 1;
                    continue;
                }
                if (c == '[') {
                    while ((c = this.desc.charAt(++current)) == '[') {
                    }
                    if (Descriptor.isPrimitive(c)) {
                        ++current;
                        ++size;
                        continue;
                    }
                    if (c == 'L') {
                        ++size;
                        end = this.desc.indexOf(59, current + 2);
                        if (end < 0) {
                            return -1;
                        }
                        current = end + 1;
                        continue;
                    }
                    return -1;
                }
                return -1;
            }
            return size;
        }
        return -1;
    }

    @Nonnull
    public Descriptor getReturnDesc() {
        if (this.kind == Kind.METHOD) {
            return Descriptor.from(this.desc.substring(this.desc.indexOf(41) + 1));
        }
        return this;
    }

    public boolean isWide() {
        if (this.kind == Kind.PRIMITIVE) {
            char c = this.desc.charAt(0);
            return c == 'J' || c == 'D';
        }
        return false;
    }

    @Nonnull
    public String getDescriptor() {
        return this.desc;
    }

    @Nonnull
    public Kind getKind() {
        return this.kind;
    }

    public int getArrayLevel() {
        return this.arrayLevel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Descriptor that = (Descriptor)o;
        if (this.arrayLevel != that.arrayLevel) {
            return false;
        }
        if (this.kind != that.kind) {
            return false;
        }
        return this.desc.equals(that.desc);
    }

    public int hashCode() {
        int result = this.kind.hashCode();
        result = 31 * result + this.desc.hashCode();
        result = 31 * result + this.arrayLevel;
        return result;
    }

    public String toString() {
        return "Descriptor{kind=" + String.valueOf((Object)this.kind) + ", desc='" + this.desc + "', arrayLevel=" + this.arrayLevel + "}";
    }

    @Nonnull
    public static Descriptor from(@Nullable String desc) {
        if (desc == null) {
            return new Descriptor(Kind.ILLEGAL, "");
        }
        if (desc.isEmpty()) {
            return new Descriptor(Kind.ILLEGAL, desc);
        }
        char first = desc.charAt(0);
        switch (first) {
            case 'V': {
                return VOID;
            }
            case 'Z': {
                return BOOLEAN;
            }
            case 'B': {
                return BYTE;
            }
            case 'C': {
                return CHAR;
            }
            case 'S': {
                return SHORT;
            }
            case 'I': {
                return INT;
            }
            case 'F': {
                return FLOAT;
            }
            case 'D': {
                return DOUBLE;
            }
            case 'J': {
                return LONG;
            }
        }
        if (first == '[') {
            int i;
            int max = desc.length();
            for (i = 1; i < max && desc.charAt(i) == '['; ++i) {
            }
            Descriptor d = Descriptor.from(desc.substring(i));
            if (d.kind == Kind.ILLEGAL) {
                return new Descriptor(Kind.ILLEGAL, desc);
            }
            return new Descriptor(Kind.ARRAY, desc, i);
        }
        if (first == '(') {
            int end = desc.indexOf(41);
            if (end < 0 || end == desc.length() - 1) {
                return new Descriptor(Kind.ILLEGAL, desc);
            }
            Descriptor d = new Descriptor(Kind.METHOD, desc);
            Descriptor returnDesc = d.getReturnDesc();
            if (returnDesc.kind == Kind.ILLEGAL) {
                return new Descriptor(Kind.ILLEGAL, desc);
            }
            if (d.getParameterCount() < 0) {
                return new Descriptor(Kind.ILLEGAL, desc);
            }
            return d;
        }
        if (first == 'L') {
            int end = desc.indexOf(59);
            if (end < 0 || end == 1) {
                return new Descriptor(Kind.ILLEGAL, desc);
            }
            return new Descriptor(Kind.OBJECT, desc);
        }
        return new Descriptor(Kind.ILLEGAL, desc);
    }

    @Nonnull
    public static Descriptor from(char desc) {
        switch (desc) {
            case 'V': {
                return VOID;
            }
            case 'Z': {
                return BOOLEAN;
            }
            case 'B': {
                return BYTE;
            }
            case 'C': {
                return CHAR;
            }
            case 'S': {
                return SHORT;
            }
            case 'I': {
                return INT;
            }
            case 'F': {
                return FLOAT;
            }
            case 'D': {
                return DOUBLE;
            }
            case 'J': {
                return LONG;
            }
        }
        return new Descriptor(Kind.ILLEGAL, String.valueOf(desc));
    }

    @Nonnull
    public static Descriptor from(@Nonnull Class<?> clazz) {
        String descriptor = clazz.toGenericString().replace('.', '/');
        if (clazz.isArray()) {
            return Objects.requireNonNull(Descriptor.from(descriptor), "Failed to parse array descriptor from class reference");
        }
        if (clazz.isPrimitive()) {
            switch (descriptor) {
                case "void": {
                    return VOID;
                }
                case "boolean": {
                    return BOOLEAN;
                }
                case "byte": {
                    return BYTE;
                }
                case "char": {
                    return CHAR;
                }
                case "short": {
                    return SHORT;
                }
                case "int": {
                    return INT;
                }
                case "float": {
                    return FLOAT;
                }
                case "double": {
                    return DOUBLE;
                }
                case "long": {
                    return LONG;
                }
            }
            throw new IllegalArgumentException("Unknown primitive type: " + descriptor);
        }
        return Objects.requireNonNull(Descriptor.from("L" + descriptor + ";"), "Failed to parse object descriptor from class reference");
    }

    public static boolean isPrimitive(@Nullable String desc) {
        if (desc == null || desc.length() != 1) {
            return false;
        }
        return Descriptor.isPrimitive(desc.charAt(0));
    }

    public static boolean isPrimitive(char desc) {
        switch (desc) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                return true;
            }
        }
        return false;
    }

    public static enum Kind {
        PRIMITIVE,
        OBJECT,
        ARRAY,
        METHOD,
        ILLEGAL;

    }
}

