/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.classfile;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.coley.cafedude.classfile.ClassMember;
import software.coley.cafedude.classfile.Modifiers;
import software.coley.cafedude.classfile.attribute.Attribute;
import software.coley.cafedude.classfile.attribute.CodeAttribute;
import software.coley.cafedude.classfile.constant.CpEntry;
import software.coley.cafedude.classfile.constant.CpUtf8;
import software.coley.cafedude.io.AttributeContext;

public class Method
extends ClassMember {
    private static final Logger logger = LoggerFactory.getLogger(Method.class);

    public Method(@Nonnull List<Attribute> attributes, int access, @Nonnull CpUtf8 name, @Nonnull CpUtf8 type) {
        super(attributes, access, name, type);
    }

    @Override
    @Nonnull
    public AttributeContext getHolderType() {
        return AttributeContext.METHOD;
    }

    @Override
    @Nonnull
    public Set<CpEntry> cpAccesses() {
        Set<CpEntry> set = super.cpAccesses();
        for (Attribute attribute : this.getAttributes()) {
            int access;
            if (attribute instanceof CodeAttribute && (Modifiers.has(access = this.getAccess(), 256) || Modifiers.has(access, 1024))) {
                logger.warn("Code attribute found on native or abstract method: {}", (Object)this);
                continue;
            }
            set.addAll(attribute.cpAccesses());
        }
        return set;
    }

    public String toString() {
        return this.getName().getText() + this.getType().getText();
    }
}

