/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.classfile.annotation;

import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import software.coley.cafedude.classfile.annotation.TargetInfoType;
import software.coley.cafedude.classfile.behavior.CpAccessor;
import software.coley.cafedude.classfile.constant.CpEntry;

public abstract class TargetInfo
implements CpAccessor {
    private final TargetInfoType targetTypeKind;
    private final int targetType;

    protected TargetInfo(@Nonnull TargetInfoType targetTypeKind, int targetType) {
        this.targetTypeKind = targetTypeKind;
        this.targetType = targetType;
    }

    @Nonnull
    public TargetInfoType getTargetTypeKind() {
        return this.targetTypeKind;
    }

    public int getTargetType() {
        return this.targetType;
    }

    @Override
    @Nonnull
    public Set<CpEntry> cpAccesses() {
        return Collections.emptySet();
    }

    public abstract int computeLength();

    public static class TypeArgumentTargetInfo
    extends TargetInfo {
        private final int offset;
        private final int typeArgumentIndex;

        public TypeArgumentTargetInfo(int targetType, int offset, int typeArgumentIndex) {
            super(TargetInfoType.TYPE_ARGUMENT_TARGET, targetType);
            this.offset = offset;
            this.typeArgumentIndex = typeArgumentIndex;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getTypeArgumentIndex() {
            return this.typeArgumentIndex;
        }

        @Override
        public int computeLength() {
            return 3;
        }
    }

    public static class OffsetTargetInfo
    extends TargetInfo {
        private final int offset;

        public OffsetTargetInfo(int targetType, int offset) {
            super(TargetInfoType.OFFSET_TARGET, targetType);
            this.offset = offset;
        }

        public int getOffset() {
            return this.offset;
        }

        @Override
        public int computeLength() {
            return 2;
        }
    }

    public static class CatchTargetInfo
    extends TargetInfo {
        private final int exceptionTableIndex;

        public CatchTargetInfo(int targetType, int exceptionTableIndex) {
            super(TargetInfoType.CATCH_TARGET, targetType);
            this.exceptionTableIndex = exceptionTableIndex;
        }

        public int getExceptionTableIndex() {
            return this.exceptionTableIndex;
        }

        @Override
        public int computeLength() {
            return 2;
        }
    }

    public static class LocalVarTargetInfo
    extends TargetInfo {
        private final List<Variable> variableTable;

        public LocalVarTargetInfo(int targetType, List<Variable> variableTable) {
            super(TargetInfoType.LOCALVAR_TARGET, targetType);
            this.variableTable = variableTable;
        }

        public List<Variable> getVariableTable() {
            return this.variableTable;
        }

        @Override
        public int computeLength() {
            return 2 + 6 * this.variableTable.size();
        }

        public static class Variable {
            private final int startPc;
            private final int length;
            private final int index;

            public Variable(int startPc, int length, int index) {
                this.startPc = startPc;
                this.length = length;
                this.index = index;
            }

            public int getStartPc() {
                return this.startPc;
            }

            public int getLength() {
                return this.length;
            }

            public int getIndex() {
                return this.index;
            }
        }
    }

    public static class ThrowsTargetInfo
    extends TargetInfo {
        private final int throwsTypeIndex;

        public ThrowsTargetInfo(int targetType, int throwsTypeIndex) {
            super(TargetInfoType.THROWS_TARGET, targetType);
            this.throwsTypeIndex = throwsTypeIndex;
        }

        public int getThrowsTypeIndex() {
            return this.throwsTypeIndex;
        }

        @Override
        public int computeLength() {
            return 2;
        }
    }

    public static class FormalParameterTargetInfo
    extends TargetInfo {
        private final int formalParameterIndex;

        public FormalParameterTargetInfo(int targetType, int formalParameterIndex) {
            super(TargetInfoType.FORMAL_PARAMETER_TARGET, targetType);
            this.formalParameterIndex = formalParameterIndex;
        }

        public int getFormalParameterIndex() {
            return this.formalParameterIndex;
        }

        @Override
        public int computeLength() {
            return 1;
        }
    }

    public static class EmptyTargetInfo
    extends TargetInfo {
        public EmptyTargetInfo(int targetType) {
            super(TargetInfoType.EMPTY_TARGET, targetType);
        }

        @Override
        public int computeLength() {
            return 0;
        }
    }

    public static class TypeParameterBoundTargetInfo
    extends TargetInfo {
        private final int typeParameterIndex;
        private final int boundIndex;

        public TypeParameterBoundTargetInfo(int targetType, int typeParameterIndex, int boundIndex) {
            super(TargetInfoType.TYPE_PARAMETER_BOUND_TARGET, targetType);
            this.typeParameterIndex = typeParameterIndex;
            this.boundIndex = boundIndex;
        }

        public int getTypeParameterIndex() {
            return this.typeParameterIndex;
        }

        public int getBoundIndex() {
            return this.boundIndex;
        }

        @Override
        public int computeLength() {
            return 2;
        }
    }

    public static class SuperTypeTargetInfo
    extends TargetInfo {
        public static final int EXTENDS = 65535;
        private final int superTypeIndex;

        public SuperTypeTargetInfo(int targetType, int superTypeIndex) {
            super(TargetInfoType.SUPERTYPE_TARGET, targetType);
            this.superTypeIndex = superTypeIndex;
        }

        public boolean isExtends() {
            return this.superTypeIndex == 65535;
        }

        public int getSuperTypeIndex() {
            return this.superTypeIndex;
        }

        @Override
        public int computeLength() {
            return 2;
        }
    }

    public static class TypeParameterTargetInfo
    extends TargetInfo {
        private final int typeParameterIndex;

        public TypeParameterTargetInfo(int targetType, int typeParameterIndex) {
            super(TargetInfoType.TYPE_PARAMETER_TARGET, targetType);
            this.typeParameterIndex = typeParameterIndex;
        }

        public int getTypeParameterIndex() {
            return this.typeParameterIndex;
        }

        @Override
        public int computeLength() {
            return 1;
        }
    }
}

