/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.classfile.annotation;

import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.Set;
import software.coley.cafedude.classfile.annotation.ElementValue;
import software.coley.cafedude.classfile.constant.CpEntry;
import software.coley.cafedude.classfile.constant.CpUtf8;

public class Utf8ElementValue
extends ElementValue {
    private CpUtf8 value;

    public Utf8ElementValue(char tag, @Nonnull CpUtf8 value) {
        super(tag);
        if (tag != 's') {
            throw new IllegalArgumentException("UTF8 element value must have 's' tag");
        }
        this.value = value;
    }

    @Nonnull
    public CpUtf8 getValue() {
        return this.value;
    }

    public void setValue(@Nonnull CpUtf8 value) {
        this.value = value;
    }

    @Override
    public char getTag() {
        return super.getTag();
    }

    @Override
    @Nonnull
    public Set<CpEntry> cpAccesses() {
        return Collections.singleton(this.value);
    }

    @Override
    public int computeLength() {
        return 3;
    }
}

