/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.classfile.attribute;

import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.EnumSet;
import software.coley.cafedude.classfile.attribute.AttributeConstants;
import software.coley.cafedude.io.AttributeContext;

public class AttributeContexts
implements AttributeConstants {
    @Nonnull
    public static Collection<AttributeContext> getAllowedContexts(@Nonnull String attributeName) {
        switch (attributeName) {
            case "BootstrapMethods": 
            case "CompilationID": 
            case "EnclosingMethod": 
            case "InnerClasses": 
            case "Module": 
            case "ModuleMainClass": 
            case "ModulePackages": 
            case "ModuleResolution": 
            case "NestHost": 
            case "NestMembers": 
            case "PermittedSubclasses": 
            case "Record": 
            case "SourceDebugExtension": 
            case "SourceFile": 
            case "SourceID": {
                return EnumSet.of(AttributeContext.CLASS);
            }
            case "ConstantValue": {
                return EnumSet.of(AttributeContext.FIELD);
            }
            case "AnnotationDefault": 
            case "Code": 
            case "Exceptions": 
            case "MethodParameters": 
            case "RuntimeInvisibleParameterAnnotations": 
            case "RuntimeVisibleParameterAnnotations": {
                return EnumSet.of(AttributeContext.METHOD);
            }
            case "Deprecated": 
            case "Synthetic": {
                return EnumSet.of(AttributeContext.CLASS, AttributeContext.FIELD, AttributeContext.METHOD);
            }
            case "LineNumberTable": 
            case "LocalVariableTable": 
            case "LocalVariableTypeTable": 
            case "StackMapTable": 
            case "CharacterRangeTable": {
                return EnumSet.of(AttributeContext.ATTRIBUTE);
            }
            case "RuntimeVisibleAnnotations": 
            case "RuntimeVisibleTypeAnnotations": 
            case "RuntimeInvisibleAnnotations": 
            case "RuntimeInvisibleTypeAnnotations": 
            case "Signature": {
                return EnumSet.allOf(AttributeContext.class);
            }
        }
        return EnumSet.allOf(AttributeContext.class);
    }
}

