/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.classfile.attribute;

import jakarta.annotation.Nonnull;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import software.coley.cafedude.classfile.attribute.Attribute;
import software.coley.cafedude.classfile.behavior.CpAccessor;
import software.coley.cafedude.classfile.constant.CpEntry;
import software.coley.cafedude.classfile.constant.CpMethodHandle;
import software.coley.cafedude.classfile.constant.CpUtf8;

public class BootstrapMethodsAttribute
extends Attribute {
    private List<BootstrapMethod> bootstrapMethods;

    public BootstrapMethodsAttribute(@Nonnull CpUtf8 name, @Nonnull List<BootstrapMethod> bootstrapMethods) {
        super(name);
        this.bootstrapMethods = bootstrapMethods;
    }

    @Override
    @Nonnull
    public Set<CpEntry> cpAccesses() {
        Set<CpEntry> set = super.cpAccesses();
        for (BootstrapMethod bsm : this.bootstrapMethods) {
            set.addAll(bsm.cpAccesses());
        }
        return set;
    }

    @Override
    public int computeInternalLength() {
        return 2 + this.bootstrapMethods.stream().mapToInt(BootstrapMethod::computeLength).sum();
    }

    @Nonnull
    public List<BootstrapMethod> getBootstrapMethods() {
        return this.bootstrapMethods;
    }

    public void setBootstrapMethods(@Nonnull List<BootstrapMethod> bootstrapMethods) {
        this.bootstrapMethods = bootstrapMethods;
    }

    public static class BootstrapMethod
    implements CpAccessor {
        private CpMethodHandle bsmMethodRef;
        private List<CpEntry> args;

        public BootstrapMethod(@Nonnull CpMethodHandle bsmMethodRef, @Nonnull List<CpEntry> args) {
            this.bsmMethodRef = bsmMethodRef;
            this.args = args;
        }

        @Override
        @Nonnull
        public Set<CpEntry> cpAccesses() {
            HashSet<CpEntry> set = new HashSet<CpEntry>();
            set.add(this.getBsmMethodRef());
            set.addAll(this.getArgs());
            return set;
        }

        @Nonnull
        public CpMethodHandle getBsmMethodRef() {
            return this.bsmMethodRef;
        }

        public void setBsmMethodRef(@Nonnull CpMethodHandle bsmMethodRef) {
            this.bsmMethodRef = bsmMethodRef;
        }

        @Nonnull
        public List<CpEntry> getArgs() {
            return this.args;
        }

        public void setArgs(@Nonnull List<CpEntry> args) {
            this.args = args;
        }

        public int computeLength() {
            return 4 + 2 * this.args.size();
        }
    }
}

