/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.classfile.attribute;

import jakarta.annotation.Nonnull;
import java.util.List;
import software.coley.cafedude.classfile.attribute.Attribute;
import software.coley.cafedude.classfile.constant.CpUtf8;

public class CharacterRangeTableAttribute
extends Attribute {
    private List<CharacterRangeInfo> characterRangeTable;

    public CharacterRangeTableAttribute(@Nonnull CpUtf8 name, @Nonnull List<CharacterRangeInfo> characterRangeTable) {
        super(name);
        this.characterRangeTable = characterRangeTable;
    }

    @Nonnull
    public List<CharacterRangeInfo> getCharacterRangeTable() {
        return this.characterRangeTable;
    }

    public void setCharacterRangeTable(@Nonnull List<CharacterRangeInfo> characterRangeTable) {
        this.characterRangeTable = characterRangeTable;
    }

    @Override
    public int computeInternalLength() {
        return 2 * (14 * this.characterRangeTable.size());
    }

    public static class CharacterRangeInfo {
        public static final int FLAG_STATEMENT = 1;
        public static final int FLAG_BLOCK = 2;
        public static final int FLAG_ASSIGNMENT = 4;
        public static final int FLAG_FLOW_CONTROLLER = 8;
        public static final int FLAG_FLOW_TARGET = 16;
        public static final int FLAG_INVOKE = 32;
        public static final int FLAG_CREATE = 64;
        public static final int FLAG_BRANCH_TRUE = 128;
        public static final int FLAG_BRANCH_FALSE = 256;
        private int startPc;
        private int endPc;
        private int characterRangeStart;
        private int characterRangeEnd;
        private int flags;

        public CharacterRangeInfo(int startPc, int endPc, int characterRangeStart, int characterRangeEnd, int flags) {
            this.startPc = startPc;
            this.endPc = endPc;
            this.characterRangeStart = characterRangeStart;
            this.characterRangeEnd = characterRangeEnd;
            this.flags = flags;
        }

        public int getStartPc() {
            return this.startPc;
        }

        public void setStartPc(int startPc) {
            this.startPc = startPc;
        }

        public int getEndPc() {
            return this.endPc;
        }

        public void setEndPc(int endPc) {
            this.endPc = endPc;
        }

        public int getCharacterRangeStart() {
            return this.characterRangeStart;
        }

        public void setCharacterRangeStart(int characterRangeStart) {
            this.characterRangeStart = characterRangeStart;
        }

        public void setCharacterRangeStart(int line, int column) {
            this.setCharacterRangeStart(line << 10 + column);
        }

        public int getCharacterRangeEnd() {
            return this.characterRangeEnd;
        }

        public void setCharacterRangeEnd(int characterRangeEnd) {
            this.characterRangeEnd = characterRangeEnd;
        }

        public void setCharacterRangeEnd(int line, int column) {
            this.setCharacterRangeStart(line << 10 + column);
        }

        public int getFlags() {
            return this.flags;
        }

        public void setFlags(int flags) {
            this.flags = flags;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CharacterRangeInfo)) {
                return false;
            }
            CharacterRangeInfo that = (CharacterRangeInfo)o;
            if (this.startPc != that.startPc) {
                return false;
            }
            if (this.endPc != that.endPc) {
                return false;
            }
            if (this.characterRangeStart != that.characterRangeStart) {
                return false;
            }
            if (this.characterRangeEnd != that.characterRangeEnd) {
                return false;
            }
            return this.flags == that.flags;
        }

        public int hashCode() {
            int result = this.startPc;
            result = 31 * result + this.endPc;
            result = 31 * result + this.characterRangeStart;
            result = 31 * result + this.characterRangeEnd;
            result = 31 * result + this.flags;
            return result;
        }
    }
}

