/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.classfile.attribute;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import software.coley.cafedude.classfile.attribute.Attribute;
import software.coley.cafedude.classfile.behavior.AttributeHolder;
import software.coley.cafedude.classfile.behavior.CpAccessor;
import software.coley.cafedude.classfile.constant.CpClass;
import software.coley.cafedude.classfile.constant.CpEntry;
import software.coley.cafedude.classfile.constant.CpUtf8;
import software.coley.cafedude.classfile.instruction.Instruction;
import software.coley.cafedude.io.AttributeContext;

public class CodeAttribute
extends Attribute
implements AttributeHolder {
    private List<ExceptionTableEntry> exceptionTable;
    private List<Attribute> attributes;
    private List<Instruction> instructions;
    private int maxStack;
    private int maxLocals;

    public CodeAttribute(@Nonnull CpUtf8 name, int maxStack, int maxLocals, @Nonnull List<Instruction> instructions, @Nonnull List<ExceptionTableEntry> exceptionTable, @Nonnull List<Attribute> attributes) {
        super(name);
        this.maxStack = maxStack;
        this.maxLocals = maxLocals;
        this.instructions = instructions;
        this.exceptionTable = exceptionTable;
        this.attributes = attributes;
    }

    public int indexOf(@Nonnull Instruction instruction) {
        for (int i = 0; i < this.instructions.size(); ++i) {
            if (this.instructions.get(i) != instruction) continue;
            return i;
        }
        return -1;
    }

    public int computeOffsetOf(@Nonnull Instruction instruction) {
        int index = this.indexOf(instruction);
        if (index == 0) {
            return 0;
        }
        if (index < 0) {
            return -1;
        }
        int offset = 0;
        for (int i = 0; i < index; ++i) {
            offset += this.instructions.get(i).computeSize();
        }
        return offset;
    }

    @Nonnull
    public List<Instruction> getInstructions() {
        return this.instructions;
    }

    public void setInstructions(@Nonnull List<Instruction> instructions) {
        this.instructions = instructions;
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public void setMaxStack(int maxStack) {
        this.maxStack = maxStack;
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public void setMaxLocals(int maxLocals) {
        this.maxLocals = maxLocals;
    }

    @Nonnull
    public List<ExceptionTableEntry> getExceptionTable() {
        return this.exceptionTable;
    }

    public void setExceptionTable(@Nonnull List<ExceptionTableEntry> exceptionTable) {
        this.exceptionTable = exceptionTable;
    }

    @Override
    @Nonnull
    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    @Override
    @Nullable
    public <T extends Attribute> T getAttribute(@Nonnull Class<T> type) {
        for (Attribute attribute : this.attributes) {
            if (!type.isInstance(attribute)) continue;
            return (T)((Attribute)type.cast(attribute));
        }
        return null;
    }

    @Override
    public void setAttributes(@Nonnull List<Attribute> attributes) {
        this.attributes = attributes;
    }

    @Override
    @Nonnull
    public AttributeContext getHolderType() {
        return AttributeContext.ATTRIBUTE;
    }

    @Override
    @Nonnull
    public Set<CpEntry> cpAccesses() {
        Set<CpEntry> set = super.cpAccesses();
        for (Attribute attribute : this.getAttributes()) {
            set.addAll(attribute.cpAccesses());
        }
        for (ExceptionTableEntry ex : this.getExceptionTable()) {
            set.addAll(ex.cpAccesses());
        }
        for (Instruction instruction : this.instructions) {
            if (!(instruction instanceof CpAccessor)) continue;
            set.addAll(((CpAccessor)((Object)instruction)).cpAccesses());
        }
        return set;
    }

    @Override
    public int computeInternalLength() {
        int len = 4;
        len += 4;
        int insnSize = 0;
        for (Instruction instruction : this.instructions) {
            insnSize += instruction.computeSize();
        }
        len += insnSize;
        len += 2;
        len += 8 * this.exceptionTable.size();
        len += 2;
        for (Attribute attribute : this.attributes) {
            len += attribute.computeCompleteLength();
        }
        return len;
    }

    public static class ExceptionTableEntry
    implements CpAccessor {
        private int startPc;
        private int endPc;
        private int handlerPc;
        private CpClass catchType;

        public ExceptionTableEntry(int startPc, int endPc, int handlerPc, @Nullable CpClass catchType) {
            this.startPc = startPc;
            this.endPc = endPc;
            this.handlerPc = handlerPc;
            this.catchType = catchType;
        }

        public int getStartPc() {
            return this.startPc;
        }

        public void setStartPc(int startPc) {
            this.startPc = startPc;
        }

        public int getEndPc() {
            return this.endPc;
        }

        public void setEndPc(int endPc) {
            this.endPc = endPc;
        }

        public int getHandlerPc() {
            return this.handlerPc;
        }

        public void setHandlerPc(int handlerPc) {
            this.handlerPc = handlerPc;
        }

        @Nullable
        public CpClass getCatchType() {
            return this.catchType;
        }

        public void setCatchType(@Nullable CpClass catchType) {
            this.catchType = catchType;
        }

        @Override
        @Nonnull
        public Set<CpEntry> cpAccesses() {
            if (this.catchType != null) {
                return Collections.singleton(this.catchType);
            }
            return Collections.emptySet();
        }
    }
}

