/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.classfile.attribute;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Set;
import software.coley.cafedude.classfile.attribute.Attribute;
import software.coley.cafedude.classfile.constant.CpClass;
import software.coley.cafedude.classfile.constant.CpEntry;
import software.coley.cafedude.classfile.constant.CpUtf8;

public class ExceptionsAttribute
extends Attribute {
    private List<CpClass> exceptionTable;

    public ExceptionsAttribute(@Nonnull CpUtf8 name, @Nonnull List<CpClass> exceptionTable) {
        super(name);
        this.exceptionTable = exceptionTable;
    }

    @Nonnull
    public List<CpClass> getExceptionTable() {
        return this.exceptionTable;
    }

    public void setExceptionTable(@Nonnull List<CpClass> exceptionTable) {
        this.exceptionTable = exceptionTable;
    }

    @Override
    @Nonnull
    public Set<CpEntry> cpAccesses() {
        Set<CpEntry> set = super.cpAccesses();
        set.addAll(this.getExceptionTable());
        return set;
    }

    @Override
    public int computeInternalLength() {
        return 2 + this.exceptionTable.size() * 2;
    }
}

