/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.classfile.attribute;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import software.coley.cafedude.classfile.attribute.Attribute;
import software.coley.cafedude.classfile.behavior.CpAccessor;
import software.coley.cafedude.classfile.constant.CpClass;
import software.coley.cafedude.classfile.constant.CpEntry;
import software.coley.cafedude.classfile.constant.CpModule;
import software.coley.cafedude.classfile.constant.CpPackage;
import software.coley.cafedude.classfile.constant.CpUtf8;

public class ModuleAttribute
extends Attribute {
    private CpModule module;
    private int flags;
    private CpUtf8 version;
    private List<Requires> requires;
    private List<Exports> exports;
    private List<Opens> opens;
    private List<CpClass> uses;
    private List<Provides> provides;

    public ModuleAttribute(@Nonnull CpUtf8 name, @Nonnull CpModule module, int flags, @Nullable CpUtf8 version, @Nonnull List<Requires> requires, @Nonnull List<Exports> exports, @Nonnull List<Opens> opens, @Nonnull List<CpClass> uses, @Nonnull List<Provides> provides) {
        super(name);
        this.module = module;
        this.flags = flags;
        this.version = version;
        this.requires = requires;
        this.exports = exports;
        this.opens = opens;
        this.uses = uses;
        this.provides = provides;
    }

    @Nonnull
    public CpModule getModule() {
        return this.module;
    }

    public void setModule(@Nonnull CpModule module) {
        this.module = module;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    @Nullable
    public CpUtf8 getVersion() {
        return this.version;
    }

    public void setVersion(@Nonnull CpUtf8 version) {
        this.version = version;
    }

    @Nonnull
    public List<Requires> getRequires() {
        return this.requires;
    }

    public void setRequires(@Nonnull List<Requires> requires) {
        this.requires = requires;
    }

    @Nonnull
    public List<Exports> getExports() {
        return this.exports;
    }

    public void setExports(@Nonnull List<Exports> exports) {
        this.exports = exports;
    }

    @Nonnull
    public List<Opens> getOpens() {
        return this.opens;
    }

    public void setOpens(@Nonnull List<Opens> opens) {
        this.opens = opens;
    }

    @Nonnull
    public List<CpClass> getUses() {
        return this.uses;
    }

    public void setUses(@Nonnull List<CpClass> uses) {
        this.uses = uses;
    }

    @Nonnull
    public List<Provides> getProvides() {
        return this.provides;
    }

    public void setProvides(@Nonnull List<Provides> provides) {
        this.provides = provides;
    }

    @Override
    @Nonnull
    public Set<CpEntry> cpAccesses() {
        Set<CpEntry> set = super.cpAccesses();
        set.add(this.getModule());
        set.add(this.getVersion());
        set.addAll(this.getUses());
        for (Requires requires : this.getRequires()) {
            set.addAll(requires.cpAccesses());
        }
        for (Exports exports : this.getExports()) {
            set.addAll(exports.cpAccesses());
        }
        for (Opens opens : this.getOpens()) {
            set.addAll(opens.cpAccesses());
        }
        for (Provides provides : this.getProvides()) {
            set.addAll(provides.cpAccesses());
        }
        return set;
    }

    @Override
    public int computeInternalLength() {
        int len = 6;
        len += 2 + this.requires.size() * 6;
        len += 2 + this.exports.stream().mapToInt(Exports::length).sum();
        len += 2 + this.opens.stream().mapToInt(Opens::length).sum();
        len += 2 + this.uses.size() * 2;
        return len += 2 + this.provides.stream().mapToInt(Provides::length).sum();
    }

    public static class Requires
    implements CpAccessor {
        private CpModule module;
        private int flags;
        private CpUtf8 version;

        public Requires(@Nonnull CpModule module, int flags, @Nullable CpUtf8 version) {
            this.module = module;
            this.flags = flags;
            this.version = version;
        }

        @Nonnull
        public CpModule getModule() {
            return this.module;
        }

        public void setModule(@Nonnull CpModule module) {
            this.module = module;
        }

        public int getFlags() {
            return this.flags;
        }

        public void setFlags(int flags) {
            this.flags = flags;
        }

        @Nullable
        public CpUtf8 getVersion() {
            return this.version;
        }

        public void setVersion(@Nullable CpUtf8 version) {
            this.version = version;
        }

        @Override
        @Nonnull
        public Set<CpEntry> cpAccesses() {
            HashSet<CpEntry> set = new HashSet<CpEntry>();
            set.add(this.getVersion());
            set.add(this.getModule());
            return set;
        }
    }

    public static class Exports
    implements CpAccessor {
        private CpPackage packageEntry;
        private int flags;
        private List<CpModule> to;

        public Exports(@Nonnull CpPackage packageEntry, int flags, @Nonnull List<CpModule> to) {
            this.packageEntry = packageEntry;
            this.flags = flags;
            this.to = to;
        }

        @Nonnull
        public CpPackage getPackageEntry() {
            return this.packageEntry;
        }

        public void setPackageEntry(@Nonnull CpPackage packageEntry) {
            this.packageEntry = packageEntry;
        }

        public int getFlags() {
            return this.flags;
        }

        public void setFlags(int flags) {
            this.flags = flags;
        }

        @Nonnull
        public List<CpModule> getTo() {
            return this.to;
        }

        public void setTo(@Nonnull List<CpModule> toIndex) {
            this.to = toIndex;
        }

        public int length() {
            return 6 + 2 * this.to.size();
        }

        @Override
        @Nonnull
        public Set<CpEntry> cpAccesses() {
            HashSet<CpEntry> set = new HashSet<CpEntry>();
            set.add(this.getPackageEntry());
            set.addAll(this.getTo());
            return set;
        }
    }

    public static class Opens
    implements CpAccessor {
        private CpPackage packageEntry;
        private int flags;
        private List<CpModule> to;

        public Opens(@Nonnull CpPackage packageEntry, int flags, @Nonnull List<CpModule> to) {
            this.packageEntry = packageEntry;
            this.flags = flags;
            this.to = to;
        }

        @Nonnull
        public CpPackage getPackageEntry() {
            return this.packageEntry;
        }

        public void setPackageEntry(@Nonnull CpPackage packageEntry) {
            this.packageEntry = packageEntry;
        }

        public int getFlags() {
            return this.flags;
        }

        public void setFlags(int flags) {
            this.flags = flags;
        }

        @Nonnull
        public List<CpModule> getTo() {
            return this.to;
        }

        public void setTo(@Nonnull List<CpModule> toIndex) {
            this.to = toIndex;
        }

        public int length() {
            return 6 + 2 * this.to.size();
        }

        @Override
        @Nonnull
        public Set<CpEntry> cpAccesses() {
            HashSet<CpEntry> set = new HashSet<CpEntry>();
            set.add(this.getPackageEntry());
            set.addAll(this.getTo());
            return set;
        }
    }

    public static class Provides
    implements CpAccessor {
        private CpClass module;
        private List<CpClass> with;

        public Provides(@Nonnull CpClass module, @Nonnull List<CpClass> with) {
            this.module = module;
            this.with = with;
        }

        @Nonnull
        public CpClass getModule() {
            return this.module;
        }

        public void setModule(@Nonnull CpClass module) {
            this.module = module;
        }

        @Nonnull
        public List<CpClass> getWith() {
            return this.with;
        }

        public void setWith(@Nonnull List<CpClass> with) {
            this.with = with;
        }

        public int length() {
            return 4 + 2 * this.with.size();
        }

        @Override
        @Nonnull
        public Set<CpEntry> cpAccesses() {
            HashSet<CpEntry> set = new HashSet<CpEntry>();
            set.add(this.getModule());
            set.addAll(this.getWith());
            return set;
        }
    }
}

