/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.classfile.attribute;

import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Set;
import software.coley.cafedude.classfile.attribute.Attribute;
import software.coley.cafedude.classfile.constant.CpEntry;
import software.coley.cafedude.classfile.constant.CpUtf8;

public class ModuleHashesAttribute
extends Attribute {
    private Map<CpUtf8, byte[]> moduleHashes;
    private CpUtf8 algorithmName;

    public ModuleHashesAttribute(@Nonnull CpUtf8 name, @Nonnull CpUtf8 algorithmName, @Nonnull Map<CpUtf8, byte[]> moduleHashes) {
        super(name);
        this.algorithmName = algorithmName;
        this.moduleHashes = moduleHashes;
    }

    @Nonnull
    public CpUtf8 getAlgorithmName() {
        return this.algorithmName;
    }

    public void setAlgorithmName(@Nonnull CpUtf8 algorithmName) {
        this.algorithmName = algorithmName;
    }

    @Nonnull
    public Map<CpUtf8, byte[]> getModuleHashes() {
        return this.moduleHashes;
    }

    public void setModuleHashes(@Nonnull Map<CpUtf8, byte[]> moduleHashes) {
        this.moduleHashes = moduleHashes;
    }

    @Override
    @Nonnull
    public Set<CpEntry> cpAccesses() {
        Set<CpEntry> set = super.cpAccesses();
        set.add(this.getAlgorithmName());
        set.addAll(this.moduleHashes.keySet());
        return set;
    }

    @Override
    public int computeInternalLength() {
        return 4 + this.moduleHashes.values().stream().mapToInt(bytes -> 4 + ((byte[])bytes).length).sum();
    }
}

