/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.classfile.attribute;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Set;
import software.coley.cafedude.classfile.annotation.Annotation;
import software.coley.cafedude.classfile.attribute.Attribute;
import software.coley.cafedude.classfile.constant.CpEntry;
import software.coley.cafedude.classfile.constant.CpUtf8;

public class ParameterAnnotationsAttribute
extends Attribute {
    private Map<Integer, List<Annotation>> parameterAnnotations;
    private boolean visible;

    public ParameterAnnotationsAttribute(@Nonnull CpUtf8 name, @Nonnull Map<Integer, List<Annotation>> parameterAnnotations, boolean visible) {
        super(name);
        this.parameterAnnotations = parameterAnnotations;
        this.visible = visible;
    }

    @Nonnull
    public Map<Integer, List<Annotation>> getParameterAnnotations() {
        return this.parameterAnnotations;
    }

    public void setParameterAnnotations(@Nonnull Map<Integer, List<Annotation>> parameterAnnotations) {
        this.parameterAnnotations = parameterAnnotations;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    @Nonnull
    public Set<CpEntry> cpAccesses() {
        Set<CpEntry> set = super.cpAccesses();
        for (List<Annotation> list : this.getParameterAnnotations().values()) {
            for (Annotation annotation : list) {
                set.addAll(annotation.cpAccesses());
            }
        }
        return set;
    }

    @Override
    public int computeInternalLength() {
        int length = 1;
        for (List<Annotation> annotations : this.parameterAnnotations.values()) {
            length += 2 + annotations.stream().mapToInt(Annotation::computeLength).sum();
        }
        return length;
    }
}

