/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.classfile.attribute;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Set;
import software.coley.cafedude.classfile.attribute.Attribute;
import software.coley.cafedude.classfile.constant.CpClass;
import software.coley.cafedude.classfile.constant.CpEntry;
import software.coley.cafedude.classfile.constant.CpUtf8;

public class PermittedClassesAttribute
extends Attribute {
    private List<CpClass> classes;

    public PermittedClassesAttribute(@Nonnull CpUtf8 name, @Nonnull List<CpClass> classes) {
        super(name);
        this.classes = classes;
    }

    @Nonnull
    public List<CpClass> getClasses() {
        return this.classes;
    }

    public void setClasses(@Nonnull List<CpClass> classes) {
        this.classes = classes;
    }

    @Override
    @Nonnull
    public Set<CpEntry> cpAccesses() {
        Set<CpEntry> set = super.cpAccesses();
        set.addAll(this.getClasses());
        return set;
    }

    @Override
    public int computeInternalLength() {
        return 2 + 2 * this.classes.size();
    }
}

