/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.classfile.constant;

import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import software.coley.cafedude.classfile.constant.CpEntry;
import software.coley.cafedude.classfile.constant.CpNameType;
import software.coley.cafedude.classfile.constant.CrossCpReferencing;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class ConstDynamic
extends CpEntry
implements CrossCpReferencing {
    private int bsmIndex;
    private CpNameType nameType;

    public ConstDynamic(int type, int bsmIndex, @Nonnull CpNameType nameType) {
        super(type);
        this.bsmIndex = bsmIndex;
        this.nameType = nameType;
    }

    public int getBsmIndex() {
        return this.bsmIndex;
    }

    public void setBsmIndex(int bsmIndex) {
        this.bsmIndex = bsmIndex;
    }

    @Nonnull
    public CpNameType getNameType() {
        return this.nameType;
    }

    public void setNameType(@Nonnull CpNameType nameType) {
        this.nameType = nameType;
    }

    @Override
    @Nonnull
    public Collection<CpEntry> getReferences() {
        return Collections.singletonList(this.nameType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstDynamic that = (ConstDynamic)o;
        return this.bsmIndex == that.bsmIndex && this.nameType == that.nameType;
    }

    public int hashCode() {
        int result = this.bsmIndex;
        result = 31 * result + this.nameType.hashCode();
        return result;
    }

    public String toString() {
        return "dynamic-bsm=" + this.bsmIndex + ", dynamic-sig=" + this.nameType.getName().getText() + "." + this.nameType.getType().getText();
    }
}

