/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.classfile.constant;

import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import software.coley.cafedude.classfile.constant.ConstRef;
import software.coley.cafedude.classfile.constant.CpEntry;
import software.coley.cafedude.classfile.constant.CrossCpReferencing;
import software.coley.cafedude.classfile.constant.LoadableConstant;

public class CpMethodHandle
extends CpEntry
implements CrossCpReferencing,
LoadableConstant {
    public static final int REF_GET_FIELD = 1;
    public static final int REF_GET_STATIC = 2;
    public static final int REF_PUT_FIELD = 3;
    public static final int REF_PUT_STATIC = 4;
    public static final int REF_INVOKE_VIRTUAL = 5;
    public static final int REF_INVOKE_STATIC = 6;
    public static final int REF_INVOKE_SPECIAL = 7;
    public static final int REF_NEW_INVOKE_SPECIAL = 8;
    public static final int REF_INVOKE_INTERFACE = 9;
    private ConstRef reference;
    private byte kind;

    public CpMethodHandle(byte kind, @Nonnull ConstRef reference) {
        super(15);
        this.kind = kind;
        this.reference = reference;
    }

    public byte getKind() {
        return this.kind;
    }

    public void setKind(byte kind) {
        this.kind = kind;
    }

    @Nonnull
    public ConstRef getReference() {
        return this.reference;
    }

    public void setReference(@Nonnull ConstRef reference) {
        this.reference = reference;
    }

    @Override
    @Nonnull
    public Collection<CpEntry> getReferences() {
        return Collections.singletonList(this.reference);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CpMethodHandle)) {
            return false;
        }
        CpMethodHandle that = (CpMethodHandle)o;
        if (this.kind != that.kind) {
            return false;
        }
        return this.reference.equals(that.reference);
    }

    public int hashCode() {
        int result = this.reference.hashCode();
        result = 31 * result + this.kind;
        return result;
    }

    public String toString() {
        return "method-handle=" + String.valueOf(this.getReference()) + ", kind=" + this.kind;
    }
}

