/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.classfile.constant;

import jakarta.annotation.Nonnull;
import software.coley.cafedude.classfile.constant.ConstRef;
import software.coley.cafedude.classfile.constant.ConstRefInternal;
import software.coley.cafedude.classfile.constant.CpClass;
import software.coley.cafedude.classfile.constant.CpEntry;
import software.coley.cafedude.classfile.constant.CpNameType;
import software.coley.cafedude.classfile.constant.CpUtf8;
import software.coley.cafedude.classfile.constant.CrossCpReferencing;

public class Placeholders {
    private static final String EDIT_MESSAGE = "Should not manipulate placeholder CP entries";
    public static final CpUtf8 UTF8 = new CpUtf8(""){

        @Override
        public void setText(@Nonnull String text) {
            throw new IllegalStateException(Placeholders.EDIT_MESSAGE);
        }

        @Override
        public void setIndex(int index) {
            throw new IllegalStateException(Placeholders.EDIT_MESSAGE);
        }

        @Override
        public String toString() {
            return "Placeholder: CpUtf8";
        }
    };
    public static final CpClass CLASS = new CpClass(UTF8){

        @Override
        public String toString() {
            return "Placeholder: CpClass";
        }

        @Override
        public void setName(@Nonnull CpUtf8 name) {
            throw new IllegalStateException(Placeholders.EDIT_MESSAGE);
        }

        @Override
        public void setIndex(int index) {
            throw new IllegalStateException(Placeholders.EDIT_MESSAGE);
        }
    };
    public static final CpNameType NAME_TYPE = new CpNameType(UTF8, UTF8){

        @Override
        public String toString() {
            return "Placeholder: CpNameType";
        }

        @Override
        public void setIndex(int index) {
            throw new IllegalStateException(Placeholders.EDIT_MESSAGE);
        }

        @Override
        public void setName(@Nonnull CpUtf8 name) {
            throw new IllegalStateException(Placeholders.EDIT_MESSAGE);
        }

        @Override
        public void setType(@Nonnull CpUtf8 type) {
            throw new IllegalStateException(Placeholders.EDIT_MESSAGE);
        }
    };
    public static final ConstRef CONST_REF = new ConstRefInternal(CLASS, NAME_TYPE){

        @Override
        public String toString() {
            return "Placeholder: ConstRef";
        }

        @Override
        public void setClassRef(@Nonnull CpClass classRef) {
            throw new IllegalStateException(Placeholders.EDIT_MESSAGE);
        }

        @Override
        public void setNameType(@Nonnull CpNameType nameType) {
            throw new IllegalStateException(Placeholders.EDIT_MESSAGE);
        }

        @Override
        public void setIndex(int index) {
            throw new IllegalStateException(Placeholders.EDIT_MESSAGE);
        }
    };

    public static boolean isOrContainsPlaceholder(@Nonnull CpEntry entry) {
        return Placeholders.isPlaceholder(entry) || Placeholders.containsPlaceholder(entry);
    }

    public static boolean containsPlaceholder(@Nonnull CpEntry entry) {
        if (entry instanceof CrossCpReferencing) {
            CrossCpReferencing referencing = (CrossCpReferencing)((Object)entry);
            for (CpEntry referenced : referencing.getReferences()) {
                if (!Placeholders.isPlaceholder(referenced)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPlaceholder(@Nonnull CpEntry entry) {
        return entry == UTF8 || entry == CLASS || entry == NAME_TYPE || entry == CONST_REF;
    }
}

