/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.classfile.instruction;

import java.util.List;
import software.coley.cafedude.classfile.instruction.Instruction;

public class LookupSwitchInstruction
extends Instruction {
    private int padding = -1;
    private int dflt;
    private List<Integer> keys;
    private List<Integer> offsets;

    public LookupSwitchInstruction(int dflt, List<Integer> keys, List<Integer> offsets) {
        super(171);
        this.dflt = dflt;
        this.keys = keys;
        this.offsets = offsets;
    }

    public int getDefault() {
        return this.dflt;
    }

    public void setDefault(int dflt) {
        this.dflt = dflt;
    }

    public List<Integer> getKeys() {
        return this.keys;
    }

    public void setKeys(List<Integer> keys) {
        this.keys = keys;
    }

    public List<Integer> getOffsets() {
        return this.offsets;
    }

    public void setOffsets(List<Integer> offsets) {
        this.offsets = offsets;
    }

    public int getPadding() {
        return this.padding;
    }

    public void notifyStartPosition(int position) {
        this.padding = 3 - (position & 3);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LookupSwitchInstruction)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LookupSwitchInstruction that = (LookupSwitchInstruction)o;
        if (this.dflt != that.dflt) {
            return false;
        }
        if (!this.keys.equals(that.keys)) {
            return false;
        }
        return this.offsets.equals(that.offsets);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.dflt;
        result = 31 * result + this.keys.hashCode();
        result = 31 * result + this.offsets.hashCode();
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.keys.size(); ++i) {
            if (!sb.isEmpty()) {
                sb.append(", ");
            }
            sb.append(this.keys.get(i)).append("=").append(this.offsets.get(i));
        }
        sb.append(" default=").append(this.dflt);
        return super.toString() + " " + String.valueOf(sb);
    }

    @Override
    public int computeSize() {
        if (this.padding < 0) {
            throw new IllegalStateException("Padding size not computed!");
        }
        return 1 + this.padding + 4 + 4 + 4 * this.keys.size() + 4 * this.offsets.size();
    }
}

