/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.classfile.instruction;

import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.Set;
import software.coley.cafedude.classfile.behavior.CpAccessor;
import software.coley.cafedude.classfile.constant.CpClass;
import software.coley.cafedude.classfile.constant.CpEntry;
import software.coley.cafedude.classfile.instruction.Instruction;

public class MultiANewArrayInstruction
extends Instruction
implements CpAccessor {
    private CpClass descriptor;
    private int dimensions;

    public MultiANewArrayInstruction(@Nonnull CpClass descriptor, int dimensions) {
        super(197);
        this.descriptor = descriptor;
        this.dimensions = dimensions;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(int dimensions) {
        this.dimensions = dimensions;
    }

    @Nonnull
    public CpClass getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(@Nonnull CpClass descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public int computeSize() {
        return 4;
    }

    @Override
    @Nonnull
    public Set<CpEntry> cpAccesses() {
        return Collections.singleton(this.descriptor);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultiANewArrayInstruction)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MultiANewArrayInstruction that = (MultiANewArrayInstruction)o;
        if (this.dimensions != that.dimensions) {
            return false;
        }
        return this.descriptor.equals(that.descriptor);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.dimensions;
        result = 31 * result + this.descriptor.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return super.toString() + " dimensions=" + this.dimensions + ", descriptor=" + this.descriptor.getName().getText();
    }
}

