/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.classfile.instruction;

import java.util.List;
import java.util.stream.Collectors;
import software.coley.cafedude.classfile.instruction.Instruction;

public class TableSwitchInstruction
extends Instruction {
    private int padding = -1;
    private int dflt;
    private int low;
    private int high;
    private List<Integer> offsets;

    public TableSwitchInstruction(int dflt, int low, int high, List<Integer> offsets) {
        super(170);
        this.dflt = dflt;
        this.low = low;
        this.high = high;
        this.offsets = offsets;
    }

    public int getDefault() {
        return this.dflt;
    }

    public void setDefault(int dflt) {
        this.dflt = dflt;
    }

    public int getLow() {
        return this.low;
    }

    public void setLow(int low) {
        this.low = low;
    }

    public int getHigh() {
        return this.high;
    }

    public void setHigh(int high) {
        this.high = high;
    }

    public List<Integer> getOffsets() {
        return this.offsets;
    }

    public void setOffsets(List<Integer> offsets) {
        this.offsets = offsets;
    }

    public int getPadding() {
        return this.padding;
    }

    public void notifyStartPosition(int position) {
        this.padding = 3 - (position & 3);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TableSwitchInstruction)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TableSwitchInstruction that = (TableSwitchInstruction)o;
        if (this.dflt != that.dflt) {
            return false;
        }
        if (this.low != that.low) {
            return false;
        }
        if (this.high != that.high) {
            return false;
        }
        return this.offsets.equals(that.offsets);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.dflt;
        result = 31 * result + this.low;
        result = 31 * result + this.high;
        result = 31 * result + this.offsets.hashCode();
        return result;
    }

    @Override
    public String toString() {
        String offsetsStr = this.offsets.stream().map(String::valueOf).collect(Collectors.joining(", "));
        return super.toString() + " range=[" + this.low + " --> " + this.high + "] offsets=[" + offsetsStr + "] default=" + this.dflt;
    }

    @Override
    public int computeSize() {
        if (this.padding < 0) {
            throw new IllegalStateException("Padding size not computed!");
        }
        return 1 + this.padding + 4 + 4 + 4 + this.offsets.size() * 4;
    }
}

