/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.io;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.coley.cafedude.classfile.ConstPool;
import software.coley.cafedude.classfile.annotation.Annotation;
import software.coley.cafedude.classfile.annotation.AnnotationElementValue;
import software.coley.cafedude.classfile.annotation.ArrayElementValue;
import software.coley.cafedude.classfile.annotation.ClassElementValue;
import software.coley.cafedude.classfile.annotation.ElementValue;
import software.coley.cafedude.classfile.annotation.EnumElementValue;
import software.coley.cafedude.classfile.annotation.PrimitiveElementValue;
import software.coley.cafedude.classfile.annotation.TargetInfo;
import software.coley.cafedude.classfile.annotation.TargetInfoType;
import software.coley.cafedude.classfile.annotation.TypeAnnotation;
import software.coley.cafedude.classfile.annotation.TypePath;
import software.coley.cafedude.classfile.annotation.TypePathElement;
import software.coley.cafedude.classfile.annotation.TypePathKind;
import software.coley.cafedude.classfile.annotation.Utf8ElementValue;
import software.coley.cafedude.classfile.attribute.AnnotationDefaultAttribute;
import software.coley.cafedude.classfile.attribute.AnnotationsAttribute;
import software.coley.cafedude.classfile.attribute.ParameterAnnotationsAttribute;
import software.coley.cafedude.classfile.constant.CpEntry;
import software.coley.cafedude.classfile.constant.CpUtf8;
import software.coley.cafedude.io.AttributeContext;
import software.coley.cafedude.io.ClassFileReader;

public class AnnotationReader {
    private static final Logger logger = LoggerFactory.getLogger(AnnotationReader.class);
    private static final int MAX_NESTING = 50;
    private final ClassFileReader reader;
    private final ConstPool cp;
    private final DataInputStream is;
    private final AttributeContext context;
    private final CpUtf8 name;
    private final int maxCpIndex;
    private final boolean visible;

    public AnnotationReader(ClassFileReader reader, ConstPool cp, DataInputStream is, int length, CpUtf8 name, AttributeContext context, boolean visible) throws IOException {
        this.reader = reader;
        this.cp = cp;
        byte[] data = new byte[length];
        is.readFully(data);
        this.is = new DataInputStream(new ByteArrayInputStream(data));
        this.name = name;
        this.context = context;
        this.maxCpIndex = cp.size();
        this.visible = visible;
    }

    @Nullable
    public AnnotationDefaultAttribute readAnnotationDefault() {
        try {
            return new AnnotationDefaultAttribute(this.name, this.readElementValue(new AnnotationScope()));
        }
        catch (Throwable t) {
            logger.debug("Illegally formatted AnnotationDefault, dropping");
            return null;
        }
    }

    @Nullable
    public AnnotationsAttribute readAnnotations() {
        try {
            int numAnnotations = this.is.readUnsignedShort();
            if (numAnnotations == 0) {
                logger.debug("Annotations attribute has 0 items, skipping");
                return null;
            }
            HashSet<String> usedAnnotationTypes = new HashSet<String>();
            ArrayList<Annotation> annotations = new ArrayList<Annotation>(numAnnotations);
            for (int i = 0; i < numAnnotations; ++i) {
                try {
                    Annotation annotation = this.readAnnotation(new AnnotationScope());
                    if (this.reader.doDropDupeAnnotations()) {
                        String type = annotation.getType().getText();
                        if (usedAnnotationTypes.contains(type)) continue;
                        annotations.add(annotation);
                        usedAnnotationTypes.add(type);
                        continue;
                    }
                    annotations.add(annotation);
                    continue;
                }
                catch (Throwable t) {
                    logger.debug("Illegally formatted Annotation, dropping");
                }
            }
            if (annotations.isEmpty()) {
                return null;
            }
            return new AnnotationsAttribute(this.name, annotations, this.visible);
        }
        catch (Throwable t) {
            logger.debug("Illegally formatted Annotations, dropping");
            return null;
        }
    }

    @Nullable
    public ParameterAnnotationsAttribute readParameterAnnotations() {
        try {
            int numParameters = this.is.readUnsignedByte();
            if (numParameters == 0) {
                logger.debug("ParameterAnnotations attribute has 0 items, skipping");
                return null;
            }
            LinkedHashMap<Integer, List<Annotation>> parameterAnnotations = new LinkedHashMap<Integer, List<Annotation>>();
            for (int p = 0; p < numParameters; ++p) {
                int numAnnotations = this.is.readUnsignedShort();
                ArrayList<Annotation> annotations = new ArrayList<Annotation>(numAnnotations);
                for (int i = 0; i < numAnnotations; ++i) {
                    annotations.add(this.readAnnotation(new AnnotationScope()));
                }
                parameterAnnotations.put(p, annotations);
            }
            return new ParameterAnnotationsAttribute(this.name, parameterAnnotations, this.visible);
        }
        catch (Throwable t) {
            logger.debug("Illegally formatted ParameterAnnotations, dropping");
            return null;
        }
    }

    @Nullable
    public AnnotationsAttribute readTypeAnnotations() {
        try {
            int numAnnotations = this.is.readUnsignedShort();
            if (numAnnotations == 0) {
                logger.debug("TypeAnnotations attribute has 0 items, skipping");
                return null;
            }
            ArrayList<Annotation> annotations = new ArrayList<Annotation>(numAnnotations);
            for (int i = 0; i < numAnnotations; ++i) {
                annotations.add(this.readTypeAnnotation(new AnnotationScope()));
            }
            return new AnnotationsAttribute(this.name, annotations, this.visible);
        }
        catch (Throwable t) {
            logger.debug("Illegally formatted TypeAnnotations, dropping");
            return null;
        }
    }

    @Nonnull
    private Annotation readAnnotation(@Nonnull AnnotationScope scope) throws IOException {
        int typeIndex = this.is.readUnsignedShort();
        if (typeIndex > this.maxCpIndex) {
            logger.warn("Illegally formatted Annotation item, out of CP bounds, type_index={} > {}", (Object)typeIndex, (Object)this.maxCpIndex);
            throw new IllegalArgumentException("Annotation type_index out of CP bounds: " + typeIndex);
        }
        CpEntry cpEntry = this.cp.get(typeIndex);
        if (cpEntry instanceof CpUtf8) {
            CpUtf8 type = (CpUtf8)cpEntry;
            Map<CpUtf8, ElementValue> values = this.readElementPairs(scope.with(type.getText()));
            return new Annotation(type, values);
        }
        throw new IllegalArgumentException("Annotation type_index out does not point to UTF8: " + typeIndex);
    }

    @Nonnull
    private TypeAnnotation readTypeAnnotation(@Nonnull AnnotationScope scope) throws IOException {
        int targetType = this.is.readUnsignedByte();
        AttributeContext expectedLocation = AttributeContext.fromAnnotationTargetType(targetType);
        if (!this.context.equals((Object)expectedLocation)) {
            throw new IllegalArgumentException("Annotation location does not match allowed locations for its type");
        }
        TargetInfoType targetInfoType = TargetInfoType.fromTargetType(targetType);
        TargetInfo info = switch (targetInfoType) {
            case TargetInfoType.TYPE_PARAMETER_TARGET -> {
                int typeParameterIndex = this.is.readUnsignedByte();
                yield new TargetInfo.TypeParameterTargetInfo(targetType, typeParameterIndex);
            }
            case TargetInfoType.SUPERTYPE_TARGET -> {
                int superTypeIndex = this.is.readUnsignedShort();
                yield new TargetInfo.SuperTypeTargetInfo(targetType, superTypeIndex);
            }
            case TargetInfoType.TYPE_PARAMETER_BOUND_TARGET -> {
                int typeParameterIndex = this.is.readUnsignedByte();
                int boundIndex = this.is.readUnsignedByte();
                yield new TargetInfo.TypeParameterBoundTargetInfo(targetType, typeParameterIndex, boundIndex);
            }
            case TargetInfoType.EMPTY_TARGET -> new TargetInfo.EmptyTargetInfo(targetType);
            case TargetInfoType.FORMAL_PARAMETER_TARGET -> {
                int formalParameterIndex = this.is.readUnsignedByte();
                yield new TargetInfo.FormalParameterTargetInfo(targetType, formalParameterIndex);
            }
            case TargetInfoType.THROWS_TARGET -> {
                int throwsTypeIndex = this.is.readUnsignedShort();
                yield new TargetInfo.ThrowsTargetInfo(targetType, throwsTypeIndex);
            }
            case TargetInfoType.LOCALVAR_TARGET -> {
                int tableLength = this.is.readUnsignedShort();
                ArrayList<TargetInfo.LocalVarTargetInfo.Variable> variables = new ArrayList<TargetInfo.LocalVarTargetInfo.Variable>(tableLength);
                for (int i = 0; i < tableLength; ++i) {
                    int startPc = this.is.readUnsignedShort();
                    int length = this.is.readUnsignedShort();
                    int index = this.is.readUnsignedShort();
                    variables.add(new TargetInfo.LocalVarTargetInfo.Variable(startPc, length, index));
                }
                yield new TargetInfo.LocalVarTargetInfo(targetType, variables);
            }
            case TargetInfoType.CATCH_TARGET -> {
                int exceptionTableIndex = this.is.readUnsignedShort();
                yield new TargetInfo.CatchTargetInfo(targetType, exceptionTableIndex);
            }
            case TargetInfoType.OFFSET_TARGET -> {
                int offset = this.is.readUnsignedShort();
                yield new TargetInfo.OffsetTargetInfo(targetType, offset);
            }
            case TargetInfoType.TYPE_ARGUMENT_TARGET -> {
                int offset = this.is.readUnsignedShort();
                int typeArgumentIndex = this.is.readUnsignedByte();
                yield new TargetInfo.TypeArgumentTargetInfo(targetType, offset, typeArgumentIndex);
            }
            default -> throw new IllegalArgumentException("Invalid type argument target");
        };
        TypePath typePath = this.readTypePath();
        int typeIndex = this.is.readUnsignedShort();
        if (typeIndex > this.maxCpIndex) {
            logger.warn("Illegally formatted Annotation item, out of CP bounds, type_index={} > {}", (Object)typeIndex, (Object)this.maxCpIndex);
            throw new IllegalArgumentException("Annotation type_index out of CP bounds: " + typeIndex);
        }
        CpEntry startPc = this.cp.get(typeIndex);
        if (startPc instanceof CpUtf8) {
            CpUtf8 type = (CpUtf8)startPc;
            Map<CpUtf8, ElementValue> values = this.readElementPairs(scope.with(type.getText()));
            return new TypeAnnotation(type, values, info, typePath);
        }
        throw new IllegalArgumentException("Annotation type_index does not match allowed locations for its type");
    }

    private TypePath readTypePath() throws IOException {
        int length = this.is.readUnsignedByte();
        ArrayList<TypePathElement> elements = new ArrayList<TypePathElement>(length);
        for (int i = 0; i < length; ++i) {
            int kind = this.is.readUnsignedByte();
            int index = this.is.readUnsignedByte();
            elements.add(new TypePathElement(TypePathKind.fromValue(kind), index));
        }
        return new TypePath(elements);
    }

    @Nonnull
    private Map<CpUtf8, ElementValue> readElementPairs(@Nonnull AnnotationScope scope) throws IOException {
        if (scope.size() > 50) {
            throw new IllegalArgumentException("Bogus deep annotation packing detected");
        }
        LinkedHashMap<CpUtf8, ElementValue> values = new LinkedHashMap<CpUtf8, ElementValue>();
        for (int numPairs = this.is.readUnsignedShort(); numPairs > 0; --numPairs) {
            CpUtf8 elementName;
            int nameIndex = this.is.readUnsignedShort();
            ElementValue elementValue = this.readElementValue(scope);
            CpEntry cpEntry = this.cp.get(nameIndex);
            if (cpEntry instanceof CpUtf8) {
                elementName = (CpUtf8)cpEntry;
                if (values.containsKey(elementName)) {
                    throw new IllegalArgumentException("Element pairs already has field by name index: " + String.valueOf(elementName));
                }
            } else {
                throw new IllegalArgumentException("Element pair has invalid name specified by cp-index: " + nameIndex);
            }
            values.put(elementName, elementValue);
        }
        return values;
    }

    @Nonnull
    private ElementValue readElementValue(@Nonnull AnnotationScope scope) throws IOException {
        char tag = (char)this.is.readUnsignedByte();
        switch (tag) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                int index = this.is.readUnsignedShort();
                CpEntry entry = this.cp.get(index);
                if (entry != null) {
                    return new PrimitiveElementValue(tag, entry);
                }
                throw new IOException("Invalid element: " + tag);
            }
            case 's': {
                int utfIndex = this.is.readUnsignedShort();
                CpEntry entry = this.cp.get(utfIndex);
                if (entry instanceof CpUtf8) {
                    CpUtf8 utf = (CpUtf8)entry;
                    return new Utf8ElementValue(tag, utf);
                }
                throw new IOException("Invalid element: String");
            }
            case 'e': {
                int typename = this.is.readUnsignedShort();
                int constname = this.is.readUnsignedShort();
                CpEntry entryType = this.cp.get(typename);
                CpEntry entryConstant = this.cp.get(constname);
                if (entryType instanceof CpUtf8) {
                    CpUtf8 type = (CpUtf8)entryType;
                    if (entryConstant instanceof CpUtf8) {
                        CpUtf8 constant = (CpUtf8)entryConstant;
                        return new EnumElementValue(tag, type, constant);
                    }
                }
                throw new IOException("Invalid element: Enum");
            }
            case 'c': {
                int classInfoIndex = this.is.readUnsignedShort();
                CpEntry entry = this.cp.get(classInfoIndex);
                if (entry instanceof CpUtf8) {
                    CpUtf8 className = (CpUtf8)entry;
                    return new ClassElementValue(tag, className);
                }
                throw new IOException("Invalid element: Class");
            }
            case '@': {
                Annotation nestedAnnotation = this.readAnnotation(scope);
                return new AnnotationElementValue(tag, nestedAnnotation);
            }
            case '[': {
                int numElements = this.is.readUnsignedShort();
                ArrayList<ElementValue> arrayValues = new ArrayList<ElementValue>(numElements);
                for (int i = 0; i < numElements; ++i) {
                    arrayValues.add(this.readElementValue(scope.with("[")));
                }
                return new ArrayElementValue(tag, arrayValues);
            }
        }
        logger.debug("Unknown element_value tag: ({}) '{}'", (Object)tag, (Object)Character.valueOf(tag));
        throw new IllegalArgumentException("Unrecognized tag for annotation element value: " + tag);
    }

    static class AnnotationScope
    extends ArrayList<String> {
        AnnotationScope() {
        }

        AnnotationScope with(String value) {
            this.add(value);
            return this;
        }
    }
}

