/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.io;

import jakarta.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AttributeContext {
    CLASS,
    FIELD,
    METHOD,
    RECORD_COMPONENT,
    ATTRIBUTE;

    private static final Logger logger;

    @Nullable
    public static AttributeContext fromAnnotationTargetType(int targetType) {
        switch (targetType) {
            case 0: 
            case 16: 
            case 17: {
                return CLASS;
            }
            case 1: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                return METHOD;
            }
            case 19: {
                return FIELD;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                return ATTRIBUTE;
            }
        }
        logger.debug("Unknown target type, cannot determine attribute context for: {}", (Object)targetType);
        return null;
    }

    static {
        logger = LoggerFactory.getLogger(AttributeContext.class);
    }
}

