/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.io;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.coley.cafedude.classfile.ConstPool;
import software.coley.cafedude.classfile.InvalidCpIndexException;
import software.coley.cafedude.classfile.attribute.AnnotationDefaultAttribute;
import software.coley.cafedude.classfile.attribute.AnnotationsAttribute;
import software.coley.cafedude.classfile.attribute.Attribute;
import software.coley.cafedude.classfile.attribute.AttributeContexts;
import software.coley.cafedude.classfile.attribute.AttributeVersions;
import software.coley.cafedude.classfile.attribute.BootstrapMethodsAttribute;
import software.coley.cafedude.classfile.attribute.CharacterRangeTableAttribute;
import software.coley.cafedude.classfile.attribute.CodeAttribute;
import software.coley.cafedude.classfile.attribute.CompilationIdAttribute;
import software.coley.cafedude.classfile.attribute.ConstantValueAttribute;
import software.coley.cafedude.classfile.attribute.DefaultAttribute;
import software.coley.cafedude.classfile.attribute.DeprecatedAttribute;
import software.coley.cafedude.classfile.attribute.EnclosingMethodAttribute;
import software.coley.cafedude.classfile.attribute.ExceptionsAttribute;
import software.coley.cafedude.classfile.attribute.InnerClassesAttribute;
import software.coley.cafedude.classfile.attribute.LineNumberTableAttribute;
import software.coley.cafedude.classfile.attribute.LocalVariableTableAttribute;
import software.coley.cafedude.classfile.attribute.LocalVariableTypeTableAttribute;
import software.coley.cafedude.classfile.attribute.MethodParametersAttribute;
import software.coley.cafedude.classfile.attribute.ModuleAttribute;
import software.coley.cafedude.classfile.attribute.ModuleHashesAttribute;
import software.coley.cafedude.classfile.attribute.ModuleMainClassAttribute;
import software.coley.cafedude.classfile.attribute.ModulePackagesAttribute;
import software.coley.cafedude.classfile.attribute.ModuleResolutionAttribute;
import software.coley.cafedude.classfile.attribute.ModuleTargetAttribute;
import software.coley.cafedude.classfile.attribute.NestHostAttribute;
import software.coley.cafedude.classfile.attribute.NestMembersAttribute;
import software.coley.cafedude.classfile.attribute.ParameterAnnotationsAttribute;
import software.coley.cafedude.classfile.attribute.PermittedClassesAttribute;
import software.coley.cafedude.classfile.attribute.RecordAttribute;
import software.coley.cafedude.classfile.attribute.SignatureAttribute;
import software.coley.cafedude.classfile.attribute.SourceDebugExtensionAttribute;
import software.coley.cafedude.classfile.attribute.SourceFileAttribute;
import software.coley.cafedude.classfile.attribute.SourceIdAttribute;
import software.coley.cafedude.classfile.attribute.StackMapTableAttribute;
import software.coley.cafedude.classfile.attribute.SyntheticAttribute;
import software.coley.cafedude.classfile.constant.CpClass;
import software.coley.cafedude.classfile.constant.CpEntry;
import software.coley.cafedude.classfile.constant.CpMethodHandle;
import software.coley.cafedude.classfile.constant.CpModule;
import software.coley.cafedude.classfile.constant.CpNameType;
import software.coley.cafedude.classfile.constant.CpPackage;
import software.coley.cafedude.classfile.constant.CpUtf8;
import software.coley.cafedude.classfile.constant.Placeholders;
import software.coley.cafedude.classfile.instruction.Instruction;
import software.coley.cafedude.io.AnnotationReader;
import software.coley.cafedude.io.AttributeContext;
import software.coley.cafedude.io.ClassBuilder;
import software.coley.cafedude.io.ClassFileReader;
import software.coley.cafedude.io.IndexableByteStream;
import software.coley.cafedude.io.InstructionReader;

public class AttributeReader {
    private static final Pattern NON_BS_ATTR_NAME = Pattern.compile("\\w{1,30}");
    private static final Logger logger = LoggerFactory.getLogger(AttributeReader.class);
    private final IndexableByteStream is;
    private final ClassFileReader reader;
    private final ClassBuilder builder;
    private final ConstPool cp;
    private final int expectedContentLength;
    private final CpUtf8 name;

    private AttributeReader(@Nonnull ClassFileReader reader, @Nonnull ClassBuilder builder, @Nonnull IndexableByteStream is) throws IOException {
        CpUtf8 utf;
        this.reader = reader;
        this.builder = builder;
        this.cp = builder.getPool();
        CpEntry nameEntry = this.cp.get(is.readUnsignedShort());
        this.name = nameEntry instanceof CpUtf8 ? (utf = (CpUtf8)nameEntry) : Placeholders.UTF8;
        this.expectedContentLength = is.readInt();
        int index = is.getAbsoluteIndex();
        this.is = new IndexableByteStream(is, this.expectedContentLength);
        is.moveToAbsolute(index + this.expectedContentLength);
    }

    @Nullable
    public static Attribute readAttribute(@Nonnull ClassFileReader reader, @Nonnull ClassBuilder builder, @Nonnull IndexableByteStream is, @Nonnull AttributeContext context) throws IOException {
        String attributeName = null;
        int expectedContentLength = -1;
        try {
            int readerRelativePos;
            AttributeReader attributeReader = new AttributeReader(reader, builder, is);
            attributeName = attributeReader.getAttributeName();
            expectedContentLength = attributeReader.getExpectedContentLength();
            Attribute attribute = attributeReader.read(context);
            if (attribute == null) {
                return null;
            }
            int readerAbsolutePos = attributeReader.getAbsoluteReadPosition();
            boolean hasCorrectedPosition = false;
            if (context == AttributeContext.METHOD) {
                if (attributeName.equals("Code")) {
                    is.moveToAbsolute(readerAbsolutePos);
                    hasCorrectedPosition = true;
                }
                if (attributeName.equals("Exceptions")) {
                    is.moveToAbsolute(readerAbsolutePos);
                    hasCorrectedPosition = true;
                }
            } else if (context == AttributeContext.ATTRIBUTE && attributeName.equals("LocalVariableTable")) {
                is.moveToAbsolute(readerAbsolutePos);
                hasCorrectedPosition = true;
            }
            if (!hasCorrectedPosition && (readerRelativePos = attributeReader.getRelativeReadPosition()) != expectedContentLength) {
                logger.debug("Invalid '{}' on {}, claimed to be {} bytes, but was {}", new Object[]{attributeName, context.name(), expectedContentLength, readerRelativePos});
                return null;
            }
            if (attribute.cpAccesses().stream().anyMatch(Placeholders::isOrContainsPlaceholder)) {
                return null;
            }
            return attribute;
        }
        catch (InvalidCpIndexException ex) {
            logger.debug("Invalid '{}' on {}, invalid constant pool index: {}", new Object[]{attributeName, context.name(), ex.getIndex()});
            return null;
        }
        catch (IOException ex) {
            if (reader.doDropEofAttributes()) {
                logger.debug("Invalid '{}' on {}, EOF thrown when parsing attribute, expected {} bytes", new Object[]{attributeName, context.name(), expectedContentLength});
                return null;
            }
            throw ex;
        }
    }

    @Nullable
    private Attribute read(@Nonnull AttributeContext context) throws IOException {
        int introducedAt;
        String attributeName = this.name.getText();
        if (this.reader.doDropForwardVersioned() && (introducedAt = AttributeVersions.getIntroducedVersion(attributeName)) > this.builder.getVersionMajor()) {
            logger.debug("Found '{}' on {} in class version {}, min supported is {}", new Object[]{attributeName, context.name(), this.builder.getVersionMajor(), introducedAt});
            return null;
        }
        if (this.reader.doDropBadContextAttributes()) {
            Collection<AttributeContext> allowedContexts = AttributeContexts.getAllowedContexts(attributeName);
            if (!allowedContexts.contains((Object)context)) {
                logger.debug("Found '{}' in invalid context {}", (Object)attributeName, (Object)context.name());
                return null;
            }
            if (!this.builder.isModule() && attributeName.toLowerCase().startsWith("module")) {
                logger.debug("Found '{}' in non-module class", (Object)attributeName);
                return null;
            }
        }
        if (this.builder.isAnnotation() && attributeName.equals("Code")) {
            return null;
        }
        switch (attributeName) {
            case "Code": {
                return this.readCode();
            }
            case "ConstantValue": {
                return this.readConstantValue();
            }
            case "Deprecated": {
                return new DeprecatedAttribute(this.name);
            }
            case "EnclosingMethod": {
                return this.readEnclosingMethod();
            }
            case "Exceptions": {
                return this.readExceptions();
            }
            case "InnerClasses": {
                return this.readInnerClasses();
            }
            case "NestHost": {
                return this.readNestHost();
            }
            case "NestMembers": {
                return this.readNestMembers();
            }
            case "SourceDebugExtension": {
                return this.readSourceDebugExtension();
            }
            case "RuntimeInvisibleAnnotations": {
                return this.readAnnotations(context, false);
            }
            case "RuntimeVisibleAnnotations": {
                return this.readAnnotations(context, true);
            }
            case "RuntimeInvisibleParameterAnnotations": {
                return this.readParameterAnnotations(context, false);
            }
            case "RuntimeVisibleParameterAnnotations": {
                return this.readParameterAnnotations(context, true);
            }
            case "RuntimeInvisibleTypeAnnotations": {
                return this.readTypeAnnotations(context, false);
            }
            case "RuntimeVisibleTypeAnnotations": {
                return this.readTypeAnnotations(context, true);
            }
            case "AnnotationDefault": {
                return this.readAnnotationDefault(context);
            }
            case "Synthetic": {
                return this.readSynthetic();
            }
            case "BootstrapMethods": {
                return this.readBoostrapMethods();
            }
            case "Signature": {
                return this.readSignature();
            }
            case "SourceFile": {
                return this.readSourceFile();
            }
            case "MethodParameters": {
                return this.readMethodParameters();
            }
            case "Module": {
                return this.readModule();
            }
            case "ModuleMainClass": {
                return this.readModuleMainClass();
            }
            case "ModulePackages": {
                return this.readModulePackages();
            }
            case "ModuleTarget": {
                return this.readModuleTarget();
            }
            case "ModuleHashes": {
                return this.readModuleHashes();
            }
            case "ModuleResolution": {
                return this.readModuleResolution();
            }
            case "StackMapTable": {
                return this.readStackMapTable();
            }
            case "LineNumberTable": {
                return this.readLineNumbers();
            }
            case "LocalVariableTable": {
                return this.readLocalVariables();
            }
            case "LocalVariableTypeTable": {
                return this.readLocalVariableTypes();
            }
            case "PermittedSubclasses": {
                return this.readPermittedClasses();
            }
            case "Record": {
                return this.readRecord();
            }
            case "CompilationID": {
                return this.readCompileId();
            }
            case "SourceID": {
                return this.readSourceId();
            }
            case "CharacterRangeTable": {
                return this.readCharacterRangeTable();
            }
        }
        if (this.expectedContentLength < 2) {
            logger.debug("Invalid attribute, its content length <= 1");
            this.is.skipBytes(this.expectedContentLength);
            return null;
        }
        this.is.skipBytes(this.expectedContentLength);
        return new DefaultAttribute(this.name, this.is.getBuffer());
    }

    @Nonnull
    private RecordAttribute readRecord() throws IOException {
        int count = this.is.readUnsignedShort();
        ArrayList<RecordAttribute.RecordComponent> components = new ArrayList<RecordAttribute.RecordComponent>(count);
        for (int i = 0; i < count; ++i) {
            CpUtf8 name = (CpUtf8)this.cp.get(this.is.readUnsignedShort());
            CpUtf8 descriptor = (CpUtf8)this.cp.get(this.is.readUnsignedShort());
            int numAttributes = this.is.readUnsignedShort();
            ArrayList<Attribute> attributes = new ArrayList<Attribute>(numAttributes);
            for (int x = 0; x < numAttributes; ++x) {
                Attribute attr = AttributeReader.readAttribute(this.reader, this.builder, this.is, AttributeContext.ATTRIBUTE);
                if (attr == null) continue;
                attributes.add(attr);
            }
            components.add(new RecordAttribute.RecordComponent(name, descriptor, attributes));
        }
        return new RecordAttribute(this.name, components);
    }

    @Nonnull
    private PermittedClassesAttribute readPermittedClasses() throws IOException {
        int count = this.is.readUnsignedShort();
        ArrayList<CpClass> entries = new ArrayList<CpClass>(count);
        for (int i = 0; i < count; ++i) {
            CpClass entry = (CpClass)this.cp.get(this.is.readUnsignedShort());
            entries.add(entry);
        }
        return new PermittedClassesAttribute(this.name, entries);
    }

    @Nonnull
    private LocalVariableTableAttribute readLocalVariables() throws IOException {
        int count = this.is.readUnsignedShort();
        ArrayList<LocalVariableTableAttribute.VarEntry> entries = new ArrayList<LocalVariableTableAttribute.VarEntry>(count);
        for (int i = 0; i < count; ++i) {
            int startPc = this.is.readUnsignedShort();
            int length = this.is.readUnsignedShort();
            int nameIndex = this.is.readUnsignedShort();
            int descIndex = this.is.readUnsignedShort();
            int index = this.is.readUnsignedShort();
            CpEntry name = this.cp.get(nameIndex);
            CpEntry desc = this.cp.get(descIndex);
            if (!(name instanceof CpUtf8)) continue;
            CpUtf8 nameUtf = (CpUtf8)name;
            if (!(desc instanceof CpUtf8)) continue;
            CpUtf8 descUtf = (CpUtf8)desc;
            entries.add(new LocalVariableTableAttribute.VarEntry(startPc, length, nameUtf, descUtf, index));
        }
        return new LocalVariableTableAttribute(this.name, entries);
    }

    @Nonnull
    private LocalVariableTypeTableAttribute readLocalVariableTypes() throws IOException {
        int count = this.is.readUnsignedShort();
        ArrayList<LocalVariableTypeTableAttribute.VarTypeEntry> entries = new ArrayList<LocalVariableTypeTableAttribute.VarTypeEntry>(count);
        for (int i = 0; i < count; ++i) {
            int startPc = this.is.readUnsignedShort();
            int length = this.is.readUnsignedShort();
            int nameIndex = this.is.readUnsignedShort();
            int signatureIndex = this.is.readUnsignedShort();
            int index = this.is.readUnsignedShort();
            CpEntry name = this.cp.get(nameIndex);
            CpEntry sig = this.cp.get(signatureIndex);
            if (!(name instanceof CpUtf8)) continue;
            CpUtf8 nameUtf = (CpUtf8)name;
            if (!(sig instanceof CpUtf8)) continue;
            CpUtf8 sigUtf = (CpUtf8)sig;
            entries.add(new LocalVariableTypeTableAttribute.VarTypeEntry(startPc, length, nameUtf, sigUtf, index));
        }
        return new LocalVariableTypeTableAttribute(this.name, entries);
    }

    @Nonnull
    private LineNumberTableAttribute readLineNumbers() throws IOException {
        int count = this.is.readUnsignedShort();
        ArrayList<LineNumberTableAttribute.LineEntry> entries = new ArrayList<LineNumberTableAttribute.LineEntry>(count);
        for (int i = 0; i < count; ++i) {
            int offset = this.is.readUnsignedShort();
            int line = this.is.readUnsignedShort();
            entries.add(new LineNumberTableAttribute.LineEntry(offset, line));
        }
        return new LineNumberTableAttribute(this.name, entries);
    }

    @Nonnull
    private MethodParametersAttribute readMethodParameters() throws IOException {
        int count = this.is.readUnsignedByte();
        ArrayList<MethodParametersAttribute.Parameter> entries = new ArrayList<MethodParametersAttribute.Parameter>(count);
        for (int i = 0; i < count; ++i) {
            CpUtf8 name = this.orNullInCp(CpUtf8.class, this.is.readUnsignedShort());
            int accessFlags = this.is.readUnsignedShort();
            entries.add(new MethodParametersAttribute.Parameter(accessFlags, name));
        }
        return new MethodParametersAttribute(this.name, entries);
    }

    @Nullable
    private ModuleAttribute readModule() throws IOException {
        CpModule module = (CpModule)this.cp.get(this.is.readUnsignedShort());
        if (module == null) {
            return null;
        }
        int flags = this.is.readUnsignedShort();
        CpUtf8 version = this.orNullInCp(CpUtf8.class, this.is.readUnsignedShort());
        int count = this.is.readUnsignedShort();
        ArrayList<ModuleAttribute.Requires> requires = new ArrayList<ModuleAttribute.Requires>(count);
        for (int i = 0; i < count; ++i) {
            CpModule reqModule = (CpModule)this.cp.get(this.is.readUnsignedShort());
            if (reqModule == null) continue;
            int reqFlags = this.is.readUnsignedShort();
            CpUtf8 reqVersion = this.orNullInCp(CpUtf8.class, this.is.readUnsignedShort());
            requires.add(new ModuleAttribute.Requires(reqModule, reqFlags, reqVersion));
        }
        count = this.is.readUnsignedShort();
        ArrayList<ModuleAttribute.Exports> exports = new ArrayList<ModuleAttribute.Exports>(count);
        for (int i = 0; i < count; ++i) {
            CpPackage expPackage = (CpPackage)this.cp.get(this.is.readUnsignedShort());
            if (expPackage == null) continue;
            int expFlags = this.is.readUnsignedShort();
            int expCount = this.is.readUnsignedShort();
            ArrayList<CpModule> expModules = new ArrayList<CpModule>(expCount);
            for (int j = 0; j < expCount; ++j) {
                CpModule expModule = (CpModule)this.cp.get(this.is.readUnsignedShort());
                expModules.add(expModule);
            }
            exports.add(new ModuleAttribute.Exports(expPackage, expFlags, expModules));
        }
        count = this.is.readUnsignedShort();
        ArrayList<ModuleAttribute.Opens> opens = new ArrayList<ModuleAttribute.Opens>(count);
        for (int i = 0; i < count; ++i) {
            CpPackage openPackage = (CpPackage)this.cp.get(this.is.readUnsignedShort());
            if (openPackage == null) continue;
            int openFlags = this.is.readUnsignedShort();
            int openCount = this.is.readUnsignedShort();
            ArrayList<CpModule> openModules = new ArrayList<CpModule>(openCount);
            for (int j = 0; j < openCount; ++j) {
                CpModule openModule = (CpModule)this.cp.get(this.is.readUnsignedShort());
                openModules.add(openModule);
            }
            opens.add(new ModuleAttribute.Opens(openPackage, openFlags, openModules));
        }
        count = this.is.readUnsignedShort();
        ArrayList<CpClass> uses = new ArrayList<CpClass>(count);
        for (int i = 0; i < count; ++i) {
            CpClass useClass = (CpClass)this.cp.get(this.is.readUnsignedShort());
            uses.add(useClass);
        }
        count = this.is.readUnsignedShort();
        ArrayList<ModuleAttribute.Provides> provides = new ArrayList<ModuleAttribute.Provides>(count);
        for (int i = 0; i < count; ++i) {
            CpClass service = (CpClass)this.cp.get(this.is.readUnsignedShort());
            if (service == null) continue;
            int prvCount = this.is.readUnsignedShort();
            ArrayList<CpClass> providers = new ArrayList<CpClass>(prvCount);
            for (int j = 0; j < prvCount; ++j) {
                CpClass provider = (CpClass)this.cp.get(this.is.readUnsignedShort());
                providers.add(provider);
            }
            provides.add(new ModuleAttribute.Provides(service, providers));
        }
        return new ModuleAttribute(this.name, module, flags, version, requires, exports, opens, uses, provides);
    }

    @Nonnull
    private ModuleMainClassAttribute readModuleMainClass() throws IOException {
        return new ModuleMainClassAttribute(this.name, (CpClass)this.cp.get(this.is.readUnsignedShort()));
    }

    @Nonnull
    private ModulePackagesAttribute readModulePackages() throws IOException {
        int count = this.is.readUnsignedShort();
        ArrayList<CpPackage> packages = new ArrayList<CpPackage>(count);
        for (int i = 0; i < count; ++i) {
            packages.add((CpPackage)this.cp.get(this.is.readUnsignedShort()));
        }
        return new ModulePackagesAttribute(this.name, packages);
    }

    @Nonnull
    private ModuleTargetAttribute readModuleTarget() throws IOException {
        CpUtf8 platformName = (CpUtf8)this.cp.get(this.is.readUnsignedShort());
        return new ModuleTargetAttribute(this.name, platformName);
    }

    @Nonnull
    private ModuleHashesAttribute readModuleHashes() throws IOException {
        CpUtf8 algorithm = (CpUtf8)this.cp.get(this.is.readUnsignedShort());
        int moduleCount = this.is.readUnsignedShort();
        LinkedHashMap<CpUtf8, byte[]> moduleHashes = new LinkedHashMap<CpUtf8, byte[]>();
        for (int i = 0; i < moduleCount; ++i) {
            int moduleNameIndex = this.is.readUnsignedShort();
            int moduleHashLength = this.is.readUnsignedShort();
            CpUtf8 moduleName = (CpUtf8)this.cp.get(moduleNameIndex);
            byte[] moduleHash = new byte[moduleHashLength];
            this.is.read(moduleHash);
            moduleHashes.put(moduleName, moduleHash);
        }
        return new ModuleHashesAttribute(this.name, algorithm, moduleHashes);
    }

    @Nonnull
    private ModuleResolutionAttribute readModuleResolution() throws IOException {
        return new ModuleResolutionAttribute(this.name, this.is.readUnsignedShort());
    }

    @Nonnull
    private SignatureAttribute readSignature() throws IOException {
        CpUtf8 signature = (CpUtf8)this.cp.get(this.is.readUnsignedShort());
        return new SignatureAttribute(this.name, signature);
    }

    @Nullable
    private SourceFileAttribute readSourceFile() throws IOException {
        CpEntry sourceEntry = this.cp.get(this.is.readUnsignedShort());
        if (sourceEntry instanceof CpUtf8) {
            CpUtf8 sourceFileUtf = (CpUtf8)sourceEntry;
            return new SourceFileAttribute(this.name, sourceFileUtf);
        }
        return null;
    }

    @Nullable
    private CompilationIdAttribute readCompileId() throws IOException {
        CpEntry idEntry = this.cp.get(this.is.readUnsignedShort());
        if (idEntry instanceof CpUtf8) {
            CpUtf8 idEntryUtf = (CpUtf8)idEntry;
            return new CompilationIdAttribute(this.name, idEntryUtf);
        }
        return null;
    }

    @Nullable
    private SourceIdAttribute readSourceId() throws IOException {
        CpEntry idEntry = this.cp.get(this.is.readUnsignedShort());
        if (idEntry instanceof CpUtf8) {
            CpUtf8 idEntryUtf = (CpUtf8)idEntry;
            return new SourceIdAttribute(this.name, idEntryUtf);
        }
        return null;
    }

    @Nullable
    private EnclosingMethodAttribute readEnclosingMethod() throws IOException {
        CpEntry enclosingClass = this.cp.get(this.is.readUnsignedShort());
        CpNameType enclosingMethod = this.orNullInCp(CpNameType.class, this.is.readUnsignedShort());
        if (enclosingClass instanceof CpClass) {
            CpClass classEntry = (CpClass)enclosingClass;
            return new EnclosingMethodAttribute(this.name, classEntry, enclosingMethod);
        }
        return null;
    }

    @Nonnull
    private ExceptionsAttribute readExceptions() throws IOException {
        int numberOfExceptionIndices = this.is.readUnsignedShort();
        ArrayList<CpClass> exceptions = new ArrayList<CpClass>(numberOfExceptionIndices);
        for (int i = 0; i < numberOfExceptionIndices; ++i) {
            CpClass exceptionClass;
            CpEntry exceptionEntry = this.cp.get(this.is.readUnsignedShort());
            if (!(exceptionEntry instanceof CpClass) || exceptions.contains(exceptionClass = (CpClass)exceptionEntry)) continue;
            exceptions.add(exceptionClass);
        }
        return new ExceptionsAttribute(this.name, exceptions);
    }

    @Nonnull
    private InnerClassesAttribute readInnerClasses() throws IOException {
        int numberOfInnerClasses = this.is.readUnsignedShort();
        ArrayList<InnerClassesAttribute.InnerClass> innerClasses = new ArrayList<InnerClassesAttribute.InnerClass>(numberOfInnerClasses);
        for (int i = 0; i < numberOfInnerClasses; ++i) {
            CpClass innerClass = (CpClass)this.cp.get(this.is.readUnsignedShort());
            CpClass outerClass = this.orNullInCp(CpClass.class, this.is.readUnsignedShort());
            CpUtf8 innerName = this.orNullInCp(CpUtf8.class, this.is.readUnsignedShort());
            int innerClassAccessFlags = this.is.readUnsignedShort();
            innerClasses.add(new InnerClassesAttribute.InnerClass(innerClass, outerClass, innerName, innerClassAccessFlags));
        }
        return new InnerClassesAttribute(this.name, innerClasses);
    }

    @Nullable
    private NestHostAttribute readNestHost() throws IOException {
        if (this.expectedContentLength != 2) {
            logger.debug("Found NestHost with illegal content length: {} != 2", (Object)this.expectedContentLength);
            return null;
        }
        CpClass nestHost = (CpClass)this.cp.get(this.is.readUnsignedShort());
        return new NestHostAttribute(this.name, nestHost);
    }

    @Nonnull
    private NestMembersAttribute readNestMembers() throws IOException {
        int count = this.is.readUnsignedShort();
        ArrayList<CpClass> memberClasses = new ArrayList<CpClass>(count);
        for (int i = 0; i < count; ++i) {
            CpClass memberClass;
            CpEntry memberEntry = this.cp.get(this.is.readUnsignedShort());
            if (!(memberEntry instanceof CpClass) || memberClasses.contains(memberClass = (CpClass)memberEntry)) continue;
            memberClasses.add(memberClass);
        }
        return new NestMembersAttribute(this.name, memberClasses);
    }

    @Nullable
    private SourceDebugExtensionAttribute readSourceDebugExtension() throws IOException {
        byte[] debugExtension = new byte[this.expectedContentLength];
        this.is.readFully(debugExtension);
        try {
            new DataInputStream(new ByteArrayInputStream(debugExtension)).readUTF();
        }
        catch (Throwable t) {
            logger.debug("Invalid SourceDebugExtension, not a valid UTF");
            return null;
        }
        return new SourceDebugExtensionAttribute(this.name, debugExtension);
    }

    @Nullable
    private AnnotationsAttribute readAnnotations(AttributeContext context, boolean visible) throws IOException {
        return new AnnotationReader(this.reader, this.builder.getPool(), this.is, this.expectedContentLength, this.name, context, visible).readAnnotations();
    }

    @Nullable
    private ParameterAnnotationsAttribute readParameterAnnotations(AttributeContext context, boolean visible) throws IOException {
        return new AnnotationReader(this.reader, this.builder.getPool(), this.is, this.expectedContentLength, this.name, context, visible).readParameterAnnotations();
    }

    @Nullable
    private AnnotationsAttribute readTypeAnnotations(AttributeContext context, boolean visible) throws IOException {
        return new AnnotationReader(this.reader, this.builder.getPool(), this.is, this.expectedContentLength, this.name, context, visible).readTypeAnnotations();
    }

    @Nullable
    private AnnotationDefaultAttribute readAnnotationDefault(AttributeContext context) throws IOException {
        return new AnnotationReader(this.reader, this.builder.getPool(), this.is, this.expectedContentLength, this.name, context, true).readAnnotationDefault();
    }

    @Nonnull
    private SyntheticAttribute readSynthetic() {
        return new SyntheticAttribute(this.name);
    }

    @Nonnull
    private BootstrapMethodsAttribute readBoostrapMethods() throws IOException {
        int bsmCount = this.is.readUnsignedShort();
        ArrayList<BootstrapMethodsAttribute.BootstrapMethod> bootstrapMethods = new ArrayList<BootstrapMethodsAttribute.BootstrapMethod>(bsmCount);
        for (int i = 0; i < bsmCount; ++i) {
            CpMethodHandle methodRef = (CpMethodHandle)this.cp.get(this.is.readUnsignedShort());
            int argCount = this.is.readUnsignedShort();
            ArrayList<CpEntry> args = new ArrayList<CpEntry>(argCount);
            for (int j = 0; j < argCount; ++j) {
                args.add(this.cp.get(this.is.readUnsignedShort()));
            }
            bootstrapMethods.add(new BootstrapMethodsAttribute.BootstrapMethod(methodRef, args));
        }
        return new BootstrapMethodsAttribute(this.name, bootstrapMethods);
    }

    @Nonnull
    private CharacterRangeTableAttribute readCharacterRangeTable() throws IOException {
        int len = this.is.readUnsignedShort();
        ArrayList<CharacterRangeTableAttribute.CharacterRangeInfo> table = new ArrayList<CharacterRangeTableAttribute.CharacterRangeInfo>(len);
        for (int i = 0; i < len; ++i) {
            int startPc = this.is.readUnsignedShort();
            int endPc = this.is.readUnsignedShort();
            int charRangeStart = this.is.readInt();
            int charRangeEnd = this.is.readInt();
            int flags = this.is.readUnsignedShort();
            table.add(new CharacterRangeTableAttribute.CharacterRangeInfo(startPc, endPc, charRangeStart, charRangeEnd, flags));
        }
        return new CharacterRangeTableAttribute(this.name, table);
    }

    @Nonnull
    private CodeAttribute readCode() throws IOException {
        int maxStack = -1;
        int maxLocals = -1;
        int codeLength = -1;
        if (this.builder.isOakVersion()) {
            maxStack = this.is.readUnsignedByte();
            maxLocals = this.is.readUnsignedByte();
            codeLength = this.is.readUnsignedShort();
        } else {
            maxStack = this.is.readUnsignedShort();
            maxLocals = this.is.readUnsignedShort();
            codeLength = this.is.readInt();
        }
        if (this.reader.doCheckCodeLength() && codeLength > 65536) {
            throw new IOException("Method code_length > 65536: " + codeLength);
        }
        InstructionReader insnReader = new InstructionReader(this.reader.getFallbackInstructionReader(this.builder));
        List<Instruction> instructions = insnReader.read(this.is, this.cp, codeLength);
        int numExceptions = this.is.readUnsignedShort();
        ArrayList<CodeAttribute.ExceptionTableEntry> exceptions = new ArrayList<CodeAttribute.ExceptionTableEntry>(numExceptions);
        for (int i = 0; i < numExceptions; ++i) {
            CodeAttribute.ExceptionTableEntry entry = this.readCodeException(codeLength);
            if (entry == null) continue;
            exceptions.add(entry);
        }
        int numAttributes = this.is.readUnsignedShort();
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(numAttributes);
        for (int i = 0; i < numAttributes; ++i) {
            Attribute attr = AttributeReader.readAttribute(this.reader, this.builder, this.is, AttributeContext.ATTRIBUTE);
            if (attr == null) continue;
            attributes.add(attr);
        }
        return new CodeAttribute(this.name, maxStack, maxLocals, instructions, exceptions, attributes);
    }

    @Nullable
    private CodeAttribute.ExceptionTableEntry readCodeException(int codeLength) throws IOException {
        int startPc = this.is.readUnsignedShort();
        int endPc = this.is.readUnsignedShort();
        int handlerPc = this.is.readUnsignedShort();
        int catchTypeCpIndex = this.is.readUnsignedShort();
        if (startPc >= codeLength || endPc > codeLength || handlerPc > codeLength) {
            return null;
        }
        if (startPc == endPc) {
            return null;
        }
        CpClass exceptionType = this.orNullInCp(CpClass.class, catchTypeCpIndex);
        return new CodeAttribute.ExceptionTableEntry(startPc, endPc, handlerPc, exceptionType);
    }

    @Nonnull
    private ConstantValueAttribute readConstantValue() throws IOException {
        CpEntry value = this.cp.get(this.is.readUnsignedShort());
        return new ConstantValueAttribute(this.name, value);
    }

    @Nonnull
    private StackMapTableAttribute readStackMapTable() throws IOException {
        int numEntries = this.is.readUnsignedShort();
        ArrayList<StackMapTableAttribute.StackMapFrame> frames = new ArrayList<StackMapTableAttribute.StackMapFrame>(numEntries);
        for (int i = 0; i < numEntries; ++i) {
            int j;
            ArrayList<StackMapTableAttribute.TypeInfo> locals;
            int frameType = this.is.readUnsignedByte();
            if (frameType <= 63) {
                frames.add(new StackMapTableAttribute.SameFrame(frameType));
                continue;
            }
            if (frameType <= 127) {
                StackMapTableAttribute.TypeInfo stack = this.readVerificationTypeInfo();
                frames.add(new StackMapTableAttribute.SameLocalsOneStackItem(frameType - 64, stack));
                continue;
            }
            if (frameType < 247) {
                throw new IllegalArgumentException("Unknown stackframe tag " + frameType);
            }
            if (frameType <= 247) {
                int offsetDelta = this.is.readUnsignedShort();
                StackMapTableAttribute.TypeInfo stack = this.readVerificationTypeInfo();
                frames.add(new StackMapTableAttribute.SameLocalsOneStackItemExtended(offsetDelta, stack));
                continue;
            }
            if (frameType <= 250) {
                int k = 251 - frameType;
                int offsetDelta = this.is.readUnsignedShort();
                frames.add(new StackMapTableAttribute.ChopFrame(offsetDelta, k));
                continue;
            }
            if (frameType < 252) {
                int offsetDelta = this.is.readUnsignedShort();
                frames.add(new StackMapTableAttribute.SameFrameExtended(offsetDelta));
                continue;
            }
            if (frameType <= 254) {
                int offsetDelta = this.is.readUnsignedShort();
                int numLocals = frameType - 251;
                locals = new ArrayList<StackMapTableAttribute.TypeInfo>(numLocals);
                for (j = 0; j < numLocals; ++j) {
                    locals.add(this.readVerificationTypeInfo());
                }
                frames.add(new StackMapTableAttribute.AppendFrame(offsetDelta, locals));
                continue;
            }
            if (frameType <= 255) {
                int offsetDelta = this.is.readUnsignedShort();
                int numLocals = this.is.readUnsignedShort();
                locals = new ArrayList(numLocals);
                for (j = 0; j < numLocals; ++j) {
                    locals.add(this.readVerificationTypeInfo());
                }
                int numStackItems = this.is.readUnsignedShort();
                ArrayList<StackMapTableAttribute.TypeInfo> stack = new ArrayList<StackMapTableAttribute.TypeInfo>(numStackItems);
                for (int j2 = 0; j2 < numStackItems; ++j2) {
                    stack.add(this.readVerificationTypeInfo());
                }
                frames.add(new StackMapTableAttribute.FullFrame(offsetDelta, locals, stack));
                continue;
            }
            throw new IllegalArgumentException("Unknown frame type " + frameType);
        }
        return new StackMapTableAttribute(this.name, frames);
    }

    @Nonnull
    private StackMapTableAttribute.TypeInfo readVerificationTypeInfo() throws IOException {
        int tag = this.is.readUnsignedByte();
        switch (tag) {
            case 0: {
                return new StackMapTableAttribute.TopVariableInfo();
            }
            case 1: {
                return new StackMapTableAttribute.IntegerVariableInfo();
            }
            case 2: {
                return new StackMapTableAttribute.FloatVariableInfo();
            }
            case 3: {
                return new StackMapTableAttribute.DoubleVariableInfo();
            }
            case 4: {
                return new StackMapTableAttribute.LongVariableInfo();
            }
            case 5: {
                return new StackMapTableAttribute.NullVariableInfo();
            }
            case 6: {
                return new StackMapTableAttribute.UninitializedThisVariableInfo();
            }
            case 7: {
                CpClass classEntry = (CpClass)this.cp.get(this.is.readUnsignedShort());
                return new StackMapTableAttribute.ObjectVariableInfo(classEntry);
            }
            case 8: {
                int offset = this.is.readUnsignedShort();
                return new StackMapTableAttribute.UninitializedVariableInfo(offset);
            }
        }
        throw new IllegalArgumentException("Unknown verification type tag " + tag);
    }

    public int getAbsoluteReadPosition() {
        return this.is.getAbsoluteIndex();
    }

    public int getRelativeReadPosition() {
        return this.is.getIndex();
    }

    public int getExpectedContentLength() {
        return this.expectedContentLength;
    }

    @Nonnull
    public String getAttributeName() {
        if (Placeholders.isPlaceholder(this.name)) {
            return "<unknown>";
        }
        String name = this.name.getText();
        if (!NON_BS_ATTR_NAME.matcher(name).matches()) {
            return "<unknown>";
        }
        return name;
    }

    @Nullable
    private <T extends CpEntry> T orNullInCp(@Nonnull Class<T> type, int index) {
        if (index == 0) {
            return null;
        }
        CpEntry entry = this.cp.get(index);
        if (entry == null) {
            return null;
        }
        if (entry.getClass().isAssignableFrom(type)) {
            return (T)entry;
        }
        return null;
    }
}

