/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.io;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import software.coley.cafedude.classfile.attribute.AnnotationDefaultAttribute;
import software.coley.cafedude.classfile.attribute.AnnotationsAttribute;
import software.coley.cafedude.classfile.attribute.Attribute;
import software.coley.cafedude.classfile.attribute.BootstrapMethodsAttribute;
import software.coley.cafedude.classfile.attribute.CharacterRangeTableAttribute;
import software.coley.cafedude.classfile.attribute.CodeAttribute;
import software.coley.cafedude.classfile.attribute.CompilationIdAttribute;
import software.coley.cafedude.classfile.attribute.ConstantValueAttribute;
import software.coley.cafedude.classfile.attribute.DefaultAttribute;
import software.coley.cafedude.classfile.attribute.EnclosingMethodAttribute;
import software.coley.cafedude.classfile.attribute.ExceptionsAttribute;
import software.coley.cafedude.classfile.attribute.InnerClassesAttribute;
import software.coley.cafedude.classfile.attribute.LineNumberTableAttribute;
import software.coley.cafedude.classfile.attribute.LocalVariableTableAttribute;
import software.coley.cafedude.classfile.attribute.LocalVariableTypeTableAttribute;
import software.coley.cafedude.classfile.attribute.MethodParametersAttribute;
import software.coley.cafedude.classfile.attribute.ModuleAttribute;
import software.coley.cafedude.classfile.attribute.ModuleHashesAttribute;
import software.coley.cafedude.classfile.attribute.ModuleMainClassAttribute;
import software.coley.cafedude.classfile.attribute.ModulePackagesAttribute;
import software.coley.cafedude.classfile.attribute.ModuleResolutionAttribute;
import software.coley.cafedude.classfile.attribute.ModuleTargetAttribute;
import software.coley.cafedude.classfile.attribute.NestHostAttribute;
import software.coley.cafedude.classfile.attribute.NestMembersAttribute;
import software.coley.cafedude.classfile.attribute.ParameterAnnotationsAttribute;
import software.coley.cafedude.classfile.attribute.PermittedClassesAttribute;
import software.coley.cafedude.classfile.attribute.RecordAttribute;
import software.coley.cafedude.classfile.attribute.SignatureAttribute;
import software.coley.cafedude.classfile.attribute.SourceDebugExtensionAttribute;
import software.coley.cafedude.classfile.attribute.SourceFileAttribute;
import software.coley.cafedude.classfile.attribute.SourceIdAttribute;
import software.coley.cafedude.classfile.attribute.StackMapTableAttribute;
import software.coley.cafedude.classfile.constant.CpClass;
import software.coley.cafedude.classfile.constant.CpEntry;
import software.coley.cafedude.classfile.constant.CpModule;
import software.coley.cafedude.classfile.constant.CpPackage;
import software.coley.cafedude.classfile.constant.CpUtf8;
import software.coley.cafedude.io.AnnotationWriter;
import software.coley.cafedude.io.ClassFileWriter;
import software.coley.cafedude.io.InstructionWriter;

public class AttributeWriter {
    private final ClassFileWriter writer;

    public AttributeWriter(@Nonnull ClassFileWriter writer) {
        this.writer = writer;
    }

    @Nonnull
    public byte[] writeAttribute(@Nonnull Attribute attribute) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        if (attribute instanceof DefaultAttribute) {
            DefaultAttribute dflt = (DefaultAttribute)attribute;
            out.writeShort(dflt.getName().getIndex());
            out.writeInt(dflt.getData().length);
            out.write(dflt.getData());
        } else {
            String attrName;
            CpUtf8 cpName = attribute.getName();
            out.writeShort(cpName.getIndex());
            out.writeInt(attribute.computeInternalLength());
            switch (attrName = cpName.getText()) {
                case "BootstrapMethods": {
                    BootstrapMethodsAttribute bsms = (BootstrapMethodsAttribute)attribute;
                    out.writeShort(bsms.getBootstrapMethods().size());
                    for (BootstrapMethodsAttribute.BootstrapMethod bsm : bsms.getBootstrapMethods()) {
                        out.writeShort(bsm.getBsmMethodRef().getIndex());
                        out.writeShort(bsm.getArgs().size());
                        for (CpEntry arg : bsm.getArgs()) {
                            out.writeShort(arg.getIndex());
                        }
                    }
                    break;
                }
                case "Code": {
                    CodeAttribute code = (CodeAttribute)attribute;
                    out.writeShort(code.getMaxStack());
                    out.writeShort(code.getMaxLocals());
                    InstructionWriter instructionWriter = new InstructionWriter(this.writer.getFallbackInstructionWriter());
                    byte[] codeBytes = instructionWriter.writeCode(code.getInstructions());
                    out.writeInt(codeBytes.length);
                    out.write(codeBytes);
                    out.writeShort(code.getExceptionTable().size());
                    for (CodeAttribute.ExceptionTableEntry tableEntry : code.getExceptionTable()) {
                        out.writeShort(tableEntry.getStartPc());
                        out.writeShort(tableEntry.getEndPc());
                        out.writeShort(tableEntry.getHandlerPc());
                        out.writeShort(this.orZero(tableEntry.getCatchType()));
                    }
                    out.writeShort(code.getAttributes().size());
                    for (Attribute subAttribute : code.getAttributes()) {
                        out.write(this.writeAttribute(subAttribute));
                    }
                    break;
                }
                case "ConstantValue": {
                    out.writeShort(((ConstantValueAttribute)attribute).getConstantValue().getIndex());
                    break;
                }
                case "EnclosingMethod": {
                    EnclosingMethodAttribute enclosingMethodAttribute = (EnclosingMethodAttribute)attribute;
                    out.writeShort(enclosingMethodAttribute.getClassEntry().getIndex());
                    out.writeShort(this.orZero(enclosingMethodAttribute.getMethodEntry()));
                    break;
                }
                case "Exceptions": {
                    ExceptionsAttribute exceptionsAttribute = (ExceptionsAttribute)attribute;
                    out.writeShort(exceptionsAttribute.getExceptionTable().size());
                    for (CpClass index : exceptionsAttribute.getExceptionTable()) {
                        out.writeShort(index.getIndex());
                    }
                    break;
                }
                case "InnerClasses": {
                    InnerClassesAttribute innerClassesAttribute = (InnerClassesAttribute)attribute;
                    out.writeShort(innerClassesAttribute.getInnerClasses().size());
                    for (InnerClassesAttribute.InnerClass ic : innerClassesAttribute.getInnerClasses()) {
                        out.writeShort(ic.getInnerClassInfo().getIndex());
                        out.writeShort(this.orZero(ic.getOuterClassInfo()));
                        out.writeShort(this.orZero(ic.getInnerName()));
                        out.writeShort(ic.getInnerClassAccessFlags());
                    }
                    break;
                }
                case "LineNumberTable": {
                    LineNumberTableAttribute lineNumbers = (LineNumberTableAttribute)attribute;
                    out.writeShort(lineNumbers.getEntries().size());
                    for (LineNumberTableAttribute.LineEntry entry : lineNumbers.getEntries()) {
                        out.writeShort(entry.getStartPc());
                        out.writeShort(entry.getLine());
                    }
                    break;
                }
                case "LocalVariableTable": {
                    LocalVariableTableAttribute varTable = (LocalVariableTableAttribute)attribute;
                    out.writeShort(varTable.getEntries().size());
                    for (LocalVariableTableAttribute.VarEntry entry : varTable.getEntries()) {
                        out.writeShort(entry.getStartPc());
                        out.writeShort(entry.getLength());
                        out.writeShort(entry.getName().getIndex());
                        out.writeShort(entry.getDesc().getIndex());
                        out.writeShort(entry.getIndex());
                    }
                    break;
                }
                case "LocalVariableTypeTable": {
                    LocalVariableTypeTableAttribute typeTable = (LocalVariableTypeTableAttribute)attribute;
                    out.writeShort(typeTable.getEntries().size());
                    for (LocalVariableTypeTableAttribute.VarTypeEntry entry : typeTable.getEntries()) {
                        out.writeShort(entry.getStartPc());
                        out.writeShort(entry.getLength());
                        out.writeShort(entry.getName().getIndex());
                        out.writeShort(entry.getSignature().getIndex());
                        out.writeShort(entry.getIndex());
                    }
                    break;
                }
                case "MethodParameters": {
                    MethodParametersAttribute methodParametersAttribute = (MethodParametersAttribute)attribute;
                    out.writeByte(methodParametersAttribute.getParameters().size());
                    for (MethodParametersAttribute.Parameter parameter : methodParametersAttribute.getParameters()) {
                        out.writeShort(this.orZero(parameter.getName()));
                        out.writeShort(parameter.getAccessFlags());
                    }
                    break;
                }
                case "Module": {
                    ModuleAttribute moduleAttribute = (ModuleAttribute)attribute;
                    out.writeShort(moduleAttribute.getModule().getIndex());
                    out.writeShort(moduleAttribute.getFlags());
                    out.writeShort(this.orZero(moduleAttribute.getVersion()));
                    out.writeShort(moduleAttribute.getRequires().size());
                    for (ModuleAttribute.Requires requires : moduleAttribute.getRequires()) {
                        out.writeShort(requires.getModule().getIndex());
                        out.writeShort(requires.getFlags());
                        out.writeShort(this.orZero(requires.getVersion()));
                    }
                    out.writeShort(moduleAttribute.getExports().size());
                    for (ModuleAttribute.Exports exports : moduleAttribute.getExports()) {
                        out.writeShort(exports.getPackageEntry().getIndex());
                        out.writeShort(exports.getFlags());
                        out.writeShort(exports.getTo().size());
                        for (CpModule to : exports.getTo()) {
                            out.writeShort(to.getIndex());
                        }
                    }
                    out.writeShort(moduleAttribute.getOpens().size());
                    for (ModuleAttribute.Opens opens : moduleAttribute.getOpens()) {
                        out.writeShort(opens.getPackageEntry().getIndex());
                        out.writeShort(opens.getFlags());
                        out.writeShort(opens.getTo().size());
                        for (CpModule to : opens.getTo()) {
                            out.writeShort(to.getIndex());
                        }
                    }
                    out.writeShort(moduleAttribute.getUses().size());
                    for (CpClass i : moduleAttribute.getUses()) {
                        out.writeShort(i.getIndex());
                    }
                    out.writeShort(moduleAttribute.getProvides().size());
                    for (ModuleAttribute.Provides provides : moduleAttribute.getProvides()) {
                        out.writeShort(provides.getModule().getIndex());
                        out.writeShort(provides.getWith().size());
                        for (CpClass i : provides.getWith()) {
                            out.writeShort(i.getIndex());
                        }
                    }
                    break;
                }
                case "NestHost": {
                    NestHostAttribute nestHost = (NestHostAttribute)attribute;
                    out.writeShort(nestHost.getHostClass().getIndex());
                    break;
                }
                case "NestMembers": {
                    NestMembersAttribute nestMembers = (NestMembersAttribute)attribute;
                    out.writeShort(nestMembers.getMemberClasses().size());
                    for (CpClass classIndex : nestMembers.getMemberClasses()) {
                        out.writeShort(classIndex.getIndex());
                    }
                    break;
                }
                case "Record": {
                    RecordAttribute recordAttribute = (RecordAttribute)attribute;
                    out.writeShort(recordAttribute.getComponents().size());
                    for (RecordAttribute.RecordComponent component : recordAttribute.getComponents()) {
                        out.writeShort(component.getName().getIndex());
                        out.writeShort(component.getDesc().getIndex());
                        out.writeShort(component.getAttributes().size());
                        for (Attribute subAttribute : component.getAttributes()) {
                            out.write(this.writeAttribute(subAttribute));
                        }
                    }
                    break;
                }
                case "RuntimeVisibleAnnotations": 
                case "RuntimeInvisibleAnnotations": {
                    new AnnotationWriter(out).writeAnnotations((AnnotationsAttribute)attribute);
                    break;
                }
                case "RuntimeVisibleParameterAnnotations": 
                case "RuntimeInvisibleParameterAnnotations": {
                    new AnnotationWriter(out).writeParameterAnnotations((ParameterAnnotationsAttribute)attribute);
                    break;
                }
                case "RuntimeVisibleTypeAnnotations": 
                case "RuntimeInvisibleTypeAnnotations": {
                    new AnnotationWriter(out).writeTypeAnnotations((AnnotationsAttribute)attribute);
                    break;
                }
                case "AnnotationDefault": {
                    new AnnotationWriter(out).writeAnnotationDefault((AnnotationDefaultAttribute)attribute);
                    break;
                }
                case "PermittedSubclasses": {
                    PermittedClassesAttribute permittedClasses = (PermittedClassesAttribute)attribute;
                    out.writeShort(permittedClasses.getClasses().size());
                    for (CpClass classIndex : permittedClasses.getClasses()) {
                        out.writeShort(classIndex.getIndex());
                    }
                    break;
                }
                case "Signature": {
                    SignatureAttribute signatureAttribute = (SignatureAttribute)attribute;
                    out.writeShort(signatureAttribute.getSignature().getIndex());
                    break;
                }
                case "SourceDebugExtension": {
                    SourceDebugExtensionAttribute debugExtension = (SourceDebugExtensionAttribute)attribute;
                    out.write(debugExtension.getDebugExtension());
                    break;
                }
                case "SourceFile": {
                    SourceFileAttribute sourceFileAttribute = (SourceFileAttribute)attribute;
                    out.writeShort(sourceFileAttribute.getSourceFilename().getIndex());
                    break;
                }
                case "StackMapTable": {
                    StackMapTableAttribute stackMapTable = (StackMapTableAttribute)attribute;
                    this.writeStackMapTable(out, stackMapTable);
                    break;
                }
                case "ModulePackages": {
                    ModulePackagesAttribute modulePackagesAttribute = (ModulePackagesAttribute)attribute;
                    out.writeShort(modulePackagesAttribute.getPackages().size());
                    for (CpPackage cpPackage : modulePackagesAttribute.getPackages()) {
                        out.writeShort(cpPackage.getIndex());
                    }
                    break;
                }
                case "ModuleTarget": {
                    ModuleTargetAttribute moduleTargetAttribute = (ModuleTargetAttribute)attribute;
                    out.writeShort(moduleTargetAttribute.getPlatformName().getIndex());
                    break;
                }
                case "ModuleHashes": {
                    ModuleHashesAttribute moduleHashesAttribute = (ModuleHashesAttribute)attribute;
                    out.writeShort(moduleHashesAttribute.getAlgorithmName().getIndex());
                    out.writeShort(moduleHashesAttribute.getModuleHashes().size());
                    for (Map.Entry<CpUtf8, byte[]> entry : moduleHashesAttribute.getModuleHashes().entrySet()) {
                        out.writeShort(entry.getKey().getIndex());
                        out.writeShort(entry.getValue().length);
                        out.write(entry.getValue());
                    }
                    break;
                }
                case "ModuleMainClass": {
                    ModuleMainClassAttribute moduleMainClassAttribute = (ModuleMainClassAttribute)attribute;
                    out.writeShort(moduleMainClassAttribute.getMainClass().getIndex());
                    break;
                }
                case "ModuleResolution": {
                    ModuleResolutionAttribute moduleResolutionAttribute = (ModuleResolutionAttribute)attribute;
                    out.writeShort(moduleResolutionAttribute.getFlags());
                    break;
                }
                case "CompilationID": {
                    CompilationIdAttribute compilationIdAttribute = (CompilationIdAttribute)attribute;
                    out.writeShort(compilationIdAttribute.getName().getIndex());
                    break;
                }
                case "SourceID": {
                    SourceIdAttribute sourceIdAttribute = (SourceIdAttribute)attribute;
                    out.writeShort(sourceIdAttribute.getName().getIndex());
                    break;
                }
                case "CharacterRangeTable": {
                    CharacterRangeTableAttribute characterRangeTableAttribute = (CharacterRangeTableAttribute)attribute;
                    List<CharacterRangeTableAttribute.CharacterRangeInfo> table = characterRangeTableAttribute.getCharacterRangeTable();
                    out.writeShort(table.size());
                    for (CharacterRangeTableAttribute.CharacterRangeInfo info : table) {
                        out.writeShort(info.getStartPc());
                        out.writeShort(info.getEndPc());
                        out.writeInt(info.getCharacterRangeStart());
                        out.writeInt(info.getCharacterRangeEnd());
                        out.writeShort(info.getFlags());
                    }
                    break;
                }
                case "Deprecated": 
                case "Synthetic": {
                    break;
                }
            }
        }
        return baos.toByteArray();
    }

    private int orZero(@Nullable CpEntry entry) {
        if (entry == null) {
            return 0;
        }
        return entry.getIndex();
    }

    private void writeVerificationType(DataOutputStream out, StackMapTableAttribute.TypeInfo type) throws IOException {
        out.writeByte(type.getTag());
        if (type instanceof StackMapTableAttribute.ObjectVariableInfo) {
            StackMapTableAttribute.ObjectVariableInfo objVar = (StackMapTableAttribute.ObjectVariableInfo)type;
            out.writeShort(objVar.getClassEntry().getIndex());
        } else if (type instanceof StackMapTableAttribute.UninitializedVariableInfo) {
            StackMapTableAttribute.UninitializedVariableInfo uninitVar = (StackMapTableAttribute.UninitializedVariableInfo)type;
            out.writeShort(uninitVar.getOffset());
        }
    }

    private void writeStackMapTable(DataOutputStream out, StackMapTableAttribute stackMapTable) throws IOException {
        out.writeShort(stackMapTable.getFrames().size());
        for (StackMapTableAttribute.StackMapFrame frame : stackMapTable.getFrames()) {
            out.writeByte(frame.getFrameType());
            if (frame instanceof StackMapTableAttribute.SameLocalsOneStackItem) {
                StackMapTableAttribute.SameLocalsOneStackItem sameLocals = (StackMapTableAttribute.SameLocalsOneStackItem)frame;
                this.writeVerificationType(out, sameLocals.getStack());
                continue;
            }
            if (frame instanceof StackMapTableAttribute.SameLocalsOneStackItemExtended) {
                StackMapTableAttribute.SameLocalsOneStackItemExtended sameLocals = (StackMapTableAttribute.SameLocalsOneStackItemExtended)frame;
                out.writeShort(sameLocals.getOffsetDelta());
                this.writeVerificationType(out, sameLocals.getStack());
                continue;
            }
            if (frame instanceof StackMapTableAttribute.ChopFrame) {
                StackMapTableAttribute.ChopFrame chopFrame = (StackMapTableAttribute.ChopFrame)frame;
                out.writeShort(chopFrame.getOffsetDelta());
                continue;
            }
            if (frame instanceof StackMapTableAttribute.SameFrameExtended) {
                StackMapTableAttribute.SameFrameExtended sameFrame = (StackMapTableAttribute.SameFrameExtended)frame;
                out.writeShort(sameFrame.getOffsetDelta());
                continue;
            }
            if (frame instanceof StackMapTableAttribute.AppendFrame) {
                StackMapTableAttribute.AppendFrame appendFrame = (StackMapTableAttribute.AppendFrame)frame;
                out.writeShort(appendFrame.getOffsetDelta());
                for (StackMapTableAttribute.TypeInfo type : appendFrame.getAdditionalLocals()) {
                    this.writeVerificationType(out, type);
                }
                continue;
            }
            if (!(frame instanceof StackMapTableAttribute.FullFrame)) continue;
            StackMapTableAttribute.FullFrame fullFrame = (StackMapTableAttribute.FullFrame)frame;
            out.writeShort(fullFrame.getOffsetDelta());
            out.writeShort(fullFrame.getLocals().size());
            for (StackMapTableAttribute.TypeInfo type : fullFrame.getLocals()) {
                this.writeVerificationType(out, type);
            }
            out.writeShort(fullFrame.getStack().size());
            for (StackMapTableAttribute.TypeInfo type : fullFrame.getStack()) {
                this.writeVerificationType(out, type);
            }
        }
    }
}

