/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.io;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.coley.cafedude.InvalidClassException;
import software.coley.cafedude.classfile.ClassFile;
import software.coley.cafedude.classfile.ConstPool;
import software.coley.cafedude.classfile.Field;
import software.coley.cafedude.classfile.Method;
import software.coley.cafedude.classfile.attribute.Attribute;
import software.coley.cafedude.classfile.constant.ConstDynamic;
import software.coley.cafedude.classfile.constant.ConstRef;
import software.coley.cafedude.classfile.constant.CpClass;
import software.coley.cafedude.classfile.constant.CpDouble;
import software.coley.cafedude.classfile.constant.CpDynamic;
import software.coley.cafedude.classfile.constant.CpEntry;
import software.coley.cafedude.classfile.constant.CpFieldRef;
import software.coley.cafedude.classfile.constant.CpFloat;
import software.coley.cafedude.classfile.constant.CpInt;
import software.coley.cafedude.classfile.constant.CpInterfaceMethodRef;
import software.coley.cafedude.classfile.constant.CpInvokeDynamic;
import software.coley.cafedude.classfile.constant.CpLong;
import software.coley.cafedude.classfile.constant.CpMethodHandle;
import software.coley.cafedude.classfile.constant.CpMethodRef;
import software.coley.cafedude.classfile.constant.CpMethodType;
import software.coley.cafedude.classfile.constant.CpModule;
import software.coley.cafedude.classfile.constant.CpNameType;
import software.coley.cafedude.classfile.constant.CpPackage;
import software.coley.cafedude.classfile.constant.CpString;
import software.coley.cafedude.classfile.constant.CpUtf8;
import software.coley.cafedude.classfile.constant.Placeholders;
import software.coley.cafedude.io.AttributeContext;
import software.coley.cafedude.io.AttributeReader;
import software.coley.cafedude.io.ClassBuilder;
import software.coley.cafedude.io.FallbackInstructionReader;
import software.coley.cafedude.io.IndexableByteStream;

public class ClassFileReader {
    private static final Logger logger = LoggerFactory.getLogger(ClassFileReader.class);
    private IndexableByteStream is;
    private boolean dropForwardVersioned = true;
    private boolean dropBadContextAttributes = true;
    private boolean dropEofAttributes = true;
    private boolean dropDupeAnnotations = true;
    private boolean checkCodeLength = true;

    @Nonnull
    public ClassFile read(@Nonnull byte[] code) throws InvalidClassException {
        ClassFile classFile;
        ClassBuilder builder = new ClassBuilder();
        IndexableByteStream is = new IndexableByteStream(code);
        try {
            this.is = is;
            if (is.readInt() != -889275714) {
                throw new InvalidClassException("Does not start with 0xCAFEBABE");
            }
            builder.setVersionMinor(is.readUnsignedShort());
            builder.setVersionMajor(is.readUnsignedShort());
            int numConstants = is.readUnsignedShort();
            int start = is.getIndex();
            ConstPool constPool = builder.getPool();
            for (int i = 1; i < numConstants; ++i) {
                CpEntry entry = this.readPoolEntryBasic();
                constPool.add(entry);
                if (!entry.isWide()) continue;
                ++i;
            }
            int diff = is.getIndex() - start;
            is.moveBack(diff);
            for (int i = 1; i < numConstants; ++i) {
                CpEntry entry = constPool.get(i);
                this.readPoolEntryResolve(constPool, entry);
                if (!entry.isWide()) continue;
                ++i;
            }
            builder.setAccess(is.readUnsignedShort());
            builder.setThisClass((CpClass)constPool.get(is.readUnsignedShort()));
            builder.setSuperClass((CpClass)constPool.get(is.readUnsignedShort()));
            int numInterfaces = is.readUnsignedShort();
            for (int i = 0; i < numInterfaces; ++i) {
                builder.addInterface((CpClass)constPool.get(is.readUnsignedShort()));
            }
            int numFields = is.readUnsignedShort();
            for (int i = 0; i < numFields; ++i) {
                builder.addField(this.readField(builder));
            }
            int numMethods = is.readUnsignedShort();
            for (int i = 0; i < numMethods; ++i) {
                builder.addMethod(this.readMethod(builder));
            }
            int numAttributes = is.readUnsignedShort();
            for (int i = 0; i < numAttributes; ++i) {
                Attribute attr = AttributeReader.readAttribute(this, builder, is, AttributeContext.CLASS);
                if (attr == null) continue;
                builder.addAttribute(attr);
            }
            constPool.removeIf(Placeholders::containsPlaceholder);
            classFile = builder.build();
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                logger.debug("IO error reading class", (Throwable)ex);
                throw new InvalidClassException(ex);
            }
            catch (Throwable t) {
                logger.debug("Error reading class", t);
                throw new InvalidClassException(t);
            }
        }
        is.close();
        return classFile;
    }

    @Nonnull
    private CpEntry readPoolEntryBasic() throws IOException, InvalidClassException {
        int tag = this.is.readUnsignedByte();
        switch (tag) {
            case 1: {
                return new CpUtf8(this.is.readUTF());
            }
            case 3: {
                return new CpInt(this.is.readInt());
            }
            case 4: {
                return new CpFloat(this.is.readFloat());
            }
            case 5: {
                return new CpLong(this.is.readLong());
            }
            case 6: {
                return new CpDouble(this.is.readDouble());
            }
            case 8: {
                this.is.readUnsignedShort();
                return new CpString(Placeholders.UTF8);
            }
            case 7: {
                this.is.readUnsignedShort();
                return new CpClass(Placeholders.UTF8);
            }
            case 9: {
                this.is.readUnsignedShort();
                this.is.readUnsignedShort();
                return new CpFieldRef(Placeholders.CLASS, Placeholders.NAME_TYPE);
            }
            case 10: {
                this.is.readUnsignedShort();
                this.is.readUnsignedShort();
                return new CpMethodRef(Placeholders.CLASS, Placeholders.NAME_TYPE);
            }
            case 11: {
                this.is.readUnsignedShort();
                this.is.readUnsignedShort();
                return new CpInterfaceMethodRef(Placeholders.CLASS, Placeholders.NAME_TYPE);
            }
            case 12: {
                this.is.readUnsignedShort();
                this.is.readUnsignedShort();
                return new CpNameType(Placeholders.UTF8, Placeholders.UTF8);
            }
            case 17: {
                int bsmIndex = this.is.readUnsignedShort();
                this.is.readUnsignedShort();
                return new CpDynamic(bsmIndex, Placeholders.NAME_TYPE);
            }
            case 15: {
                byte refKind = this.is.readByte();
                this.is.readUnsignedShort();
                return new CpMethodHandle(refKind, Placeholders.CONST_REF);
            }
            case 16: {
                this.is.readUnsignedShort();
                return new CpMethodType(Placeholders.UTF8);
            }
            case 18: {
                int bsmIndex2 = this.is.readUnsignedShort();
                this.is.readUnsignedShort();
                return new CpInvokeDynamic(bsmIndex2, Placeholders.NAME_TYPE);
            }
            case 19: {
                this.is.readUnsignedShort();
                return new CpModule(Placeholders.UTF8);
            }
            case 20: {
                this.is.readUnsignedShort();
                return new CpPackage(Placeholders.UTF8);
            }
        }
        throw new InvalidClassException("Unknown constant-pool tag: " + tag);
    }

    private void readPoolEntryResolve(@Nonnull ConstPool constPool, @Nonnull CpEntry entry) throws IOException, InvalidClassException {
        int tag = entry.getTag();
        if (tag != this.is.readUnsignedByte()) {
            throw new InvalidClassException("Constant pool tag mismatch");
        }
        switch (tag) {
            case 1: {
                this.is.readUTF();
                break;
            }
            case 3: {
                this.is.readInt();
                break;
            }
            case 4: {
                this.is.readFloat();
                break;
            }
            case 5: {
                this.is.readLong();
                break;
            }
            case 6: {
                this.is.readDouble();
                break;
            }
            case 8: {
                CpEntry param = constPool.get(this.is.readUnsignedShort());
                if (!(entry instanceof CpString)) break;
                CpString string = (CpString)entry;
                if (!(param instanceof CpUtf8)) break;
                CpUtf8 utf8 = (CpUtf8)param;
                string.setString(utf8);
                break;
            }
            case 7: {
                CpEntry param = constPool.get(this.is.readUnsignedShort());
                if (!(entry instanceof CpClass)) break;
                CpClass clazz = (CpClass)entry;
                if (!(param instanceof CpUtf8)) break;
                CpUtf8 utf8 = (CpUtf8)param;
                clazz.setName(utf8);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                CpEntry param1 = constPool.get(this.is.readUnsignedShort());
                CpEntry param2 = constPool.get(this.is.readUnsignedShort());
                if (!(entry instanceof ConstRef)) break;
                ConstRef ref = (ConstRef)entry;
                if (!(param1 instanceof CpClass)) break;
                CpClass clazz = (CpClass)param1;
                if (!(param2 instanceof CpNameType)) break;
                CpNameType nameType = (CpNameType)param2;
                ref.setClassRef(clazz);
                ref.setNameType(nameType);
                break;
            }
            case 12: {
                CpEntry param1 = constPool.get(this.is.readUnsignedShort());
                CpEntry param2 = constPool.get(this.is.readUnsignedShort());
                if (!(entry instanceof CpNameType)) break;
                CpNameType nameType = (CpNameType)entry;
                if (!(param1 instanceof CpUtf8)) break;
                CpUtf8 name = (CpUtf8)param1;
                if (!(param2 instanceof CpUtf8)) break;
                CpUtf8 type = (CpUtf8)param2;
                nameType.setName(name);
                nameType.setType(type);
                break;
            }
            case 17: 
            case 18: {
                this.is.readUnsignedShort();
                CpEntry param = constPool.get(this.is.readUnsignedShort());
                if (!(entry instanceof ConstDynamic)) break;
                ConstDynamic dynamic = (ConstDynamic)entry;
                if (!(param instanceof CpNameType)) break;
                CpNameType nameType = (CpNameType)param;
                dynamic.setNameType(nameType);
                break;
            }
            case 15: {
                this.is.readByte();
                CpEntry param = constPool.get(this.is.readUnsignedShort());
                if (!(entry instanceof CpMethodHandle)) break;
                CpMethodHandle methodHandle = (CpMethodHandle)entry;
                if (!(param instanceof ConstRef)) break;
                ConstRef ref = (ConstRef)param;
                methodHandle.setReference(ref);
                break;
            }
            case 16: {
                CpEntry param = constPool.get(this.is.readUnsignedShort());
                if (!(entry instanceof CpMethodType)) break;
                CpMethodType methodType = (CpMethodType)entry;
                if (!(param instanceof CpUtf8)) break;
                CpUtf8 type = (CpUtf8)param;
                methodType.setDescriptor(type);
                break;
            }
            case 19: {
                CpEntry param = constPool.get(this.is.readUnsignedShort());
                if (!(entry instanceof CpModule)) break;
                CpModule module = (CpModule)entry;
                if (!(param instanceof CpUtf8)) break;
                CpUtf8 name = (CpUtf8)param;
                module.setName(name);
                break;
            }
            case 20: {
                CpEntry param = constPool.get(this.is.readUnsignedShort());
                if (!(entry instanceof CpPackage)) break;
                CpPackage pkg = (CpPackage)entry;
                if (!(param instanceof CpUtf8)) break;
                CpUtf8 name = (CpUtf8)param;
                pkg.setPackageName(name);
                break;
            }
            default: {
                throw new IOException("Unknown CP tag: " + tag);
            }
        }
    }

    @Nonnull
    private Field readField(@Nonnull ClassBuilder builder) throws IOException {
        int access = this.is.readUnsignedShort();
        int nameIndex = this.is.readUnsignedShort();
        int descIndex = this.is.readUnsignedShort();
        int numAttributes = this.is.readUnsignedShort();
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(numAttributes);
        for (int i = 0; i < numAttributes; ++i) {
            Attribute attr = AttributeReader.readAttribute(this, builder, this.is, AttributeContext.FIELD);
            if (attr == null) continue;
            attributes.add(attr);
        }
        CpEntry nameEntry = builder.getPool().get(nameIndex);
        CpEntry descEntry = builder.getPool().get(descIndex);
        if (nameEntry instanceof CpUtf8) {
            CpUtf8 name = (CpUtf8)nameEntry;
            if (descEntry instanceof CpUtf8) {
                CpUtf8 type = (CpUtf8)descEntry;
                return new Field(attributes, access, name, type);
            }
        }
        throw new IOException("Field name/type index do not point to UTF8 values: " + nameIndex + "/" + descIndex);
    }

    @Nonnull
    private Method readMethod(@Nonnull ClassBuilder builder) throws IOException {
        int access = this.is.readUnsignedShort();
        int nameIndex = this.is.readUnsignedShort();
        int descIndex = this.is.readUnsignedShort();
        int numAttributes = this.is.readUnsignedShort();
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(numAttributes);
        for (int i = 0; i < numAttributes; ++i) {
            Attribute attr = AttributeReader.readAttribute(this, builder, this.is, AttributeContext.METHOD);
            if (attr == null) continue;
            attributes.add(attr);
        }
        CpEntry nameEntry = builder.getPool().get(nameIndex);
        CpEntry descEntry = builder.getPool().get(descIndex);
        if (nameEntry instanceof CpUtf8) {
            CpUtf8 name = (CpUtf8)nameEntry;
            if (descEntry instanceof CpUtf8) {
                CpUtf8 type = (CpUtf8)descEntry;
                return new Method(attributes, access, name, type);
            }
        }
        throw new IOException("Method name/type index do not point to UTF8 values: " + nameIndex + "/" + descIndex);
    }

    public boolean doDropForwardVersioned() {
        return this.dropForwardVersioned;
    }

    public void setDropForwardVersioned(boolean dropForwardVersioned) {
        this.dropForwardVersioned = dropForwardVersioned;
    }

    public boolean doDropBadContextAttributes() {
        return this.dropBadContextAttributes;
    }

    public void setDropBadContextAttributes(boolean dropBadContextAttributes) {
        this.dropBadContextAttributes = dropBadContextAttributes;
    }

    public boolean doDropEofAttributes() {
        return this.dropEofAttributes;
    }

    public void setDropEofAttributes(boolean dropEofAttributes) {
        this.dropEofAttributes = dropEofAttributes;
    }

    public boolean doDropDupeAnnotations() {
        return this.dropDupeAnnotations;
    }

    public void setDropDupeAnnotations(boolean dropDupeAnnotations) {
        this.dropDupeAnnotations = dropDupeAnnotations;
    }

    public boolean doCheckCodeLength() {
        return this.checkCodeLength;
    }

    public void setCheckCodeLength(boolean checkCodeLength) {
        this.checkCodeLength = checkCodeLength;
    }

    @Nonnull
    public FallbackInstructionReader getFallbackInstructionReader(@Nonnull ClassBuilder builder) {
        return FallbackInstructionReader.fail();
    }
}

