/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.io;

import jakarta.annotation.Nonnull;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import software.coley.cafedude.InvalidClassException;
import software.coley.cafedude.classfile.ClassFile;
import software.coley.cafedude.classfile.Field;
import software.coley.cafedude.classfile.Method;
import software.coley.cafedude.classfile.attribute.Attribute;
import software.coley.cafedude.classfile.constant.ConstRef;
import software.coley.cafedude.classfile.constant.CpClass;
import software.coley.cafedude.classfile.constant.CpDouble;
import software.coley.cafedude.classfile.constant.CpDynamic;
import software.coley.cafedude.classfile.constant.CpEntry;
import software.coley.cafedude.classfile.constant.CpFloat;
import software.coley.cafedude.classfile.constant.CpInt;
import software.coley.cafedude.classfile.constant.CpInvokeDynamic;
import software.coley.cafedude.classfile.constant.CpLong;
import software.coley.cafedude.classfile.constant.CpMethodHandle;
import software.coley.cafedude.classfile.constant.CpMethodType;
import software.coley.cafedude.classfile.constant.CpModule;
import software.coley.cafedude.classfile.constant.CpNameType;
import software.coley.cafedude.classfile.constant.CpPackage;
import software.coley.cafedude.classfile.constant.CpString;
import software.coley.cafedude.classfile.constant.CpUtf8;
import software.coley.cafedude.io.AttributeWriter;
import software.coley.cafedude.io.FallbackInstructionWriter;

public class ClassFileWriter {
    private DataOutputStream out;
    private AttributeWriter attributeWriter;
    private FallbackInstructionWriter fallbackInstructionWriter;

    public byte[] write(ClassFile clazz) throws InvalidClassException {
        Object object;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        try {
            this.out = out;
            this.attributeWriter = new AttributeWriter(this);
            this.fallbackInstructionWriter = this.newFallbackInstructionWriter(clazz);
            out.writeInt(-889275714);
            out.writeShort(clazz.getVersionMinor());
            out.writeShort(clazz.getVersionMajor());
            out.writeShort(clazz.getPool().size());
            for (CpEntry entry : clazz.getPool()) {
                this.writeCpEntry(entry);
            }
            out.writeShort(clazz.getAccess());
            CpClass superClass = clazz.getSuperClass();
            out.writeShort(clazz.getThisClass().getIndex());
            out.writeShort(superClass == null ? 0 : superClass.getIndex());
            out.writeShort(clazz.getInterfaceClasses().size());
            for (CpClass interfaceEntry : clazz.getInterfaceClasses()) {
                out.writeShort(interfaceEntry.getIndex());
            }
            out.writeShort(clazz.getFields().size());
            for (Field field : clazz.getFields()) {
                this.writeField(field);
            }
            out.writeShort(clazz.getMethods().size());
            for (Method method : clazz.getMethods()) {
                this.writeMethod(method);
            }
            out.writeShort(clazz.getAttributes().size());
            for (Attribute attribute : clazz.getAttributes()) {
                this.writeAttribute(attribute);
            }
            object = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new InvalidClassException(ex);
            }
        }
        out.close();
        return object;
    }

    private void writeCpEntry(CpEntry entry) throws IOException, InvalidClassException {
        int tag = entry.getTag();
        this.out.writeByte(tag);
        switch (tag) {
            case 1: {
                this.out.writeUTF(((CpUtf8)entry).getText());
                break;
            }
            case 3: {
                this.out.writeInt(((CpInt)entry).getValue());
                break;
            }
            case 4: {
                this.out.writeFloat(((CpFloat)entry).getValue());
                break;
            }
            case 5: {
                this.out.writeLong(((CpLong)entry).getValue());
                break;
            }
            case 6: {
                this.out.writeDouble(((CpDouble)entry).getValue());
                break;
            }
            case 8: {
                this.out.writeShort(((CpString)entry).getString().getIndex());
                break;
            }
            case 7: {
                this.out.writeShort(((CpClass)entry).getName().getIndex());
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                this.out.writeShort(((ConstRef)entry).getClassRef().getIndex());
                this.out.writeShort(((ConstRef)entry).getNameType().getIndex());
                break;
            }
            case 12: {
                this.out.writeShort(((CpNameType)entry).getName().getIndex());
                this.out.writeShort(((CpNameType)entry).getType().getIndex());
                break;
            }
            case 17: {
                this.out.writeShort(((CpDynamic)entry).getBsmIndex());
                this.out.writeShort(((CpDynamic)entry).getNameType().getIndex());
                break;
            }
            case 15: {
                this.out.writeByte(((CpMethodHandle)entry).getKind());
                this.out.writeShort(((CpMethodHandle)entry).getReference().getIndex());
                break;
            }
            case 16: {
                this.out.writeShort(((CpMethodType)entry).getDescriptor().getIndex());
                break;
            }
            case 18: {
                this.out.writeShort(((CpInvokeDynamic)entry).getBsmIndex());
                this.out.writeShort(((CpInvokeDynamic)entry).getNameType().getIndex());
                break;
            }
            case 19: {
                this.out.writeShort(((CpModule)entry).getName().getIndex());
                break;
            }
            case 20: {
                this.out.writeShort(((CpPackage)entry).getPackageName().getIndex());
                break;
            }
            default: {
                throw new InvalidClassException("Unknown constant-pool tag: " + tag);
            }
        }
    }

    private void writeAttribute(Attribute attribute) throws IOException, InvalidClassException {
        this.out.write(this.attributeWriter.writeAttribute(attribute));
    }

    private void writeField(Field field) throws IOException, InvalidClassException {
        this.out.writeShort(field.getAccess());
        this.out.writeShort(field.getName().getIndex());
        this.out.writeShort(field.getType().getIndex());
        this.out.writeShort(field.getAttributes().size());
        for (Attribute attribute : field.getAttributes()) {
            this.writeAttribute(attribute);
        }
    }

    private void writeMethod(Method method) throws IOException, InvalidClassException {
        this.out.writeShort(method.getAccess());
        this.out.writeShort(method.getName().getIndex());
        this.out.writeShort(method.getType().getIndex());
        this.out.writeShort(method.getAttributes().size());
        for (Attribute attribute : method.getAttributes()) {
            this.writeAttribute(attribute);
        }
    }

    @Nonnull
    public FallbackInstructionWriter newFallbackInstructionWriter(@Nonnull ClassFile classFile) {
        return FallbackInstructionWriter.fail();
    }

    @Nonnull
    protected final FallbackInstructionWriter getFallbackInstructionWriter() {
        return this.fallbackInstructionWriter;
    }
}

