/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.io;

import jakarta.annotation.Nonnull;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.Arrays;

public class IndexableByteStream
extends DataInputStream {
    private final IndexableByteArrayInputStream exposer;
    private int sliceStart;
    private int sliceEnd;

    public IndexableByteStream(byte[] data) {
        super(new IndexableByteArrayInputStream(data));
        this.exposer = (IndexableByteArrayInputStream)this.in;
    }

    public IndexableByteStream(@Nonnull IndexableByteStream is, int length) {
        this(is.exposer.getBuffer());
        int index = is.exposer.getIndex();
        int maxLength = is.exposer.getBuffer().length;
        this.moveTo(index);
        this.sliceStart = index;
        this.sliceEnd = Math.min(index + length, maxLength);
    }

    public int getAbsoluteIndex() {
        return this.exposer.getIndex();
    }

    public int getIndex() {
        return this.exposer.getIndex() - this.sliceStart;
    }

    public void moveToAbsolute(int index) {
        this.exposer.moveTo(index);
    }

    public void moveTo(int index) {
        this.exposer.moveTo(index + this.sliceStart);
    }

    public void moveBack(int distance) {
        this.exposer.moveBack(distance);
    }

    public boolean isBeyondSliceScope() {
        if (this.sliceStart == 0 && this.sliceEnd == 0) {
            return false;
        }
        int index = this.exposer.getIndex();
        return index > this.sliceEnd || index < this.sliceStart;
    }

    public byte[] getBuffer() {
        byte[] buffer = this.exposer.getBuffer();
        if (this.sliceStart == 0 && this.sliceEnd == 0) {
            return buffer;
        }
        return Arrays.copyOfRange(buffer, this.sliceStart, this.sliceEnd);
    }

    private static class IndexableByteArrayInputStream
    extends ByteArrayInputStream {
        private IndexableByteArrayInputStream(byte[] data) {
            super(data);
        }

        private void moveTo(int index) {
            this.pos = index;
        }

        private void moveBack(int distance) {
            this.pos -= distance;
        }

        private void moveForward(int distance) {
            this.pos += distance;
        }

        private int getIndex() {
            return this.pos;
        }

        private byte[] getBuffer() {
            return this.buf;
        }
    }
}

